/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.direct.DirectSimpleSocket;
import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.direct.NetworkPreference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;

public class DirectServerSocket {
    protected static final byte TYPE_SERVER = 7;
    protected static final byte TYPE_SERVER_WITH_FIREWALL = 8;
    protected static final byte TYPE_CLIENT_CHECK = 9;
    protected static final byte TYPE_CLIENT_NOCHECK = 10;
    protected static final byte ACCEPT = 47;
    protected static final byte WRONG_MACHINE = 48;
    protected static final byte FIREWALL_REFUSED = 49;
    private final ServerSocket serverSocket;
    private final DirectSocketAddress local;
    private final byte[] handShake;
    private final byte[] altHandShake;
    private DirectSocketAddress external;
    private final NetworkPreference preference;
    private final boolean haveFirewallRules;

    protected DirectServerSocket(DirectSocketAddress local, ServerSocket ss, NetworkPreference preference) {
        this.local = local;
        this.serverSocket = ss;
        this.preference = preference;
        byte[] tmp = local.getAddress();
        this.handShake = new byte[2 + tmp.length];
        this.handShake[0] = (byte)(tmp.length & 0xFF);
        this.handShake[1] = (byte)(tmp.length >> 8 & 0xFF);
        System.arraycopy(tmp, 0, this.handShake, 2, tmp.length);
        this.altHandShake = DirectSocketFactory.toBytes(5, local, 2);
        if (preference != null && preference.haveFirewallRules()) {
            this.haveFirewallRules = true;
            this.altHandShake[0] = 8;
        } else {
            this.haveFirewallRules = false;
            this.altHandShake[0] = 7;
        }
    }

    protected void addExternalAddress(DirectSocketAddress address) {
        this.external = this.external == null ? address : DirectSocketAddress.merge(this.external, address);
    }

    private void doClose(Socket s, InputStream in, OutputStream out) {
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DirectSocket accept() throws IOException {
        DirectSimpleSocket result = null;
        byte[] userIn = new byte[4];
        while (result == null) {
            Socket s = this.serverSocket.accept();
            InputStream in = null;
            OutputStream out = null;
            try {
                int opcode;
                s.setSoTimeout(10000);
                s.setTcpNoDelay(true);
                out = s.getOutputStream();
                out.write(this.altHandShake);
                out.flush();
                in = s.getInputStream();
                int type = DirectSocketFactory.readByte(in);
                DirectSocketFactory.readFully(in, userIn);
                int size = DirectSocketFactory.readByte(in) & 0xFF;
                byte[] tmp = DirectSocketFactory.readFully(in, new byte[size |= (DirectSocketFactory.readByte(in) & 0xFF) << 8]);
                size = DirectSocketFactory.readByte(in) & 0xFF;
                byte[] name = DirectSocketFactory.readFully(in, new byte[size |= (DirectSocketFactory.readByte(in) & 0xFF) << 8]);
                DirectSocketAddress sa = DirectSocketAddress.fromBytes(tmp);
                result = new DirectSimpleSocket(this.local, sa, in, out, s);
                int userData = (userIn[0] & 0xFF) << 24 | (userIn[1] & 0xFF) << 16 | (userIn[2] & 0xFF) << 8 | userIn[3] & 0xFF;
                result.setUserData(userData);
                if (this.haveFirewallRules) {
                    String network = new String(name);
                    if (this.preference.accept(sa.getAddressSet().addresses, network)) {
                        out.write(47);
                        out.flush();
                    } else {
                        out.write(49);
                        out.flush();
                        DirectSocketFactory.readByte(in);
                        this.doClose(s, in, out);
                        result = null;
                        continue;
                    }
                }
                if (type == 9 && (opcode = DirectSocketFactory.readByte(in)) != 47) {
                    this.doClose(s, in, out);
                    result = null;
                }
                s.setSoTimeout(0);
            }
            catch (IOException ie) {
                this.doClose(s, in, out);
                result = null;
            }
        }
        return result;
    }

    public void close() throws IOException {
        this.serverSocket.close();
    }

    public boolean isClosed() {
        return this.serverSocket.isClosed();
    }

    public ServerSocketChannel getChannel() {
        return this.serverSocket.getChannel();
    }

    public DirectSocketAddress getAddressSet() {
        if (this.external != null) {
            return DirectSocketAddress.merge(this.local, this.external);
        }
        return this.local;
    }

    public DirectSocketAddress getLocalAddressSet() {
        return this.local;
    }

    public DirectSocketAddress getExternalAddressSet() {
        return this.external;
    }

    public synchronized int getSoTimeout() throws IOException {
        return this.serverSocket.getSoTimeout();
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.serverSocket.setSoTimeout(timeout);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.serverSocket.getReuseAddress();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.serverSocket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.serverSocket.setReuseAddress(on);
    }

    public String toString() {
        return "DirectServerSocket(" + this.local + ", " + this.external + ")";
    }
}

