/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.GraphListener;
import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import java.awt.Dimension;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ZoomScroll
implements GraphListener {
    private static final int MAX = 19;
    private static final int MIN = -31;
    private static final int INITIAL = -4;
    protected ZoomLens zoomLens;
    private JSlider zoomSlider;
    private TGPanel tgPanel;
    private double zoomValue = -4.0;

    public ZoomScroll(TGPanel tgp) {
        this(tgp, false);
    }

    public ZoomScroll(TGPanel tgp, boolean auto) {
        this.tgPanel = tgp;
        if (!auto) {
            this.zoomSlider = new JSlider(1, -31, 19, -4);
            this.zoomSlider.addChangeListener(new ZoomChangeListener());
        }
        this.zoomLens = new ZoomLens();
        this.tgPanel.addGraphListener(this);
    }

    public JSlider getZoomSlider() {
        return this.zoomSlider;
    }

    public ZoomLens getLens() {
        return this.zoomLens;
    }

    @Override
    public void graphMoved() {
    }

    @Override
    public void graphReset() {
        if (this.zoomSlider != null) {
            this.zoomSlider.setValue(-10);
        } else {
            this.zoomValue = -10.0;
        }
    }

    public int getZoomValue() {
        if (this.zoomSlider != null) {
            double orientedValue = this.zoomSlider.getValue() - this.zoomSlider.getMinimum();
            double range = this.zoomSlider.getMaximum() - this.zoomSlider.getMinimum();
            return (int)(orientedValue / range * 200.0 - 100.0);
        }
        return (int)((this.zoomValue - -31.0) / 50.0 * 200.0) - 100;
    }

    public void setZoomValue(int value) {
        if (this.zoomSlider != null) {
            double range = this.zoomSlider.getMaximum() - this.zoomSlider.getMinimum();
            this.zoomSlider.setValue((int)((double)(value + 100) / 200.0 * range + 0.5) + this.zoomSlider.getMinimum());
        }
        this.zoomValue = (int)((double)(value + 100) / 200.0 * 50.0 + 0.5) + -31;
    }

    class ZoomLens
    extends TGAbstractLens {
        private int shiftx = 0;
        private int shifty = 0;

        ZoomLens() {
        }

        @Override
        protected void computeLens() {
            if (ZoomScroll.this.zoomSlider == null) {
                Dimension d = ZoomScroll.this.tgPanel.getSize();
                TGPoint2D tl = ZoomScroll.this.tgPanel.getTopLeft();
                TGPoint2D br = ZoomScroll.this.tgPanel.getBottomRight();
                int maxy = (int)br.y;
                int miny = (int)tl.y;
                double rangey = maxy - miny;
                int maxx = (int)br.x;
                int minx = (int)tl.x;
                double rangex = maxx - minx;
                double requiredZoom = rangex / (double)(d.width - 20);
                if (rangey / (double)d.height > requiredZoom) {
                    requiredZoom = rangey / (double)(d.height - 20);
                }
                if (requiredZoom <= 1.0) {
                    requiredZoom = 1.0;
                }
                this.shiftx = (maxx + minx) / 2;
                this.shifty = (maxy + miny) / 2;
                ZoomScroll.this.zoomValue = 10.0 * Math.log(1.0 / requiredZoom) / Math.log(2.0);
                if (ZoomScroll.this.zoomValue < -31.0) {
                    ZoomScroll.this.zoomValue = -31.0;
                }
                if (ZoomScroll.this.zoomValue > 19.0) {
                    ZoomScroll.this.zoomValue = 19.0;
                }
            }
        }

        @Override
        protected void applyLens(TGPoint2D p) {
            double val = ZoomScroll.this.zoomSlider != null ? (double)ZoomScroll.this.zoomSlider.getValue() : ZoomScroll.this.zoomValue;
            p.x = (p.x - (double)this.shiftx) * Math.pow(2.0, val / 10.0);
            p.y = (p.y - (double)this.shifty) * Math.pow(2.0, val / 10.0);
        }

        @Override
        protected void undoLens(TGPoint2D p) {
            double val = ZoomScroll.this.zoomSlider != null ? (double)ZoomScroll.this.zoomSlider.getValue() : ZoomScroll.this.zoomValue;
            p.x = p.x / Math.pow(2.0, val / 10.0) + (double)this.shiftx;
            p.y = p.y / Math.pow(2.0, val / 10.0) + (double)this.shifty;
        }
    }

    private class ZoomChangeListener
    implements ChangeListener {
        private ZoomChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ZoomScroll.this.tgPanel.repaintAfterMove();
        }
    }
}

