/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.TGPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Node
implements Comparable<Node> {
    public static final int TYPE_RECTANGLE = 1;
    public static final int TYPE_ROUNDRECT = 2;
    public static final int TYPE_ELLIPSE = 3;
    public static final int TYPE_CIRCLE = 4;
    public static final Font SMALL_TAG_FONT = new Font("Courier", 0, 9);
    private static final Color DEFAULT_BACK_FIXED_COLOR = new Color(255, 32, 20);
    private static final Color DEFAULT_BACK_SELECT_COLOR = new Color(255, 164, 0);
    private static final Color DEFAULT_BACK_DEFAULT_COLOR = Color.decode("#4080A0");
    private static final Color DEFAULT_BACK_HILIGHT_COLOR = new Color(205, 192, 166);
    private static final Color DEFAULT_BACK_MRF_COLOR = new Color(2, 35, 81);
    private static final Color DEFAULT_BACK_JML_COLOR = new Color(58, 176, 255);
    private static final Color DEFAULT_BORDER_DRAG_COLOR = new Color(130, 130, 180);
    private static final Color DEFAULT_BORDER_MOUSE_OVER_COLOR = new Color(160, 160, 180);
    private static final Color DEFAULT_BORDER_INACTIVE_COLOR = new Color(30, 50, 160);
    private static final Color DEFAULT_TEXT_COLOR = Color.black;
    public Color BACK_FIXED_COLOR = DEFAULT_BACK_FIXED_COLOR;
    public Color BACK_SELECT_COLOR = DEFAULT_BACK_SELECT_COLOR;
    public Color BACK_DEFAULT_COLOR = DEFAULT_BACK_DEFAULT_COLOR;
    public Color BACK_HILIGHT_COLOR = DEFAULT_BACK_HILIGHT_COLOR;
    public Color BACK_MRF_COLOR = DEFAULT_BACK_MRF_COLOR;
    public Color BACK_JML_COLOR = DEFAULT_BACK_JML_COLOR;
    public Color BORDER_DRAG_COLOR = DEFAULT_BORDER_DRAG_COLOR;
    public Color BORDER_MOUSE_OVER_COLOR = DEFAULT_BORDER_MOUSE_OVER_COLOR;
    public Color BORDER_INACTIVE_COLOR = DEFAULT_BORDER_INACTIVE_COLOR;
    public Color TEXT_COLOR = DEFAULT_TEXT_COLOR;
    public static Font TEXT_FONT = new Font("Verdana", 0, 10);
    public static Font TEXT_FONT_BOLD = new Font("Verdana Bold", 0, 10);
    public static int DEFAULT_TYPE = 1;
    protected int typ = 1;
    private String id;
    public double drawx;
    public double drawy;
    protected FontMetrics fontMetrics;
    protected Font font;
    protected String lbl;
    protected Color backColor = this.BACK_DEFAULT_COLOR;
    protected Color textColor = this.TEXT_COLOR;
    protected Paint backPaint = null;
    public double x;
    public double y;
    public double massfade = 1.0;
    protected double dx;
    protected double dy;
    protected boolean fixed;
    protected int repulsion;
    public boolean justMadeLocal = false;
    public boolean markedForRemoval = false;
    public int visibleEdgeCnt;
    protected boolean visible;
    private Collection<Edge> edges;
    private String[] mouseOverText;
    private String popup;
    private String strUrl;
    private boolean antiAlias;
    private int rank;

    public Node() {
        this.initialize(null);
        this.lbl = this.id;
        this.antiAlias = false;
    }

    public Node(String id) {
        this.initialize(id);
        this.lbl = id;
        this.antiAlias = false;
    }

    public Node(String id, String label) {
        this.initialize(id);
        this.lbl = label == null ? id : label;
        this.antiAlias = false;
    }

    public Node(String id, int type, Color color, String label) {
        this.initialize(id);
        this.typ = type;
        this.backColor = color;
        this.lbl = label == null ? id : label;
        this.antiAlias = false;
    }

    public Node(String id, int type, Color color, String label, boolean antiAlias) {
        this.initialize(id);
        this.typ = type;
        this.backColor = color;
        this.lbl = label == null ? id : label;
        this.antiAlias = antiAlias;
    }

    private void initialize(String identifier) {
        this.id = identifier;
        this.edges = Collections.synchronizedSet(new HashSet());
        this.x = Math.random() * 2.0 - 1.0;
        this.y = Math.random() * 2.0 - 1.0;
        this.repulsion = 100;
        this.font = TEXT_FONT;
        this.fixed = false;
        this.typ = DEFAULT_TYPE;
        this.visibleEdgeCnt = 0;
        this.visible = false;
    }

    public Iterable<Edge> getEdgeIterable() {
        return new EdgeIterable(this.edges);
    }

    public void setAntiAlias(boolean enabled) {
        this.antiAlias = enabled;
    }

    public void setNodeBackFixedColor(Color color) {
        this.BACK_FIXED_COLOR = color;
    }

    public void setNodeBackSelectColor(Color color) {
        this.BACK_SELECT_COLOR = color;
    }

    public void setNodeBackDefaultColor(Color color) {
        this.BACK_DEFAULT_COLOR = color;
    }

    public void setNodeBackHilightColor(Color color) {
        this.BACK_HILIGHT_COLOR = color;
    }

    public void setNodeBorderDragColor(Color color) {
        this.BORDER_DRAG_COLOR = color;
    }

    public void setNodeBorderMouseOverColor(Color color) {
        this.BORDER_MOUSE_OVER_COLOR = color;
    }

    public void setNodeBorderInactiveColor(Color color) {
        this.BORDER_INACTIVE_COLOR = color;
    }

    public void setNodeTextColor(Color color) {
        this.TEXT_COLOR = color;
    }

    public void setNodeTextFont(Font font) {
        TEXT_FONT = font;
    }

    public void setNodeType(int type) {
        DEFAULT_TYPE = type;
    }

    public void setMouseOverText(String[] text) {
        this.mouseOverText = text;
    }

    public void setPopup(String popup) {
        this.popup = popup;
    }

    public String getPopup() {
        return this.popup;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setLocation(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Point getLocation() {
        return new Point((int)this.x, (int)this.y);
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setType(int type) {
        this.typ = type;
    }

    public int getType() {
        return this.typ;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setBackColor(Color bgColor) {
        this.backColor = bgColor;
        this.backPaint = bgColor;
    }

    public void setBackPaint(Paint bgPaint) {
        this.backPaint = bgPaint;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setTextColor(Color txtColor) {
        this.textColor = txtColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setLabel(String label) {
        this.lbl = label;
    }

    public String getLabel() {
        return this.lbl;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean getFixed() {
        return this.fixed;
    }

    public int edgeNum() {
        return this.edges.size();
    }

    public int edgeCount() {
        return this.edges.size();
    }

    public int visibleEdgeCount() {
        return this.visibleEdgeCnt;
    }

    public void addEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        this.edges.add(edge);
    }

    public void removeEdge(Edge edge) {
        this.edges.remove(edge);
    }

    public int getWidth() {
        if (this.fontMetrics != null && this.lbl != null) {
            if (this.typ == 4 || this.typ == 3) {
                return this.fontMetrics.stringWidth(this.lbl) + 12;
            }
            return this.fontMetrics.stringWidth(this.lbl) + 35;
        }
        return 10;
    }

    public int getHeight() {
        if (this.fontMetrics != null) {
            return this.fontMetrics.getHeight() + 6;
        }
        return 6;
    }

    public boolean intersects(Dimension d) {
        return this.drawx > 0.0 && this.drawx < (double)d.width && this.drawy > 0.0 && this.drawy < (double)d.height;
    }

    public boolean containsPoint(double px, double py) {
        return px > this.drawx - (double)(this.getWidth() / 2) && px < this.drawx + (double)(this.getWidth() / 2) && py > this.drawy - (double)(this.getHeight() / 2) && py < this.drawy + (double)(this.getHeight() / 2);
    }

    public boolean containsPoint(Point p) {
        return (double)p.x > this.drawx - (double)(this.getWidth() / 2) && (double)p.x < this.drawx + (double)(this.getWidth() / 2) && (double)p.y > this.drawy - (double)(this.getHeight() / 2) && (double)p.y < this.drawy + (double)(this.getHeight() / 2);
    }

    public void paintTextTag(Graphics g, TGPanel tgPanel, int tagX, int tagY, Color backCol, Color textCol, String[] text) {
        g.setFont(SMALL_TAG_FONT);
        FontRenderContext frc = ((Graphics2D)g).getFontRenderContext();
        int maxX = 0;
        for (String s : text) {
            TextLayout layout = new TextLayout(s, SMALL_TAG_FONT, frc);
            maxX = Math.max(maxX, (int)layout.getBounds().getWidth());
        }
        int w = maxX + 14;
        int h = text.length * 10 + 2;
        g.setColor(backCol);
        g.fillRect(tagX, tagY + 15, w, h);
        g.setColor(textCol);
        for (int i = 0; i < text.length; ++i) {
            g.drawString(text[i], tagX + 7, tagY + 25 + i * 10);
        }
    }

    public void paint(Graphics g, TGPanel tgPanel) {
        this.paint(g, tgPanel, false);
    }

    public void paint(Graphics g, TGPanel tgPanel, boolean mouseOver) {
        String[] text;
        if (!this.intersects(tgPanel.getSize())) {
            return;
        }
        this.paintNodeBody(g, tgPanel);
        if (this.visibleEdgeCount() < this.edgeCount()) {
            int ix = (int)this.drawx;
            int iy = (int)this.drawy;
            int h = this.getHeight();
            int w = this.getWidth();
            int tagX = ix + (w - 7) / 2 - 2 + w % 2;
            int tagY = iy - h / 2 - 2;
            int hiddenEdgeCount = this.edgeCount() - this.visibleEdgeCount();
            char character = hiddenEdgeCount < 9 ? (char)(48 + hiddenEdgeCount) : (char)'*';
            this.paintSmallTag(g, tgPanel, tagX, tagY, Color.red, Color.white, character);
        }
        if (mouseOver && (text = this.mouseOverText) != null) {
            int ix = (int)this.drawx;
            int iy = (int)this.drawy;
            int h = this.getHeight();
            int w = this.getWidth();
            int tagX = ix + (w - 7) / 2 - 2 + w % 2;
            int tagY = iy - h / 2 - 2;
            this.paintTextTag(g, tgPanel, tagX, tagY, Color.white, Color.black, text);
        }
    }

    public Color getPaintBorderColor(TGPanel tgPanel) {
        if (this == tgPanel.getDragNode()) {
            return this.BORDER_DRAG_COLOR;
        }
        if (this == tgPanel.getMouseOverN()) {
            return this.BORDER_MOUSE_OVER_COLOR;
        }
        return this.BORDER_INACTIVE_COLOR;
    }

    public Color getPaintBackColor(TGPanel tgPanel) {
        if (this == tgPanel.getSelect()) {
            return this.BACK_SELECT_COLOR;
        }
        if (this.fixed) {
            return this.BACK_FIXED_COLOR;
        }
        if (this.markedForRemoval) {
            return this.BACK_MRF_COLOR;
        }
        if (this.justMadeLocal) {
            return this.BACK_JML_COLOR;
        }
        return this.backColor;
    }

    public Color getPaintTextColor(TGPanel tgPanel) {
        return this.textColor;
    }

    public void paintNodeBody(Graphics g, TGPanel tgPanel) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setFont(this.font.deriveFont(1));
        this.fontMetrics = g2.getFontMetrics();
        int ix = (int)this.drawx;
        int iy = (int)this.drawy;
        int h = this.getHeight();
        int w = this.getWidth();
        int r = h / 2 + 1;
        Color borderCol = this.getPaintBorderColor(tgPanel);
        g.setColor(borderCol);
        if (this.typ == 2) {
            g.fillRoundRect(ix - w / 2, iy - h / 2, w, h, r, r);
        } else if (this.typ == 3) {
            g.fillOval(ix - w / 2, iy - h / 2, w, h);
        } else if (this.typ == 4) {
            g.fillOval(ix - w / 2, iy - w / 2, w, w);
        } else {
            g.fillRect(ix - w / 2, iy - h / 2, w, h);
        }
        if (this.backPaint == null) {
            g.setColor(Color.WHITE);
            if (this.typ == 2) {
                g.fillRoundRect(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4, r, r);
            } else if (this.typ == 3) {
                g.fillOval(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4);
            } else if (this.typ == 4) {
                g.fillOval(ix - w / 2 + 2, iy - w / 2 + 2, w - 4, w - 4);
            } else {
                g.fillRect(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4);
            }
            Color backCol = this.getPaintBackColor(tgPanel);
            g.setColor(backCol);
            if (this.typ == 2) {
                g.fillRoundRect(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4, r, r);
            } else if (this.typ == 3) {
                g.fillOval(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4);
            } else if (this.typ == 4) {
                g.fillOval(ix - w / 2 + 2, iy - w / 2 + 2, w - 4, w - 4);
            } else {
                g.fillRect(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4);
            }
        } else {
            g2.setColor(Color.WHITE);
            if (this.typ == 2) {
                g2.fillRoundRect(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4, r, r);
            } else if (this.typ == 3) {
                g2.fillOval(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4);
            } else if (this.typ == 4) {
                g2.fillOval(ix - w / 2 + 2, iy - w / 2 + 2, w - 4, w - 4);
            } else {
                g2.fillRect(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4);
            }
            g2.setPaint(this.backPaint);
            if (this.typ == 2) {
                g2.fillRoundRect(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4, r, r);
            } else if (this.typ == 3) {
                g2.fillOval(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4);
            } else if (this.typ == 4) {
                g2.fillOval(ix - w / 2 + 2, iy - w / 2 + 2, w - 4, w - 4);
            } else {
                g2.fillRect(ix - w / 2 + 2, iy - h / 2 + 2, w - 4, h - 4);
            }
        }
        if (this.antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int len = this.fontMetrics.stringWidth(this.lbl);
        int descent = this.fontMetrics.getDescent() + 1;
        g2.setColor(this.TEXT_COLOR);
        g2.drawString(this.lbl, ix - len / 2, iy + descent);
    }

    public void paintSmallTag(Graphics g, TGPanel tgPanel, int tagX, int tagY, Color backCol, Color textCol, char character) {
        g.setColor(backCol);
        g.fillRect(tagX, tagY, 8, 8);
        g.setColor(textCol);
        g.setFont(SMALL_TAG_FONT);
        g.drawString("" + character, tagX + 2, tagY + 7);
    }

    public String getURL() {
        return this.strUrl;
    }

    public void setURL(String strUrl) {
        this.strUrl = strUrl;
    }

    @Override
    public int compareTo(Node arg0) {
        return arg0.rank - this.rank;
    }

    public static Color getDefaultBorderInactiveColor() {
        return DEFAULT_BORDER_INACTIVE_COLOR;
    }

    private static class EdgeIterable
    implements Iterable<Edge> {
        Edge[] edges;

        EdgeIterable(Collection<Edge> edges) {
            this.edges = edges.toArray(new Edge[edges.size()]);
        }

        @Override
        public Iterator<Edge> iterator() {
            return new EdgeIterator(this.edges);
        }
    }

    private static class EdgeIterator
    implements Iterator<Edge> {
        Edge[] edges;
        int i = 0;

        EdgeIterator(Edge[] edges) {
            this.edges = edges;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.edges.length;
        }

        @Override
        public Edge next() {
            if (this.i >= this.edges.length) {
                throw new NoSuchElementException("Iterator exhausted");
            }
            return this.edges[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

