/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.shared.ssh;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.esciencecenter.xenon.InvalidCredentialException;
import nl.esciencecenter.xenon.InvalidLocationException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.filesystems.sftp.SftpFileAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.ssh.SshSchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.shared.ssh.CertificateNotFoundException;
import nl.esciencecenter.xenon.credentials.CertificateCredential;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.credentials.DefaultCredential;
import nl.esciencecenter.xenon.credentials.PasswordCredential;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.local.ProxyAgentFactory;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.DefaultConfigFileHostEntryResolver;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.DefaultKnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.RejectAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSHUtil.class);
    public static final int DEFAULT_SSH_PORT = 22;

    private SSHUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static SshClient createSSHClient(boolean loadSSHConfig, boolean stricHostCheck, boolean addHostKey, boolean useSSHAgent, boolean useAgentForwarding) {
        SshClient client = SshClient.setUpDefaultClient();
        if (stricHostCheck) {
            if (addHostKey) {
                client.setServerKeyVerifier((ServerKeyVerifier)new DefaultKnownHostsServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE, true));
            } else {
                client.setServerKeyVerifier((ServerKeyVerifier)new DefaultKnownHostsServerKeyVerifier((ServerKeyVerifier)RejectAllServerKeyVerifier.INSTANCE, true));
            }
        } else {
            client.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
        }
        if (loadSSHConfig) {
            client.setHostConfigEntryResolver((HostConfigEntryResolver)DefaultConfigFileHostEntryResolver.INSTANCE);
        }
        if (useSSHAgent) {
            client.setAgentFactory((SshAgentFactory)new ProxyAgentFactory());
        }
        if (useAgentForwarding) {
            LOGGER.debug("(UNIMPLEMENTED) Enabling ssh-agent-forwarding");
        }
        client.start();
        return client;
    }

    public static String validateHost(String adaptorName, String host) throws InvalidLocationException {
        if (host == null || host.isEmpty()) {
            throw new InvalidLocationException(adaptorName, "Failed to parse host: " + host);
        }
        return host;
    }

    public static String getHost(String adaptorName, String location) throws InvalidLocationException {
        try {
            return SSHUtil.validateHost(adaptorName, HostAndPort.fromString((String)location).getHostText().trim());
        }
        catch (Exception e) {
            throw new InvalidLocationException(adaptorName, "Failed to parse location: " + location);
        }
    }

    public static int getPort(String adaptorName, String location) throws InvalidLocationException {
        try {
            return HostAndPort.fromString((String)location).getPortOrDefault(22);
        }
        catch (Exception e) {
            throw new InvalidLocationException(adaptorName, "Failed to parse location: " + location);
        }
    }

    public static ClientSession connect(String adaptorName, SshClient client, String location, Credential credential, long timeout) throws XenonException {
        URI uri;
        if (credential == null) {
            throw new IllegalArgumentException("Credential may not be null");
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Invalid timeout: " + timeout);
        }
        String username = credential.getUsername();
        if (username == null) {
            throw new XenonException(adaptorName, "Failed to retrieve username from credential");
        }
        try {
            uri = new URI("sftp://" + location);
        }
        catch (Exception e) {
            throw new InvalidLocationException(adaptorName, "Failed to parse location: " + location, e);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = 22;
        }
        ClientSession session = null;
        try {
            session = ((ConnectFuture)client.connect(username, host, port).verify(timeout)).getSession();
        }
        catch (IOException e) {
            throw new XenonException(adaptorName, "Connection setup timeout: " + host + ":" + port, e);
        }
        if (!(credential instanceof DefaultCredential)) {
            PasswordCredential c;
            if (credential instanceof CertificateCredential) {
                c = (CertificateCredential)credential;
                String certfile = ((CertificateCredential)c).getCertificateFile();
                Path path = Paths.get(certfile, new String[0]).toAbsolutePath().normalize();
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new CertificateNotFoundException(adaptorName, "Certificate not found: " + path);
                }
                KeyPair pair = null;
                try {
                    InputStream inputStream = Files.newInputStream(path, StandardOpenOption.READ);
                    char[] password = c.getPassword();
                    pair = password.length == 0 ? SecurityUtils.loadKeyPairIdentity((String)path.toString(), (InputStream)inputStream, null) : SecurityUtils.loadKeyPairIdentity((String)path.toString(), (InputStream)inputStream, (FilePasswordProvider)new PasswordProvider(password));
                }
                catch (Exception e) {
                    throw new XenonException(adaptorName, "Failed to load certificate: " + path, e);
                }
                session.addPublicKeyIdentity(pair);
            } else if (credential instanceof PasswordCredential) {
                c = (PasswordCredential)credential;
                session.addPasswordIdentity(new String(c.getPassword()));
            } else {
                throw new InvalidCredentialException(adaptorName, "Unsupported credential type: " + credential.getClass().getName());
            }
        }
        try {
            session.auth().verify(timeout);
        }
        catch (IOException e) {
            throw new XenonException(adaptorName, "Connection authentication timeout", e);
        }
        return session;
    }

    public static Map<String, String> translateProperties(Map<String, String> properties, Set<String> valid, String orginalPrefix, String newPrefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        int start = orginalPrefix.length();
        for (Map.Entry<String, String> e : properties.entrySet()) {
            String newKey;
            String key = e.getKey();
            if (!key.startsWith(orginalPrefix) || !valid.contains(newKey = newPrefix + key.substring(start, key.length()))) continue;
            result.put(newKey, e.getValue());
        }
        return result;
    }

    public static Set<String> validProperties(XenonPropertyDescription[] properties) {
        HashSet<String> result = new HashSet<String>();
        for (XenonPropertyDescription p : properties) {
            result.add(p.getName());
        }
        return result;
    }

    public static Map<String, String> sshToSftpProperties(Map<String, String> properties) {
        return SSHUtil.translateProperties(properties, SSHUtil.validProperties(SftpFileAdaptor.VALID_PROPERTIES), "xenon.adaptors.schedulers.ssh.", "xenon.adaptors.filesystems.sftp.");
    }

    public static Map<String, String> sftpToSshProperties(Map<String, String> properties) {
        return SSHUtil.translateProperties(properties, SSHUtil.validProperties(SshSchedulerAdaptor.VALID_PROPERTIES), "xenon.adaptors.filesystems.sftp.", "xenon.adaptors.schedulers.ssh.");
    }

    static class PasswordProvider
    implements FilePasswordProvider {
        private final char[] password;

        public PasswordProvider(char[] password) {
            this.password = (char[])password.clone();
        }

        public String getPassword(String resourceKey) throws IOException {
            return new String(this.password);
        }
    }
}

