/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.torque;

import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.CommandLineUtils;
import nl.esciencecenter.xenon.adaptors.schedulers.JobStatusImplementation;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingUtils;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.schedulers.InvalidJobDescriptionException;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TorqueUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorqueUtils.class);
    private static final int MINUTES_PER_HOUR = 60;
    public static final Pattern QUEUE_INFO_NAME = Pattern.compile("^Queue: ([a-zA-Z_]+)$");
    public static final String JOB_OPTION_JOB_SCRIPT = "job.script";
    public static final String JOB_OPTION_JOB_CONTENTS = "job.contents";
    public static final String JOB_OPTION_RESOURCES = "job.resources";
    private static final String[] VALID_JOB_OPTIONS = new String[]{"job.script", "job.resources"};

    private TorqueUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void verifyJobDescription(JobDescription description) throws XenonException {
        ScriptingUtils.verifyJobOptions(description.getJobOptions(), VALID_JOB_OPTIONS, "torque");
        if (description.getStdout() != null) {
            throw new InvalidJobDescriptionException("torque", "Torque adaptor cannot set STDOUT: a custom STDOUT is set internally");
        }
        if (description.getStderr() != null) {
            throw new InvalidJobDescriptionException("torque", "Torque adaptor cannot set STDERR: a custom STDERR is set internally");
        }
        if (description.getStdin() != null) {
            throw new InvalidJobDescriptionException("torque", "Torque cannot process STDIN");
        }
        if (description.getJobOptions().containsKey(JOB_OPTION_JOB_SCRIPT)) {
            if (description.getJobOptions().containsKey(JOB_OPTION_JOB_CONTENTS)) {
                throw new InvalidJobDescriptionException("torque", "Adaptor cannot process job script and job contents simultaneously.");
            }
            return;
        }
        ScriptingUtils.verifyJobDescription(description, "torque");
    }

    protected static JobStatus getJobStatusFromQstatInfo(Map<String, Map<String, String>> info, String jobIdentifier) throws XenonException {
        boolean done = false;
        Map<String, String> jobInfo = info.get(jobIdentifier);
        if (jobInfo == null) {
            return null;
        }
        ScriptingUtils.verifyJobInfo(jobInfo, jobIdentifier, "torque", "Job_Id", "job_state");
        String stateCode = jobInfo.get("job_state");
        XenonException exception = null;
        if (stateCode.equals("E")) {
            exception = new XenonException("torque", "Job reports error state: " + stateCode);
            done = true;
        }
        if (stateCode.equals("C")) {
            done = true;
        }
        Integer exitStatus = null;
        String exitStatusStr = jobInfo.get("exit_status");
        if (exitStatusStr != null) {
            exitStatus = Integer.valueOf(exitStatusStr);
        }
        return new JobStatusImplementation(jobIdentifier, stateCode, exitStatus, exception, stateCode.equals("R"), done, jobInfo);
    }

    public static void generateScriptContent(JobDescription description, Formatter script) {
        script.format("%s", description.getExecutable());
        for (String argument : description.getArguments()) {
            script.format(" %s", CommandLineUtils.protectAgainstShellMetas(argument));
        }
        script.format("\n", new Object[0]);
    }

    public static String generate(JobDescription description, Path fsEntryPath) {
        String resources;
        StringBuilder stringBuilder = new StringBuilder(500);
        Formatter script = new Formatter(stringBuilder, Locale.US);
        script.format("%s\n", "#!/bin/sh");
        script.format("%s\n", "#PBS -S /bin/sh");
        script.format("%s\n", "#PBS -N xenon");
        if (description.getWorkingDirectory() != null) {
            String workingDirectory = description.getWorkingDirectory();
            if (!workingDirectory.startsWith("/")) {
                workingDirectory = fsEntryPath.resolve(workingDirectory).toString();
            }
            script.format("#PBS -w '%s'\n", workingDirectory);
        }
        if (description.getQueueName() != null) {
            script.format("#PBS -q %s\n", description.getQueueName());
        }
        if ((resources = description.getJobOptions().get(JOB_OPTION_RESOURCES)) != null) {
            script.format("#PBS -l %s\n", resources);
        }
        script.format("#PBS -l nodes=%d:ppn=%d\n", description.getNodeCount(), description.getProcessesPerNode());
        script.format("#PBS -l walltime=%02d:%02d:00\n", description.getMaxRuntime() / 60, description.getMaxRuntime() % 60);
        for (Map.Entry<String, String> entry : description.getEnvironment().entrySet()) {
            script.format("export %s=\"%s\"\n", entry.getKey(), entry.getValue());
        }
        script.format("\n", new Object[0]);
        String customContents = description.getJobOptions().get(JOB_OPTION_JOB_CONTENTS);
        if (customContents == null) {
            TorqueUtils.generateScriptContent(description, script);
        } else {
            script.format("%s\n", customContents);
        }
        script.close();
        LOGGER.debug("Created job script:%n{}", (Object)stringBuilder);
        return stringBuilder.toString();
    }
}

