/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.torque;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import nl.esciencecenter.xenon.UnsupportedOperationException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.JobCanceledException;
import nl.esciencecenter.xenon.adaptors.schedulers.JobStatusImplementation;
import nl.esciencecenter.xenon.adaptors.schedulers.QueueStatusImplementation;
import nl.esciencecenter.xenon.adaptors.schedulers.RemoteCommandRunner;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingParser;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingScheduler;
import nl.esciencecenter.xenon.adaptors.schedulers.torque.TorqueSchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.torque.TorqueUtils;
import nl.esciencecenter.xenon.adaptors.schedulers.torque.TorqueXmlParser;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.JobStatus;
import nl.esciencecenter.xenon.schedulers.NoSuchJobException;
import nl.esciencecenter.xenon.schedulers.NoSuchQueueException;
import nl.esciencecenter.xenon.schedulers.QueueStatus;
import nl.esciencecenter.xenon.schedulers.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorqueScheduler
extends ScriptingScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorqueScheduler.class);
    private final long accountingGraceTime;
    private final Map<String, Long> lastSeenMap;
    private final Set<String> deletedJobs;
    private final TorqueXmlParser parser;
    private final String[] queueNames;

    TorqueScheduler(String uniqueID, String location, Credential credential, Map<String, String> prop) throws XenonException {
        super(uniqueID, "torque", location, credential, prop, TorqueSchedulerAdaptor.VALID_PROPERTIES, "xenon.adaptors.schedulers.torque.poll.delay");
        this.accountingGraceTime = this.properties.getLongProperty("xenon.adaptors.schedulers.torque.accounting.grace.time");
        this.parser = new TorqueXmlParser();
        this.lastSeenMap = new HashMap<String, Long>(30);
        this.deletedJobs = new HashSet<String>(10);
        this.queueNames = this.queryQueueNames();
    }

    private String[] queryQueueNames() throws XenonException {
        Set<String> queueNameSet = this.queryQueues(new String[0]).keySet();
        return queueNameSet.toArray(new String[queueNameSet.size()]);
    }

    @Override
    public String[] getQueueNames() {
        return (String[])this.queueNames.clone();
    }

    @Override
    public String getDefaultQueueName() {
        return null;
    }

    private synchronized void updateJobsSeenMap(Set<String> identifiers) {
        long currentTime = System.currentTimeMillis();
        for (String identifier : identifiers) {
            this.lastSeenMap.put(identifier, currentTime);
        }
        long expiredTime = currentTime + this.accountingGraceTime;
        Iterator<Map.Entry<String, Long>> iterator = this.lastSeenMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (entry.getValue() <= expiredTime) continue;
            iterator.remove();
        }
    }

    private synchronized boolean haveRecentlySeen(String identifier) {
        if (!this.lastSeenMap.containsKey(identifier)) {
            return false;
        }
        return this.lastSeenMap.get(identifier) + this.accountingGraceTime > System.currentTimeMillis();
    }

    private synchronized void addDeletedJob(String jobIdentifier) {
        this.deletedJobs.add(jobIdentifier);
    }

    private synchronized boolean jobWasDeleted(String jobIdentifier) {
        return this.deletedJobs.remove(jobIdentifier);
    }

    private void jobsFromStatus(String statusOutput, List<String> result) throws XenonException {
        Map<String, Map<String, String>> status = this.parser.parseJobInfos(statusOutput);
        this.updateJobsSeenMap(status.keySet());
        result.addAll(status.keySet());
    }

    @Override
    public String[] getJobs(String ... queueNames) throws XenonException {
        ArrayList<String> result = new ArrayList<String>(1500);
        if (queueNames == null || queueNames.length == 0) {
            String statusOutput = this.runCheckedCommand(null, "qstat", "-x").trim();
            this.jobsFromStatus(statusOutput, result);
        } else {
            for (String queueName : queueNames) {
                RemoteCommandRunner runner = this.runCommand(null, "qstat", "-x", queueName);
                if (!runner.success()) {
                    if (runner.getExitCode() == 172) {
                        LOGGER.warn("Failed to get queue status for queue {}", (Object)runner);
                        throw new NoSuchQueueException("torque", "Failed to get queue status for queue \"" + queueName + "\": " + runner);
                    }
                    throw new XenonException("torque", "Failed to get queue status for queue \"" + queueName + "\": " + runner);
                }
                this.jobsFromStatus(runner.getStdout(), result);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public QueueStatus getQueueStatus(String queueName) throws XenonException {
        this.assertNonNullOrEmpty(queueName, "Queue name may not be null or empty");
        Map<String, Map<String, String>> allMap = this.queryQueues(queueName);
        Map<String, String> map = allMap.get(queueName);
        if (map == null || map.isEmpty()) {
            throw new NoSuchQueueException("torque", "Cannot get status of queue \"" + queueName + "\" from server, perhaps it does not exist?");
        }
        return new QueueStatusImplementation(this, queueName, null, map);
    }

    @Override
    public QueueStatus[] getQueueStatuses(String ... queueNames) throws XenonException {
        if (queueNames == null) {
            throw new IllegalArgumentException("Queue names may not be null");
        }
        Map<String, Map<String, String>> allMap = this.queryQueues(queueNames);
        if (queueNames.length == 0) {
            queueNames = allMap.keySet().toArray(new String[allMap.size()]);
        }
        return this.getQueueStatuses(allMap, queueNames);
    }

    protected Map<String, Map<String, String>> queryQueues(String ... queueNames) throws XenonException {
        String output;
        if (queueNames == null) {
            throw new IllegalArgumentException("Queue names cannot be null");
        }
        if (queueNames.length == 0) {
            output = this.runCheckedCommand(null, "qstat", "-Qf");
        } else {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-Qf");
            for (String name : queueNames) {
                if (name == null) continue;
                args.add(name);
            }
            RemoteCommandRunner runner = this.runCommand(null, "qstat", args.toArray(new String[args.size()]));
            if (runner.success()) {
                output = runner.getStdout();
            } else {
                HashMap<String, Map<String, String>> badResult = new HashMap<String, Map<String, String>>(2);
                for (String name : queueNames) {
                    badResult.put(name, null);
                }
                return badResult;
            }
        }
        String[] lines = ScriptingParser.NEWLINE_REGEX.split(output);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(10);
        HashMap<String, String> currentQueueMap = null;
        for (String line : lines) {
            Matcher queueNameMatcher = TorqueUtils.QUEUE_INFO_NAME.matcher(line);
            if (queueNameMatcher.find()) {
                if (currentQueueMap != null) {
                    result.put((String)currentQueueMap.get("qname"), (Map<String, String>)currentQueueMap);
                }
                currentQueueMap = new HashMap<String, String>(lines.length);
                currentQueueMap.put("qname", queueNameMatcher.group(1));
                continue;
            }
            String[] keyVal = ScriptingParser.EQUALS_REGEX.split(line, 2);
            if (keyVal.length != 2) continue;
            if (currentQueueMap == null) {
                throw new XenonException("torque", "qstat does not follow syntax.");
            }
            currentQueueMap.put(keyVal[0], keyVal[1]);
        }
        if (currentQueueMap != null) {
            result.put((String)currentQueueMap.get("qname"), (Map<String, String>)currentQueueMap);
        }
        return result;
    }

    @Override
    public String submitBatchJob(JobDescription description) throws XenonException {
        String output;
        Path fsEntryPath = this.getWorkingDirectory();
        TorqueUtils.verifyJobDescription(description);
        this.checkQueue(this.queueNames, description.getQueueName());
        String customScriptFile = description.getJobOptions().get("job.script");
        if (customScriptFile == null) {
            this.checkWorkingDirectory(description.getWorkingDirectory());
            String jobScript = TorqueUtils.generate(description, fsEntryPath);
            output = this.runCheckedCommand(jobScript, "qsub", new String[0]);
        } else {
            if (!customScriptFile.startsWith("/")) {
                Path scriptFile = fsEntryPath.resolve(customScriptFile);
                customScriptFile = scriptFile.toString();
            }
            output = this.runCheckedCommand(null, "qsub", customScriptFile);
        }
        String identifier = ScriptingParser.parseJobIDFromLine(output, "torque", "");
        this.updateJobsSeenMap(Collections.singleton(identifier));
        if (!description.getJobOptions().containsKey("job.script")) {
            String[] idParts = identifier.split("\\.");
            try {
                long idNumber = Long.parseLong(idParts[0]);
                description.setStderr("xenon.e" + idNumber);
                description.setStdout("xenon.o" + idNumber);
            }
            catch (NumberFormatException ex) {
                LOGGER.warn("Standard out and standard err could not be set from Job ID {0}", (Object)identifier);
            }
        }
        return identifier;
    }

    @Override
    public Streams submitInteractiveJob(JobDescription description) throws XenonException {
        throw new UnsupportedOperationException("torque", "Interactive jobs not supported");
    }

    @Override
    public JobStatus cancelJob(String jobIdentifier) throws XenonException {
        this.assertNonNullOrEmpty(jobIdentifier, "Job identifier cannot be null or empty");
        RemoteCommandRunner runner = this.runCommand(null, "qdel", jobIdentifier);
        if (runner.success()) {
            this.addDeletedJob(jobIdentifier);
        } else if (runner.getExitCode() != 170) {
            throw new XenonException("torque", "could not run command qdel for job \"" + jobIdentifier + "\". Exit code = " + runner.getExitCode() + " Output: " + runner.getStdout() + " Error output: " + runner.getStderr());
        }
        return this.getJobStatus(jobIdentifier);
    }

    private Map<String, Map<String, String>> getQstatInfo() throws XenonException {
        RemoteCommandRunner runner = this.runCommand(null, "qstat", "-x");
        if (!runner.success()) {
            LOGGER.debug("failed to get job status {}", (Object)runner);
            return new HashMap<String, Map<String, String>>(0);
        }
        Map<String, Map<String, String>> result = this.parser.parseJobInfos(runner.getStdout());
        this.updateJobsSeenMap(result.keySet());
        return result;
    }

    private JobStatus getJobStatus(Map<String, Map<String, String>> qstatInfo, String job) throws XenonException {
        if (job == null) {
            return null;
        }
        JobStatus status = TorqueUtils.getJobStatusFromQstatInfo(qstatInfo, job);
        if (status != null && status.hasException()) {
            status = this.cancelJob(job);
        }
        if (status == null) {
            if (this.jobWasDeleted(job)) {
                JobCanceledException exception = new JobCanceledException("torque", "Job " + job + " deleted by user");
                status = new JobStatusImplementation(job, "killed", null, exception, false, true, null);
            } else if (this.haveRecentlySeen(job)) {
                status = new JobStatusImplementation(job, "unknown", null, null, false, true, new HashMap<String, String>(0));
            }
        } else if (status.isDone() && this.jobWasDeleted(job)) {
            JobCanceledException exception = new JobCanceledException("torque", "Job " + job + " deleted by user");
            status = new JobStatusImplementation(job, "killed", status.getExitCode(), exception, false, true, status.getSchedulerSpecificInformation());
        }
        return status;
    }

    @Override
    public JobStatus getJobStatus(String jobIdentifier) throws XenonException {
        this.assertNonNullOrEmpty(jobIdentifier, "Job identifier cannot be null or empty");
        Map<String, Map<String, String>> info = this.getQstatInfo();
        JobStatus result = this.getJobStatus(info, jobIdentifier);
        if (result == null) {
            throw new NoSuchJobException("torque", "Job " + jobIdentifier + " not found on server");
        }
        return result;
    }

    @Override
    public JobStatus[] getJobStatuses(String ... jobs) throws XenonException {
        Map<String, Map<String, String>> info = this.getQstatInfo();
        JobStatus[] result = new JobStatus[jobs.length];
        for (int i = 0; i < result.length; ++i) {
            if (jobs[i] == null) {
                result[i] = null;
                continue;
            }
            result[i] = this.getJobStatus(info, jobs[i]);
            if (result[i] != null) continue;
            NoSuchJobException exception = new NoSuchJobException("torque", "Job " + jobs[i] + " not found on server");
            result[i] = new JobStatusImplementation(jobs[i], null, null, exception, false, false, null);
        }
        return result;
    }
}

