/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.slurm;

import java.util.Map;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingSchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.slurm.SlurmScheduler;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.schedulers.Scheduler;

public class SlurmSchedulerAdaptor
extends ScriptingSchedulerAdaptor {
    public static final String ADAPTOR_NAME = "slurm";
    public static final String PREFIX = "xenon.adaptors.schedulers.slurm.";
    public static final String[] ADAPTOR_LOCATIONS = new String[]{"local://[/workdir]", "ssh://host[:port][/workdir]"};
    public static final String DISABLE_ACCOUNTING_USAGE = "xenon.adaptors.schedulers.slurm.disable.accounting.usage";
    public static final String POLL_DELAY_PROPERTY = "xenon.adaptors.schedulers.slurm.poll.delay";
    public static final String ADAPTOR_DESCRIPTION = "The Slurm Adaptor submits jobs to a Slurm scheduler.  This adaptor uses either the local or the ssh scheduler adaptor to run commands on the machine running Slurm,  and the file or the stfp filesystem adaptor to gain access to the filesystem of that machine.";
    public static final XenonPropertyDescription[] VALID_PROPERTIES = new XenonPropertyDescription[]{new XenonPropertyDescription("xenon.adaptors.schedulers.slurm.disable.accounting.usage", XenonPropertyDescription.Type.BOOLEAN, "false", "Do not use accounting info of slurm, even when available. Mostly for testing purposes"), new XenonPropertyDescription("xenon.adaptors.schedulers.slurm.poll.delay", XenonPropertyDescription.Type.LONG, "1000", "Number of milliseconds between polling the status of a job.")};
    public static final long SLURM_UPDATE_TIMEOUT = 60000L;
    public static final long SLURM_UPDATE_SLEEP = 1000L;
    public static final String[] SUPPORTED_VERSIONS = new String[]{"2.3.", "2.5.", "2.6.", "14.", "15.", "16.", "17."};

    public SlurmSchedulerAdaptor() {
        super(ADAPTOR_NAME, ADAPTOR_DESCRIPTION, ADAPTOR_LOCATIONS, VALID_PROPERTIES);
    }

    @Override
    public boolean supportsInteractive() {
        return true;
    }

    @Override
    public Scheduler createScheduler(String location, Credential credential, Map<String, String> properties) throws XenonException {
        return new SlurmScheduler(this.getNewUniqueID(), location, credential, properties);
    }
}

