/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.gridengine;

import java.util.Map;
import nl.esciencecenter.xenon.XenonException;

class ParallelEnvironmentInfo {
    private static final String ALLOCATION_PE_SLOTS = "$pe_slots";
    private static final String ALLOCATION_ROUND_ROBIN = "$round_robin";
    private static final String ALLOCATION_FILL_UP = "$fill_up";
    private final String name;
    private final int slots;
    private final AllocationRule allocationRule;
    private final int ppn;

    ParallelEnvironmentInfo(Map<String, String> info) throws XenonException {
        this.name = info.get("pe_name");
        if (this.name == null) {
            throw new XenonException("gridengine", "Cannot find name for parallel environment");
        }
        String slotsValue = info.get("slots");
        if (slotsValue == null) {
            throw new XenonException("gridengine", "Cannot find slots for parallel environment " + this.name);
        }
        try {
            this.slots = Integer.parseInt(slotsValue);
        }
        catch (NumberFormatException e) {
            throw new XenonException("gridengine", "Cannot parse slots for parallel environment " + this.name + ", got " + slotsValue, e);
        }
        String allocationValue = info.get("allocation_rule");
        if (allocationValue == null) {
            throw new XenonException("gridengine", "Cannot find allocation rule for parallel environment " + this.name);
        }
        if (allocationValue.equals(ALLOCATION_PE_SLOTS)) {
            this.allocationRule = AllocationRule.PE_SLOTS;
            this.ppn = 0;
        } else if (allocationValue.equals(ALLOCATION_ROUND_ROBIN)) {
            this.allocationRule = AllocationRule.ROUND_ROBIN;
            this.ppn = 0;
        } else if (allocationValue.equals(ALLOCATION_FILL_UP)) {
            this.allocationRule = AllocationRule.FILL_UP;
            this.ppn = 0;
        } else {
            this.allocationRule = AllocationRule.INTEGER;
            try {
                this.ppn = Integer.parseInt(allocationValue);
            }
            catch (NumberFormatException e) {
                throw new XenonException("gridengine", "Cannot parse allocation for parallel environment \"" + this.name + "\", expected a number, got \"" + allocationValue + "\"", e);
            }
        }
    }

    ParallelEnvironmentInfo(String name, int slots, AllocationRule allocationRule, int ppn) {
        this.name = name;
        this.slots = slots;
        this.allocationRule = allocationRule;
        this.ppn = ppn;
    }

    public String getName() {
        return this.name;
    }

    public int getSlots() {
        return this.slots;
    }

    public AllocationRule getAllocationRule() {
        return this.allocationRule;
    }

    public int getPpn() {
        return this.ppn;
    }

    public String toString() {
        return "ParallelEnvironmentInfo [name=" + this.name + ", slots=" + this.slots + ", allocationRule=" + (Object)((Object)this.allocationRule) + ", ppn=" + this.ppn + "]";
    }

    public static enum AllocationRule {
        INTEGER,
        PE_SLOTS,
        ROUND_ROBIN,
        FILL_UP;

    }
}

