/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.gridengine;

import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.CommandLineUtils;
import nl.esciencecenter.xenon.adaptors.schedulers.JobCanceledException;
import nl.esciencecenter.xenon.adaptors.schedulers.JobStatusImplementation;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingUtils;
import nl.esciencecenter.xenon.adaptors.schedulers.gridengine.GridEngineSetup;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.schedulers.InvalidJobDescriptionException;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GridEngineUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GridEngineUtils.class);
    public static final String JOB_OPTION_JOB_SCRIPT = "job.script";
    public static final String JOB_OPTION_PARALLEL_ENVIRONMENT = "parallel.environment";
    public static final String JOB_OPTION_PARALLEL_SLOTS = "parallel.slots";
    public static final String JOB_OPTION_RESOURCES = "resources";
    private static final String[] VALID_JOB_OPTIONS = new String[]{"job.script", "parallel.environment", "parallel.slots", "resources"};
    public static final String QACCT_HEADER = "==============================================================";
    private static final int MINUTES_PER_HOUR = 60;

    protected static void generateParallelEnvironmentSpecification(JobDescription description, GridEngineSetup setup, Formatter script) throws XenonException {
        int slots;
        Map<String, String> options = description.getJobOptions();
        String pe = options.get(JOB_OPTION_PARALLEL_ENVIRONMENT);
        String slotsString = options.get(JOB_OPTION_PARALLEL_SLOTS);
        if (slotsString == null) {
            slots = setup.calculateSlots(pe, description.getQueueName(), description.getNodeCount());
        } else {
            try {
                slots = Integer.parseInt(slotsString);
            }
            catch (NumberFormatException e) {
                throw new InvalidJobDescriptionException("gridengine", "Error in parsing parallel slots option \"" + slotsString + "\"", e);
            }
        }
        script.format("#$ -pe %s %d\n", pe, slots);
    }

    protected static void generateSerialScriptContent(JobDescription description, Formatter script) {
        script.format("%s", description.getExecutable());
        for (String argument : description.getArguments()) {
            script.format(" %s", CommandLineUtils.protectAgainstShellMetas(argument));
        }
        script.format("\n", new Object[0]);
    }

    protected static void generateParallelScriptContent(JobDescription description, Formatter script) {
        script.format("%s\n", "for host in `cat $PE_HOSTFILE | cut -d \" \" -f 1` ; do");
        for (int i = 0; i < description.getProcessesPerNode(); ++i) {
            script.format("%s", "  ssh -o StrictHostKeyChecking=false $host \"cd `pwd` && ");
            script.format("%s", description.getExecutable());
            for (String argument : description.getArguments()) {
                script.format(" %s", CommandLineUtils.protectAgainstShellMetas(argument));
            }
            script.format("%c&\n", Character.valueOf('\"'));
        }
        script.format("%s\n\n", "done");
        script.format("%s\n", "wait");
        script.format("%s\n\n", "exit 0");
    }

    private GridEngineUtils() {
        throw new IllegalStateException("Utility class");
    }

    protected static String generate(JobDescription description, Path fsEntryPath, GridEngineSetup setup) throws XenonException {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter script = new Formatter(stringBuilder, Locale.US);
        script.format("%s\n", "#!/bin/sh");
        script.format("%s\n", "#$ -S /bin/sh");
        script.format("%s\n", "#$ -N xenon");
        if (description.getWorkingDirectory() != null) {
            if (description.getWorkingDirectory().startsWith("/")) {
                script.format("#$ -wd '%s'\n", description.getWorkingDirectory());
            } else {
                Path workingDirectory = fsEntryPath.resolve(description.getWorkingDirectory());
                script.format("#$ -wd '%s'\n", workingDirectory.toString());
            }
        }
        if (description.getQueueName() != null) {
            script.format("#$ -q %s\n", description.getQueueName());
        }
        if (description.getNodeCount() > 1) {
            GridEngineUtils.generateParallelEnvironmentSpecification(description, setup, script);
        }
        script.format("#$ -l h_rt=%02d:%02d:00\n", description.getMaxRuntime() / 60, description.getMaxRuntime() % 60);
        String resources = description.getJobOptions().get(JOB_OPTION_RESOURCES);
        if (resources != null) {
            script.format("#$ -l %s\n", resources);
        }
        if (description.getStdin() != null) {
            script.format("#$ -i '%s'\n", description.getStdin());
        }
        if (description.getStdout() == null) {
            script.format("#$ -o /dev/null\n", new Object[0]);
        } else {
            script.format("#$ -o '%s'\n", description.getStdout());
        }
        if (description.getStderr() == null) {
            script.format("#$ -e /dev/null\n", new Object[0]);
        } else {
            script.format("#$ -e '%s'\n", description.getStderr());
        }
        for (Map.Entry<String, String> entry : description.getEnvironment().entrySet()) {
            script.format("export %s=\"%s\"\n", entry.getKey(), entry.getValue());
        }
        script.format("\n", new Object[0]);
        if (description.getNodeCount() == 1 && description.getProcessesPerNode() == 1) {
            GridEngineUtils.generateSerialScriptContent(description, script);
        } else {
            GridEngineUtils.generateParallelScriptContent(description, script);
        }
        script.close();
        LOGGER.debug("Created job script:%n{}", (Object)stringBuilder);
        return stringBuilder.toString();
    }

    protected static void verifyJobDescription(JobDescription description) throws XenonException {
        ScriptingUtils.verifyJobOptions(description.getJobOptions(), VALID_JOB_OPTIONS, "gridengine");
        if (description.isStartSingleProcess()) {
            throw new InvalidJobDescriptionException("gridengine", "StartSingleProcess option not supported");
        }
        if (description.getJobOptions().get(JOB_OPTION_JOB_SCRIPT) != null) {
            return;
        }
        ScriptingUtils.verifyJobDescription(description, "gridengine");
        if (description.getNodeCount() != 1) {
            if (!description.getJobOptions().containsKey(JOB_OPTION_PARALLEL_ENVIRONMENT)) {
                throw new InvalidJobDescriptionException("gridengine", "Parallel job requested but mandatory parallel.environment option not specificied.");
            }
            if (description.getQueueName() == null && !description.getJobOptions().containsKey(JOB_OPTION_PARALLEL_SLOTS)) {
                throw new InvalidJobDescriptionException("gridengine", "Parallel job requested but neither queue nor number of slots specificied (at least one is required)");
            }
        }
    }

    protected static JobStatus getJobStatusFromQacctInfo(Map<String, String> info, String jobIdentifier) throws XenonException {
        Integer exitcode;
        XenonException exception = null;
        String state = "done";
        if (info == null) {
            return null;
        }
        ScriptingUtils.verifyJobInfo(info, jobIdentifier, "gridengine", "jobnumber", "exit_status", "failed");
        String exitcodeString = info.get("exit_status");
        String failedString = info.get("failed");
        try {
            exitcode = Integer.parseInt(info.get("exit_status"));
        }
        catch (NumberFormatException e) {
            throw new XenonException("gridengine", "cannot parse exit code of job " + jobIdentifier + " from string " + exitcodeString, e);
        }
        if (!failedString.equals("0")) {
            exception = failedString.startsWith("100") ? new JobCanceledException("gridengine", "Job killed by signal") : new XenonException("gridengine", "Job reports error: " + failedString);
        }
        return new JobStatusImplementation(jobIdentifier, state, exitcode, exception, false, true, info);
    }

    protected static JobStatus getJobStatusFromQstatInfo(Map<String, Map<String, String>> info, String jobIdentifier) throws XenonException {
        boolean done = false;
        Map<String, String> jobInfo = info.get(jobIdentifier);
        if (jobInfo == null) {
            return null;
        }
        ScriptingUtils.verifyJobInfo(jobInfo, jobIdentifier, "gridengine", "JB_job_number", "state", "long_state");
        String longState = jobInfo.get("long_state");
        String stateCode = jobInfo.get("state");
        XenonException exception = null;
        if (stateCode.contains("E")) {
            exception = new XenonException("gridengine", "Job reports error state: " + stateCode);
            done = true;
        }
        return new JobStatusImplementation(jobIdentifier, longState, null, exception, "running".equals(longState), done, jobInfo);
    }
}

