/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.sftp;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import nl.esciencecenter.xenon.InvalidCredentialException;
import nl.esciencecenter.xenon.InvalidLocationException;
import nl.esciencecenter.xenon.InvalidPropertyException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.filesystems.FileAdaptor;
import nl.esciencecenter.xenon.adaptors.filesystems.sftp.SftpFileSystem;
import nl.esciencecenter.xenon.adaptors.shared.ssh.SSHUtil;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.NoSuchPathException;
import nl.esciencecenter.xenon.filesystems.Path;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpFileAdaptor
extends FileAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SftpFileAdaptor.class);
    public static final String ADAPTOR_NAME = "sftp";
    protected static final int DEFAULT_PORT = 22;
    public static final String ADAPTOR_DESCRIPTION = "The SFTP adaptor implements all file access functionality to remote SFTP servers";
    public static final String[] ADAPTOR_LOCATIONS = new String[]{"host[:port][/workdir]"};
    public static final String PREFIX = "xenon.adaptors.filesystems.sftp.";
    public static final String STRICT_HOST_KEY_CHECKING = "xenon.adaptors.filesystems.sftp.strictHostKeyChecking";
    public static final String AGENT = "xenon.adaptors.filesystems.sftp.agent";
    public static final String AGENT_FORWARDING = "xenon.adaptors.filesystems.sftp.agentForwarding";
    public static final String LOAD_STANDARD_KNOWN_HOSTS = "xenon.adaptors.filesystems.sftp.loadKnownHosts";
    public static final String LOAD_SSH_CONFIG = "xenon.adaptors.filesystems.sftp.loadSshConfig";
    public static final String SSH_CONFIG_FILE = "xenon.adaptors.filesystems.sftp.sshConfigFile";
    public static final String AUTOMATICALLY_ADD_HOST_KEY = "xenon.adaptors.filesystems.sftp.autoAddHostKey";
    public static final String GATEWAY = "xenon.adaptors.filesystems.sftp.gateway";
    public static final String CONNECTION_TIMEOUT = "xenon.adaptors.filesystems.sftp.connection.timeout";
    public static final String BUFFER_SIZE = "xenon.adaptors.filesystems.sftp.bufferSize";
    public static final XenonPropertyDescription[] VALID_PROPERTIES = new XenonPropertyDescription[]{new XenonPropertyDescription("xenon.adaptors.filesystems.sftp.autoAddHostKey", XenonPropertyDescription.Type.BOOLEAN, "true", "Automatically add unknown host keys to known_hosts."), new XenonPropertyDescription("xenon.adaptors.filesystems.sftp.strictHostKeyChecking", XenonPropertyDescription.Type.BOOLEAN, "true", "Enable strict host key checking."), new XenonPropertyDescription("xenon.adaptors.filesystems.sftp.loadKnownHosts", XenonPropertyDescription.Type.BOOLEAN, "true", "Load the standard known_hosts file."), new XenonPropertyDescription("xenon.adaptors.filesystems.sftp.loadSshConfig", XenonPropertyDescription.Type.BOOLEAN, "true", "Load the OpenSSH config file."), new XenonPropertyDescription("xenon.adaptors.filesystems.sftp.sshConfigFile", XenonPropertyDescription.Type.STRING, null, "OpenSSH config filename."), new XenonPropertyDescription("xenon.adaptors.filesystems.sftp.agent", XenonPropertyDescription.Type.BOOLEAN, "false", "Use a (local) ssh-agent."), new XenonPropertyDescription("xenon.adaptors.filesystems.sftp.agentForwarding", XenonPropertyDescription.Type.BOOLEAN, "false", "Use ssh-agent forwarding when setting up a connection."), new XenonPropertyDescription("xenon.adaptors.filesystems.sftp.connection.timeout", XenonPropertyDescription.Type.NATURAL, "10000", "The timeout for creating and authenticating connections (in milliseconds)."), new XenonPropertyDescription("xenon.adaptors.filesystems.sftp.bufferSize", XenonPropertyDescription.Type.SIZE, "64K", "The buffer size to use when copying files (in bytes).")};

    public SftpFileAdaptor() {
        super(ADAPTOR_NAME, ADAPTOR_DESCRIPTION, ADAPTOR_LOCATIONS, VALID_PROPERTIES);
    }

    @Override
    public boolean canCreateSymboliclinks() {
        return true;
    }

    @Override
    public FileSystem createFileSystem(String location, Credential credential, Map<String, String> properties) throws XenonException {
        LOGGER.debug("new SftpFileSystem location = {} credential = {} properties = {}", new Object[]{location, credential, properties});
        if (credential == null) {
            throw new InvalidCredentialException(ADAPTOR_NAME, "Credential may not be null");
        }
        XenonProperties xp = new XenonProperties(VALID_PROPERTIES, properties);
        long bufferSize = xp.getSizeProperty(BUFFER_SIZE);
        if (bufferSize <= 0L || bufferSize >= Integer.MAX_VALUE) {
            throw new InvalidPropertyException(ADAPTOR_NAME, "Invalid value for xenon.adaptors.filesystems.sftp.bufferSize: " + bufferSize + " (must be between 1 and " + Integer.MAX_VALUE + ")");
        }
        boolean loadSSHConfig = xp.getBooleanProperty(LOAD_SSH_CONFIG);
        boolean strictHostCheck = xp.getBooleanProperty(STRICT_HOST_KEY_CHECKING);
        boolean addHostKey = xp.getBooleanProperty(AUTOMATICALLY_ADD_HOST_KEY);
        boolean useSSHAgent = xp.getBooleanProperty(AGENT);
        boolean useAgentForwarding = xp.getBooleanProperty(AGENT_FORWARDING);
        SshClient client = SSHUtil.createSSHClient(loadSSHConfig, strictHostCheck, addHostKey, useSSHAgent, useAgentForwarding);
        long timeout = xp.getNaturalProperty(CONNECTION_TIMEOUT);
        ClientSession session = SSHUtil.connect(ADAPTOR_NAME, client, location, credential, timeout);
        SftpClient sftpClient = null;
        try {
            sftpClient = session.createSftpClient();
        }
        catch (IOException e) {
            client.close(true);
            throw new XenonException(ADAPTOR_NAME, "Failed to create SFTP session", e);
        }
        String cwd = null;
        try {
            cwd = this.getCurrentWorkingDirectory(sftpClient, location);
        }
        catch (Exception e) {
            client.close(true);
            throw e;
        }
        return new SftpFileSystem(this.getNewUniqueID(), ADAPTOR_NAME, location, new Path(cwd), (int)bufferSize, sftpClient, xp);
    }

    private String getCurrentWorkingDirectory(SftpClient sftpClient, String location) throws XenonException {
        try {
            String pathFromURI = new URI("sftp://" + location).getPath();
            if (pathFromURI == null || pathFromURI.isEmpty()) {
                return sftpClient.canonicalPath(".");
            }
            try {
                sftpClient.lstat(pathFromURI);
            }
            catch (IOException e) {
                throw new NoSuchPathException(ADAPTOR_NAME, "Specified working directory does not exist: " + pathFromURI);
            }
            return pathFromURI;
        }
        catch (URISyntaxException e) {
            throw new InvalidLocationException(ADAPTOR_NAME, "Failed to parse location: " + location, e);
        }
        catch (IOException e) {
            throw new XenonException(this.getName(), "Could not retrieve current working directory", e);
        }
    }

    @Override
    public boolean supportsReadingPosixPermissions() {
        return true;
    }

    @Override
    public boolean supportsSettingPosixPermissions() {
        return true;
    }
}

