/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.filesystems.PathAttributesImplementation;
import nl.esciencecenter.xenon.filesystems.DirectoryNotEmptyException;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.NoSuchPathException;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.filesystems.PathAttributes;
import nl.esciencecenter.xenon.filesystems.PosixFilePermission;
import nl.esciencecenter.xenon.utils.LocalFileSystemUtils;

public class LocalFileSystem
extends FileSystem {
    private final String root;

    protected LocalFileSystem(String uniqueID, String location, String root, Path entryPath, int bufferSize, XenonProperties properties) {
        super(uniqueID, "file", location, entryPath, bufferSize, properties);
        this.root = root;
    }

    java.nio.file.Path javaPath(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Path may not be null");
        }
        return FileSystems.getDefault().getPath(this.root, this.toAbsolutePath(path.normalize()).toString());
    }

    Set<PosixFilePermission> xenonPermissions(Set<java.nio.file.attribute.PosixFilePermission> permissions) {
        if (permissions == null) {
            return null;
        }
        HashSet<PosixFilePermission> result = new HashSet<PosixFilePermission>(permissions.size() * 4 / 3 + 1);
        for (java.nio.file.attribute.PosixFilePermission permission : permissions) {
            result.add(PosixFilePermission.valueOf(permission.toString()));
        }
        return result;
    }

    Set<java.nio.file.attribute.PosixFilePermission> javaPermissions(Set<PosixFilePermission> permissions) {
        if (permissions == null) {
            return new HashSet<java.nio.file.attribute.PosixFilePermission>(0);
        }
        HashSet<java.nio.file.attribute.PosixFilePermission> result = new HashSet<java.nio.file.attribute.PosixFilePermission>(permissions.size() * 4 / 3 + 1);
        for (PosixFilePermission permission : permissions) {
            result.add(java.nio.file.attribute.PosixFilePermission.valueOf(permission.toString()));
        }
        return result;
    }

    void deleteLocal(Path path) throws XenonException {
        try {
            Files.delete(this.javaPath(path));
        }
        catch (NoSuchFileException e1) {
            throw new NoSuchPathException("file", "File " + path + " does not exist!", e1);
        }
        catch (java.nio.file.DirectoryNotEmptyException e2) {
            throw new DirectoryNotEmptyException("file", "Directory " + path + " not empty!", e2);
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to delete file " + path, e);
        }
    }

    PathAttributes getLocalFileAttributes(Path path) throws XenonException {
        return this.getLocalFileAttributes(path, this.javaPath(path));
    }

    PathAttributes getLocalFileAttributes(Path p, java.nio.file.Path path) throws XenonException {
        try {
            BasicFileAttributes basicAttributes;
            PathAttributesImplementation result = new PathAttributesImplementation();
            result.setPath(p);
            result.setExecutable(Files.isExecutable(path));
            result.setReadable(Files.isReadable(path));
            result.setReadable(Files.isWritable(path));
            boolean isWindows = LocalFileSystemUtils.isWindows();
            if (isWindows) {
                result.setHidden(false);
                basicAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            } else {
                result.setHidden(Files.isHidden(path));
                PosixFileAttributes posixAttributes = Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                basicAttributes = posixAttributes;
                result.setOwner(posixAttributes.owner().getName());
                result.setGroup(posixAttributes.group().getName());
                result.setPermissions(this.xenonPermissions(posixAttributes.permissions()));
            }
            result.setCreationTime(basicAttributes.creationTime().toMillis());
            result.setLastAccessTime(basicAttributes.lastAccessTime().toMillis());
            result.setLastModifiedTime(basicAttributes.lastModifiedTime().toMillis());
            result.setDirectory(basicAttributes.isDirectory());
            result.setRegular(basicAttributes.isRegularFile());
            result.setSymbolicLink(basicAttributes.isSymbolicLink());
            result.setOther(basicAttributes.isOther());
            if (result.isRegular()) {
                result.setSize(basicAttributes.size());
            }
            return result;
        }
        catch (IOException e) {
            throw new XenonException("file", "Cannot read attributes.", e);
        }
    }

    @Override
    public boolean isOpen() throws XenonException {
        return true;
    }

    @Override
    public void rename(Path source, Path target) throws XenonException {
        Path absTarget;
        Path absSource = this.toAbsolutePath(source);
        if (this.areSamePaths(absSource, absTarget = this.toAbsolutePath(target))) {
            return;
        }
        this.assertPathExists(absSource);
        this.assertPathNotExists(absTarget);
        this.assertParentDirectoryExists(absTarget);
        try {
            Files.move(this.javaPath(absSource), this.javaPath(absTarget), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to move " + absSource + " to " + absTarget, e);
        }
    }

    @Override
    public void createDirectory(Path dir) throws XenonException {
        Path absdir = this.toAbsolutePath(dir);
        this.assertPathNotExists(absdir);
        this.assertParentDirectoryExists(absdir);
        try {
            Files.createDirectory(this.javaPath(absdir), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to create directory " + dir, e);
        }
    }

    @Override
    public void createFile(Path file) throws XenonException {
        Path absFile = this.toAbsolutePath(file);
        this.assertPathNotExists(absFile);
        this.assertParentDirectoryExists(absFile);
        try {
            Files.createFile(this.javaPath(absFile), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to create file " + absFile, e);
        }
    }

    @Override
    public void createSymbolicLink(Path link, Path path) throws XenonException {
        Path absLink = this.toAbsolutePath(link);
        this.assertPathNotExists(absLink);
        this.assertParentDirectoryExists(absLink);
        try {
            Files.createSymbolicLink(this.javaPath(absLink), this.javaPath(path), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to create link " + absLink + " to " + path, e);
        }
    }

    @Override
    protected void deleteFile(Path path) throws XenonException {
        this.deleteLocal(path);
    }

    @Override
    protected void deleteDirectory(Path path) throws XenonException {
        this.deleteLocal(path);
    }

    @Override
    public boolean exists(Path path) throws XenonException {
        return Files.exists(this.javaPath(this.toAbsolutePath(path)), LinkOption.NOFOLLOW_LINKS);
    }

    protected List<PathAttributes> listDirectory(Path dir) throws XenonException {
        try {
            ArrayList<PathAttributes> result = new ArrayList<PathAttributes>();
            DirectoryStream<java.nio.file.Path> s = Files.newDirectoryStream(this.javaPath(dir));
            for (java.nio.file.Path p : s) {
                result.add(this.getLocalFileAttributes(dir.resolve(p.getFileName().toString()), p));
            }
            s.close();
            return result;
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to list directory: " + dir, e);
        }
    }

    @Override
    public InputStream readFromFile(Path path) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        this.assertFileExists(absPath);
        try {
            return Files.newInputStream(this.javaPath(absPath), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to create InputStream.", e);
        }
    }

    @Override
    public OutputStream writeToFile(Path path, long size) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        this.assertPathNotExists(absPath);
        try {
            return Files.newOutputStream(this.javaPath(absPath), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to create OutputStream.", e);
        }
    }

    @Override
    public OutputStream writeToFile(Path path) throws XenonException {
        return this.writeToFile(path, -1L);
    }

    @Override
    public OutputStream appendToFile(Path path) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        this.assertFileExists(absPath);
        try {
            return Files.newOutputStream(this.javaPath(absPath), StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to create OutputStream.", e);
        }
    }

    @Override
    public PathAttributes getAttributes(Path path) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        this.assertPathExists(absPath);
        return this.getLocalFileAttributes(absPath);
    }

    @Override
    public Path readSymbolicLink(Path link) throws XenonException {
        Path absLink = this.toAbsolutePath(link);
        this.assertFileIsSymbolicLink(absLink);
        try {
            java.nio.file.Path path = this.javaPath(absLink);
            java.nio.file.Path target = Files.readSymbolicLink(path);
            Path parent = absLink.getParent();
            if (parent == null || target.isAbsolute()) {
                return new Path(absLink.getSeparator(), LocalFileSystemUtils.getLocalRootlessPath(target.toString()));
            }
            return parent.resolve(new Path(absLink.getSeparator(), LocalFileSystemUtils.getLocalRootlessPath(target.toString())));
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to read symbolic link.", e);
        }
    }

    @Override
    public void setPosixFilePermissions(Path path, Set<PosixFilePermission> permissions) throws XenonException {
        if (permissions == null) {
            throw new IllegalArgumentException("Permissions is null!");
        }
        Path absPath = this.toAbsolutePath(path);
        this.assertPathExists(absPath);
        try {
            PosixFileAttributeView view = Files.getFileAttributeView(this.javaPath(absPath), PosixFileAttributeView.class, new LinkOption[0]);
            view.setPermissions(this.javaPermissions(permissions));
        }
        catch (IOException e) {
            throw new XenonException("file", "Failed to set permissions " + absPath, e);
        }
    }
}

