/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.local;

import java.util.Map;
import nl.esciencecenter.xenon.InvalidCredentialException;
import nl.esciencecenter.xenon.InvalidPropertyException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.filesystems.FileAdaptor;
import nl.esciencecenter.xenon.adaptors.filesystems.local.LocalFileSystem;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.credentials.DefaultCredential;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.utils.LocalFileSystemUtils;

public class LocalFileAdaptor
extends FileAdaptor {
    public static final String ADAPTOR_NAME = "file";
    public static final String PREFIX = "xenon.adaptors.filesystems.file.";
    public static final String ADAPTOR_DESCRIPTION = "This is the local file adaptor that implements file functionality for local access.";
    public static final String[] ADAPTOR_LOCATIONS = new String[]{"(null)", "(empty string)", "[/workdir]", "driveletter:[/workdir]"};
    public static final String BUFFER_SIZE = "xenon.adaptors.filesystems.file.bufferSize";
    public static final XenonPropertyDescription[] VALID_PROPERTIES = new XenonPropertyDescription[]{new XenonPropertyDescription("xenon.adaptors.filesystems.file.bufferSize", XenonPropertyDescription.Type.SIZE, "64K", "The buffer size to use when copying files (in bytes).")};

    public LocalFileAdaptor() {
        super(ADAPTOR_NAME, ADAPTOR_DESCRIPTION, ADAPTOR_LOCATIONS, VALID_PROPERTIES);
    }

    @Override
    public boolean canCreateSymboliclinks() {
        return !LocalFileSystemUtils.isWindows();
    }

    @Override
    public boolean supportsReadingPosixPermissions() {
        return !LocalFileSystemUtils.isWindows();
    }

    @Override
    public boolean supportsSettingPosixPermissions() {
        return !LocalFileSystemUtils.isWindows();
    }

    @Override
    public boolean isConnectionless() {
        return true;
    }

    @Override
    public FileSystem createFileSystem(String location, Credential credential, Map<String, String> properties) throws XenonException {
        if (location == null || location.isEmpty()) {
            location = System.getProperty("user.dir");
        }
        String root = LocalFileSystemUtils.getLocalRoot(location);
        String path = LocalFileSystemUtils.getLocalRootlessPath(location);
        if (credential != null && !(credential instanceof DefaultCredential)) {
            throw new InvalidCredentialException(ADAPTOR_NAME, "Adaptor does not support this credential!");
        }
        XenonProperties xp = new XenonProperties(VALID_PROPERTIES, properties);
        long bufferSize = xp.getSizeProperty(BUFFER_SIZE);
        if (bufferSize <= 0L || bufferSize >= Integer.MAX_VALUE) {
            throw new InvalidPropertyException(ADAPTOR_NAME, "Invalid value for xenon.adaptors.filesystems.file.bufferSize: " + bufferSize + " (must be between 1 and " + Integer.MAX_VALUE + ")");
        }
        Path entry = new Path(LocalFileSystemUtils.getLocalSeparator(), path);
        return new LocalFileSystem(this.getNewUniqueID(), location, root, entry, (int)bufferSize, xp);
    }
}

