/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.smartsockets;

import ibis.io.DataOutputStream;
import ibis.io.SerializationFactory;
import ibis.io.SerializationOutput;
import ibis.io.SingleBufferArrayOutputStream;
import ibis.ipl.PortType;
import ibis.ipl.SendPort;
import ibis.ipl.WriteMessage;
import ibis.ipl.impl.smartsockets.SmartSocketsUltraLightSendPort;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SmartSocketsUltraLightWriteMessage
implements WriteMessage {
    private final SmartSocketsUltraLightSendPort port;
    private final SerializationOutput out;
    private final SingleBufferArrayOutputStream bout;

    SmartSocketsUltraLightWriteMessage(SmartSocketsUltraLightSendPort port, byte[] buffer) throws IOException {
        this.port = port;
        PortType type = port.getPortType();
        String serialization = null;
        serialization = type.hasCapability("serialization.data") ? "data" : (type.hasCapability("serialization.object.sun") ? "sun" : (type.hasCapability("serialization.object.ibis") ? "ibis" : (type.hasCapability("serialization.object") ? "object" : "byte")));
        this.bout = new SingleBufferArrayOutputStream(buffer);
        this.out = SerializationFactory.createSerializationOutput((String)serialization, (DataOutputStream)this.bout);
    }

    public long bytesWritten() throws IOException {
        return this.bout.bytesWritten();
    }

    public int capacity() throws IOException {
        return this.bout.bufferSize();
    }

    public int remaining() throws IOException {
        return (int)((long)this.bout.bufferSize() - this.bout.bytesWritten());
    }

    public long finish() throws IOException {
        this.out.flush();
        long bytes = this.bout.bytesWritten();
        this.port.finishedMessage();
        return bytes;
    }

    public void finish(IOException exception) {
        try {
            this.port.finishedMessage(exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    protected void resetBuffers() throws IOException {
        this.bout.reset();
        this.out.reset(true);
    }

    public void flush() throws IOException {
    }

    public SendPort localPort() {
        return this.port;
    }

    public void reset() throws IOException {
        this.resetBuffers();
    }

    public int send() throws IOException {
        return 0;
    }

    public void sync(int ticket) throws IOException {
    }

    public void writeArray(boolean[] value) throws IOException {
        this.out.writeArray(value);
    }

    public void writeArray(byte[] value) throws IOException {
        this.out.writeArray(value);
    }

    public void writeArray(char[] value) throws IOException {
        this.out.writeArray(value);
    }

    public void writeArray(short[] value) throws IOException {
        this.out.writeArray(value);
    }

    public void writeArray(int[] value) throws IOException {
        this.out.writeArray(value);
    }

    public void writeArray(long[] value) throws IOException {
        this.out.writeArray(value);
    }

    public void writeArray(float[] value) throws IOException {
        this.out.writeArray(value);
    }

    public void writeArray(double[] value) throws IOException {
        this.out.writeArray(value);
    }

    public void writeArray(Object[] value) throws IOException {
        this.out.writeArray(value);
    }

    public void writeArray(boolean[] value, int offset, int length) throws IOException {
        this.out.writeArray(value, offset, length);
    }

    public void writeArray(byte[] value, int offset, int length) throws IOException {
        this.out.writeArray(value, offset, length);
    }

    public void writeArray(char[] value, int offset, int length) throws IOException {
        this.out.writeArray(value, offset, length);
    }

    public void writeArray(short[] value, int offset, int length) throws IOException {
        this.out.writeArray(value, offset, length);
    }

    public void writeArray(int[] value, int offset, int length) throws IOException {
        this.out.writeArray(value, offset, length);
    }

    public void writeArray(long[] value, int offset, int length) throws IOException {
        this.out.writeArray(value, offset, length);
    }

    public void writeArray(float[] value, int offset, int length) throws IOException {
        this.out.writeArray(value, offset, length);
    }

    public void writeArray(double[] value, int offset, int length) throws IOException {
        this.out.writeArray(value, offset, length);
    }

    public void writeArray(Object[] value, int offset, int length) throws IOException {
        this.out.writeArray(value, offset, length);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.out.writeBoolean(value);
    }

    public void writeByte(byte value) throws IOException {
        this.out.writeByte(value);
    }

    public void writeChar(char value) throws IOException {
        this.out.writeChar(value);
    }

    public void writeDouble(double value) throws IOException {
        this.out.writeDouble(value);
    }

    public void writeFloat(float value) throws IOException {
        this.out.writeFloat(value);
    }

    public void writeInt(int value) throws IOException {
        this.out.writeInt(value);
    }

    public void writeLong(long value) throws IOException {
        this.out.writeDouble((double)value);
    }

    public void writeObject(Object value) throws IOException {
        this.out.writeObject(value);
    }

    public void writeShort(short value) throws IOException {
        this.out.writeShort(value);
    }

    public void writeString(String value) throws IOException {
        this.out.writeString(value);
    }

    public void writeByteBuffer(ByteBuffer value) throws IOException {
        this.out.writeByteBuffer(value);
    }
}

