/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.smartsockets;

import ibis.ipl.ConnectionFailedException;
import ibis.ipl.ConnectionsFailedException;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.SendPort;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.WriteMessage;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.smartsockets.SmartSocketsIbis;
import ibis.ipl.impl.smartsockets.SmartSocketsUltraLightWriteMessage;
import ibis.smartsockets.hub.servicelink.ServiceLink;
import ibis.smartsockets.util.MalformedAddressException;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import java.io.IOException;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartSocketsUltraLightSendPort
implements SendPort {
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    protected static final Logger logger = LoggerFactory.getLogger((String)"ibis.ipl.impl.smartsockets.SendPort");
    private final PortType type;
    private final String name;
    private final SmartSocketsIbis ibis;
    private final SendPortIdentifier sid;
    private boolean closed = false;
    private final SmartSocketsUltraLightWriteMessage message;
    private final byte[] buffer;
    private boolean messageInUse = false;
    private final Set<ibis.ipl.ReceivePortIdentifier> connections = new HashSet<ibis.ipl.ReceivePortIdentifier>();
    private final byte[][] messageToHub;

    SmartSocketsUltraLightSendPort(SmartSocketsIbis ibis, PortType type, String name, Properties props) throws IOException {
        this.ibis = ibis;
        this.type = type;
        this.name = name;
        this.sid = new ibis.ipl.impl.SendPortIdentifier(name, ibis.ident);
        this.buffer = new byte[65536];
        this.message = new SmartSocketsUltraLightWriteMessage(this, this.buffer);
        this.messageToHub = new byte[2][];
        this.messageToHub[0] = ibis.ident.toBytes();
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.notifyAll();
    }

    public synchronized void connect(ibis.ipl.ReceivePortIdentifier receiver) throws ConnectionFailedException {
        this.connections.add(receiver);
    }

    public void connect(ibis.ipl.ReceivePortIdentifier receiver, long timeoutMillis, boolean fillTimeout) throws ConnectionFailedException {
        this.connect(receiver);
    }

    public ibis.ipl.ReceivePortIdentifier connect(ibis.ipl.IbisIdentifier ibisIdentifier, String receivePortName) throws ConnectionFailedException {
        ReceivePortIdentifier id = new ReceivePortIdentifier(receivePortName, (IbisIdentifier)ibisIdentifier);
        this.connect((ibis.ipl.ReceivePortIdentifier)id);
        return id;
    }

    public ibis.ipl.ReceivePortIdentifier connect(ibis.ipl.IbisIdentifier ibisIdentifier, String receivePortName, long timeoutMillis, boolean fillTimeout) throws ConnectionFailedException {
        return this.connect(ibisIdentifier, receivePortName);
    }

    public void connect(ibis.ipl.ReceivePortIdentifier[] receivePortIdentifiers) throws ConnectionsFailedException {
        LinkedList<ConnectionFailedException> tmp = null;
        LinkedList<ibis.ipl.ReceivePortIdentifier> success = new LinkedList<ibis.ipl.ReceivePortIdentifier>();
        for (ibis.ipl.ReceivePortIdentifier id : receivePortIdentifiers) {
            try {
                this.connect(id);
                success.add(id);
            }
            catch (ConnectionFailedException e) {
                if (tmp == null) {
                    tmp = new LinkedList<ConnectionFailedException>();
                }
                tmp.add(e);
            }
        }
        if (tmp != null && tmp.size() > 0) {
            ConnectionsFailedException c = new ConnectionsFailedException("Failed to connect");
            for (ConnectionFailedException ex : tmp) {
                c.add(ex);
            }
            c.setObtainedConnections(success.toArray(new ibis.ipl.ReceivePortIdentifier[success.size()]));
            throw c;
        }
    }

    public void connect(ibis.ipl.ReceivePortIdentifier[] receivePortIdentifiers, long timeoutMillis, boolean fillTimeout) throws ConnectionsFailedException {
        this.connect(receivePortIdentifiers);
    }

    public ibis.ipl.ReceivePortIdentifier[] connect(Map<ibis.ipl.IbisIdentifier, String> ports) throws ConnectionsFailedException {
        ibis.ipl.ReceivePortIdentifier[] tmp = new ibis.ipl.ReceivePortIdentifier[ports.size()];
        int index = 0;
        for (Map.Entry<ibis.ipl.IbisIdentifier, String> e : ports.entrySet()) {
            tmp[index++] = new ReceivePortIdentifier(e.getValue(), (IbisIdentifier)e.getKey());
        }
        this.connect(tmp);
        return tmp;
    }

    public ibis.ipl.ReceivePortIdentifier[] connect(Map<ibis.ipl.IbisIdentifier, String> ports, long timeoutMillis, boolean fillTimeout) throws ConnectionsFailedException {
        return this.connect(ports);
    }

    public ibis.ipl.ReceivePortIdentifier[] connectedTo() {
        return this.connections.toArray(new ibis.ipl.ReceivePortIdentifier[0]);
    }

    public synchronized void disconnect(ibis.ipl.ReceivePortIdentifier receiver) throws IOException {
        if (!this.connections.remove(receiver)) {
            throw new IOException("Not connected to " + receiver);
        }
    }

    public void disconnect(ibis.ipl.IbisIdentifier ibisIdentifier, String receivePortName) throws IOException {
        this.disconnect((ibis.ipl.ReceivePortIdentifier)new ReceivePortIdentifier(receivePortName, (IbisIdentifier)ibisIdentifier));
    }

    public PortType getPortType() {
        return this.type;
    }

    public SendPortIdentifier identifier() {
        return this.sid;
    }

    public ibis.ipl.ReceivePortIdentifier[] lostConnections() {
        return new ibis.ipl.ReceivePortIdentifier[0];
    }

    public String name() {
        return this.name;
    }

    public synchronized WriteMessage newMessage() throws IOException {
        while (!this.closed && this.messageInUse) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.closed) {
            throw new IOException("Sendport is closed");
        }
        this.messageInUse = false;
        return this.message;
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        return null;
    }

    public Map<String, String> managementProperties() {
        return null;
    }

    public void printManagementProperties(PrintStream stream) {
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
    }

    private void send(byte[] data, int len) throws UnknownHostException, MalformedAddressException {
        ServiceLink link = this.ibis.getServiceLink();
        if (link == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("No servicelink available");
            }
            return;
        }
        this.messageToHub[1] = new byte[len];
        System.arraycopy(this.buffer, 0, this.messageToHub[1], 0, Math.min(len, this.buffer.length));
        for (ibis.ipl.ReceivePortIdentifier id : this.connections) {
            IbisIdentifier dst = (IbisIdentifier)id.ibisIdentifier();
            VirtualSocketAddress a = VirtualSocketAddress.fromBytes((byte[])dst.getImplementationData(), (int)0);
            if (logger.isDebugEnabled()) {
                logger.debug("Sending message to " + a);
            }
            link.send(a.machine(), a.hub(), id.name(), -559038737, this.messageToHub);
        }
    }

    public synchronized void finishedMessage() throws IOException {
        int len = (int)this.message.bytesWritten();
        byte[] m = this.buffer;
        try {
            this.send(m, len);
        }
        catch (Exception e) {
            logger.debug("Failed to send message to " + this.connections, (Throwable)e);
        }
        this.message.reset();
        this.messageInUse = false;
        this.notifyAll();
    }

    public synchronized void finishedMessage(IOException exception) throws IOException {
        this.message.reset();
        this.messageInUse = false;
        this.notifyAll();
    }
}

