/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.smartsockets;

import ibis.io.DataInputStream;
import ibis.io.SerializationFactory;
import ibis.io.SerializationInput;
import ibis.io.SingleBufferArrayInputStream;
import ibis.ipl.PortType;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.smartsockets.SmartSocketsUltraLightReceivePort;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public final class SmartSocketsUltraLightReadMessage
implements ReadMessage {
    private final SerializationInput in;
    private final SingleBufferArrayInputStream bin;
    private boolean isFinished = false;
    private boolean inUpcall = false;
    private boolean finishCalledFromUpcall = false;
    private final SendPortIdentifier origin;
    private final SmartSocketsUltraLightReceivePort port;

    SmartSocketsUltraLightReadMessage(SmartSocketsUltraLightReceivePort port, SendPortIdentifier origin, byte[] data) throws IOException {
        this.origin = origin;
        this.port = port;
        PortType type = port.getPortType();
        String serialization = null;
        serialization = type.hasCapability("serialization.data") ? "data" : (type.hasCapability("serialization.object.sun") ? "sun" : (type.hasCapability("serialization.object.ibis") ? "ibis" : (type.hasCapability("serialization.object") ? "object" : "byte")));
        this.bin = new SingleBufferArrayInputStream(data);
        this.in = SerializationFactory.createSerializationInput((String)serialization, (DataInputStream)this.bin);
    }

    public long bytesRead() throws IOException {
        return this.bin.bytesRead();
    }

    public int remaining() throws IOException {
        return this.bin.available();
    }

    public int size() throws IOException {
        return this.bin.size();
    }

    public void setInUpcall(boolean val) {
        this.inUpcall = val;
    }

    public boolean getInUpcall() {
        return this.inUpcall;
    }

    public boolean finishCalledInUpcall() {
        return this.finishCalledFromUpcall;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public long finish() throws IOException {
        if (this.isFinished) {
            throw new IOException("Operating on a message that was already finished");
        }
        this.isFinished = true;
        if (this.inUpcall) {
            this.finishCalledFromUpcall = true;
            this.port.newUpcallThread();
        }
        return this.bin.bytesRead();
    }

    public void finish(IOException e) {
        if (this.isFinished) {
            return;
        }
        this.isFinished = true;
        if (this.inUpcall) {
            this.finishCalledFromUpcall = true;
            this.port.newUpcallThread();
        }
    }

    public ReceivePort localPort() {
        return this.port;
    }

    public SendPortIdentifier origin() {
        return this.origin;
    }

    public void readArray(boolean[] destination) throws IOException {
        this.in.readArray(destination);
    }

    public void readArray(byte[] destination) throws IOException {
        this.in.readArray(destination);
    }

    public void readArray(char[] destination) throws IOException {
        this.in.readArray(destination);
    }

    public void readArray(short[] destination) throws IOException {
        this.in.readArray(destination);
    }

    public void readArray(int[] destination) throws IOException {
        this.in.readArray(destination);
    }

    public void readArray(long[] destination) throws IOException {
        this.in.readArray(destination);
    }

    public void readArray(float[] destination) throws IOException {
        this.in.readArray(destination);
    }

    public void readArray(double[] destination) throws IOException {
        this.in.readArray(destination);
    }

    public void readArray(Object[] destination) throws IOException, ClassNotFoundException {
        this.in.readArray(destination);
    }

    public void readArray(boolean[] destination, int offset, int size) throws IOException {
        this.in.readArray(destination, offset, size);
    }

    public void readArray(byte[] destination, int offset, int size) throws IOException {
        this.in.readArray(destination, offset, size);
    }

    public void readArray(char[] destination, int offset, int size) throws IOException {
        this.in.readArray(destination, offset, size);
    }

    public void readArray(short[] destination, int offset, int size) throws IOException {
        this.in.readArray(destination, offset, size);
    }

    public void readArray(int[] destination, int offset, int size) throws IOException {
        this.in.readArray(destination, offset, size);
    }

    public void readArray(long[] destination, int offset, int size) throws IOException {
        this.in.readArray(destination, offset, size);
    }

    public void readArray(float[] destination, int offset, int size) throws IOException {
        this.in.readArray(destination, offset, size);
    }

    public void readArray(double[] destination, int offset, int size) throws IOException {
        this.in.readArray(destination, offset, size);
    }

    public void readArray(Object[] destination, int offset, int size) throws IOException, ClassNotFoundException {
        this.in.readArray(destination, offset, size);
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this.in.readObject();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public String readString() throws IOException {
        return this.in.readString();
    }

    public long sequenceNumber() {
        return 0L;
    }

    public void readByteBuffer(ByteBuffer value) throws IOException, ReadOnlyBufferException {
        this.in.readByteBuffer(value);
    }
}

