/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.smartsockets;

import ibis.io.BufferedArrayInputStream;
import ibis.io.Conversion;
import ibis.io.DataInputStream;
import ibis.ipl.MessageUpcall;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.ReadMessage;
import ibis.ipl.impl.ReceivePort;
import ibis.ipl.impl.ReceivePortConnectionInfo;
import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.SendPortIdentifier;
import ibis.ipl.impl.smartsockets.SmartSocketsProtocol;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.util.Properties;

class SmartSocketsReceivePort
extends ReceivePort
implements SmartSocketsProtocol {
    private final boolean lazy_connectionhandler_thread;
    private boolean reader_busy = false;

    SmartSocketsReceivePort(Ibis ibis, PortType type, String name, MessageUpcall upcall, ReceivePortConnectUpcall connUpcall, Properties props) throws IOException {
        super(ibis, type, name, upcall, connUpcall, props);
        this.lazy_connectionhandler_thread = upcall == null && connUpcall == null && (type.hasCapability("connection.onetoone") || type.hasCapability("connection.onetomany")) && !type.hasCapability("receive.poll") && !type.hasCapability("receive.timeout");
    }

    private ReadMessage getPortMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(ReadMessage msg, boolean fromHandlerThread) {
        super.messageArrived(msg);
        if (fromHandlerThread && this.upcall == null) {
            SmartSocketsReceivePort smartSocketsReceivePort = this;
            synchronized (smartSocketsReceivePort) {
                while (!msg.isFinished()) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadMessage getMessage(long timeout) throws IOException {
        if (this.lazy_connectionhandler_thread) {
            SmartSocketsReceivePort smartSocketsReceivePort = this;
            synchronized (smartSocketsReceivePort) {
                if (this.message != null && !this.delivered) {
                    return super.getMessage(timeout);
                }
                while (this.reader_busy && !this.closed) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (this.message == null || this.delivered) continue;
                    return super.getMessage(timeout);
                }
                if (this.closed) {
                    throw new IOException("receive() on closed port");
                }
                this.reader_busy = true;
            }
            while (true) {
                smartSocketsReceivePort = this;
                synchronized (smartSocketsReceivePort) {
                    while (this.connections.size() == 0 && !this.closed) {
                        try {
                            this.wait();
                        }
                        catch (Exception e) {}
                    }
                    while (this.message != null && !this.closed) {
                        try {
                            this.wait();
                        }
                        catch (Exception e) {}
                    }
                    if (this.closed) {
                        this.reader_busy = false;
                        this.notifyAll();
                        throw new IOException("receive() on closed port");
                    }
                }
                ReceivePortConnectionInfo[] conns = this.connections();
                ((ConnectionHandler)conns[0]).reader(false);
                SmartSocketsReceivePort smartSocketsReceivePort2 = this;
                synchronized (smartSocketsReceivePort2) {
                    if (this.message != null) {
                        this.reader_busy = false;
                        this.notifyAll();
                        return this.message;
                    }
                }
            }
        }
        return super.getMessage(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(SendPortIdentifier origin, VirtualSocket s, BufferedArrayInputStream in) throws IOException {
        ConnectionHandler conn;
        SmartSocketsReceivePort smartSocketsReceivePort = this;
        synchronized (smartSocketsReceivePort) {
            conn = new ConnectionHandler(origin, s, this, in);
        }
        conn.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closePort(long timeout) {
        ReceivePortConnectionInfo[] conns = this.connections();
        if (this.lazy_connectionhandler_thread && conns.length > 0) {
            ReceivePortConnectionInfo receivePortConnectionInfo = conns[0];
            synchronized (receivePortConnectionInfo) {
                conns[0].notifyAll();
            }
        }
        super.closePort(timeout);
    }

    class ConnectionHandler
    extends ReceivePortConnectionInfo
    implements Runnable,
    SmartSocketsProtocol {
        private final VirtualSocket s;

        ConnectionHandler(SendPortIdentifier origin, VirtualSocket s, ReceivePort port, BufferedArrayInputStream in) throws IOException {
            super(origin, port, (DataInputStream)in);
            this.s = s;
        }

        public void close(Throwable e) {
            super.close(e);
            try {
                this.s.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public String connectionType() {
            return this.s.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info("Started connection handler thread");
            try {
                if (SmartSocketsReceivePort.this.lazy_connectionhandler_thread) {
                    int interval = 10;
                    while (true) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("lazy handler sleeping " + interval + " ms.");
                        }
                        ConnectionHandler connectionHandler = this;
                        synchronized (connectionHandler) {
                            try {
                                this.wait(interval);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        connectionHandler = this.port;
                        synchronized (connectionHandler) {
                            if (SmartSocketsReceivePort.this.reader_busy || ((SmartSocketsReceivePort)this.port).getPortMessage() != null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("lazy handler woke up, continues");
                                }
                                if (interval < 1000) {
                                    interval += 10;
                                }
                                continue;
                            }
                            if (this.closed) {
                                return;
                            }
                            SmartSocketsReceivePort.this.reader_busy = true;
                            interval = 10;
                        }
                        if (logger.isInfoEnabled()) {
                            logger.info("lazy handler starting read ...");
                        }
                        this.reader(true);
                        connectionHandler = this.port;
                        synchronized (connectionHandler) {
                            SmartSocketsReceivePort.this.reader_busy = false;
                            this.port.notifyAll();
                        }
                    }
                }
                this.reader(true);
            }
            catch (Throwable e) {
                if (logger.isInfoEnabled()) {
                    logger.info("ConnectionHandler.run, connected to " + this.origin + ", caught exception", e);
                }
                this.close(e);
            }
        }

        protected void upcallCalledFinish() {
            super.upcallCalledFinish();
            ThreadPool.createNew((Runnable)this, (String)"ConnectionHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reader(boolean fromHandlerThread) throws IOException {
            int opcode = -1;
            if (this.in == null) {
                this.newStream();
            }
            block18: while (this.in != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(SmartSocketsReceivePort.this.name + ": handler for " + this.origin + " woke up");
                }
                opcode = this.in.readByte();
                switch (opcode) {
                    case 1: {
                        if (logger.isDebugEnabled()) {
                            logger.debug(SmartSocketsReceivePort.this.name + ": Got a NEW_RECEIVER from " + this.origin);
                        }
                        this.newStream();
                        break;
                    }
                    case 2: {
                        if (logger.isDebugEnabled()) {
                            logger.debug(SmartSocketsReceivePort.this.name + ": Got a NEW_MESSAGE from " + this.origin);
                        }
                        this.message.setFinished(false);
                        if (SmartSocketsReceivePort.this.numbered) {
                            this.message.setSequenceNumber(this.message.readLong());
                        }
                        ReadMessage m = this.message;
                        SmartSocketsReceivePort.this.messageArrived(m, fromHandlerThread);
                        if (!SmartSocketsReceivePort.this.lazy_connectionhandler_thread && fromHandlerThread && !m.finishCalledInUpcall()) continue block18;
                        return;
                    }
                    case 3: {
                        if (logger.isDebugEnabled()) {
                            logger.debug(SmartSocketsReceivePort.this.name + ": Got a CLOSE_ALL_CONNECTIONS from " + this.origin);
                        }
                        this.close(null);
                        if (SmartSocketsReceivePort.this.lazy_connectionhandler_thread && !fromHandlerThread) {
                            ConnectionHandler connectionHandler = this;
                            synchronized (connectionHandler) {
                                this.notifyAll();
                            }
                        }
                        return;
                    }
                    case 4: {
                        if (logger.isDebugEnabled()) {
                            logger.debug(SmartSocketsReceivePort.this.name + ": Got a CLOSE_ONE_CONNECTION from " + this.origin);
                        }
                        byte[] length = new byte[4];
                        this.in.readArray(length);
                        byte[] bytes = new byte[Conversion.defaultConversion.byte2int(length, 0)];
                        this.in.readArray(bytes);
                        ReceivePortIdentifier identifier = new ReceivePortIdentifier(bytes);
                        if (!SmartSocketsReceivePort.this.ident.equals((Object)identifier)) continue block18;
                        if (logger.isDebugEnabled()) {
                            logger.debug(SmartSocketsReceivePort.this.name + ": disconnect from " + this.origin + ", fromHandlerThread = " + fromHandlerThread);
                        }
                        try {
                            this.in.close();
                        }
                        catch (Throwable z) {
                            // empty catch block
                        }
                        this.closed = true;
                        this.in = null;
                        if (logger.isDebugEnabled()) {
                            logger.debug(this.port.name + ": connection with " + this.origin + " closing");
                        }
                        this.port.lostConnection(this.origin, null);
                        this.s.getOutputStream().write(0);
                        try {
                            this.dataIn.close();
                        }
                        catch (Throwable z) {
                            // empty catch block
                        }
                        try {
                            this.s.close();
                        }
                        catch (Throwable x) {
                            // empty catch block
                        }
                        if (!SmartSocketsReceivePort.this.lazy_connectionhandler_thread || fromHandlerThread) continue block18;
                        ConnectionHandler connectionHandler = this;
                        synchronized (connectionHandler) {
                            this.notifyAll();
                            break;
                        }
                    }
                    default: {
                        throw new IOException(SmartSocketsReceivePort.this.name + ": Got illegal opcode " + opcode + " from " + this.origin);
                    }
                }
            }
        }
    }
}

