/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.nio;

import ibis.io.IOProperties;
import ibis.io.SimpleBigConversion;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class NioWrapBigConversion
extends SimpleBigConversion {
    public static final int BUFFER_SIZE = IOProperties.CONVERSION_BUFFER_SIZE;
    private ByteOrder order = ByteOrder.BIG_ENDIAN;
    private ByteBuffer byteBuffer = ByteBuffer.allocateDirect(BUFFER_SIZE).order(this.order);
    private CharBuffer charBuffer = this.byteBuffer.asCharBuffer();
    private ShortBuffer shortBuffer = this.byteBuffer.asShortBuffer();
    private IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
    private LongBuffer longBuffer = this.byteBuffer.asLongBuffer();
    private FloatBuffer floatBuffer = this.byteBuffer.asFloatBuffer();
    private DoubleBuffer doubleBuffer = this.byteBuffer.asDoubleBuffer();

    @Override
    public void char2byte(char[] src, int off, int len, byte[] dst, int off2) {
        if (len > BUFFER_SIZE / 2) {
            CharBuffer buffer = ByteBuffer.wrap(dst, off2, len * 2).order(this.order).asCharBuffer();
            buffer.put(src, off, len);
        } else {
            this.charBuffer.clear();
            this.charBuffer.put(src, off, len);
            this.byteBuffer.position(0).limit(len * 2);
            this.byteBuffer.get(dst, off2, len * 2);
        }
    }

    @Override
    public void byte2char(byte[] src, int index_src, char[] dst, int index_dst, int len) {
        if (len > BUFFER_SIZE / 2) {
            CharBuffer buffer = ByteBuffer.wrap(src, index_src, len * 2).order(this.order).asCharBuffer();
            buffer.get(dst, index_dst, len);
        } else {
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, len * 2);
            this.charBuffer.position(0).limit(len);
            this.charBuffer.get(dst, index_dst, len);
        }
    }

    @Override
    public void short2byte(short[] src, int off, int len, byte[] dst, int off2) {
        if (len > BUFFER_SIZE / 2) {
            ShortBuffer buffer = ByteBuffer.wrap(dst, off2, len * 2).order(this.order).asShortBuffer();
            buffer.put(src, off, len);
        } else {
            this.shortBuffer.clear();
            this.shortBuffer.put(src, off, len);
            this.byteBuffer.position(0).limit(len * 2);
            this.byteBuffer.get(dst, off2, len * 2);
        }
    }

    @Override
    public void byte2short(byte[] src, int index_src, short[] dst, int index_dst, int len) {
        if (len > BUFFER_SIZE / 2) {
            ShortBuffer buffer = ByteBuffer.wrap(src, index_src, len * 2).order(this.order).asShortBuffer();
            buffer.get(dst, index_dst, len);
        } else {
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, len * 2);
            this.shortBuffer.position(0).limit(len);
            this.shortBuffer.get(dst, index_dst, len);
        }
    }

    @Override
    public void int2byte(int[] src, int off, int len, byte[] dst, int off2) {
        if (len > BUFFER_SIZE / 4) {
            IntBuffer buffer = ByteBuffer.wrap(dst, off2, len * 4).order(this.order).asIntBuffer();
            buffer.put(src, off, len);
        } else {
            this.intBuffer.clear();
            this.intBuffer.put(src, off, len);
            this.byteBuffer.position(0).limit(len * 4);
            this.byteBuffer.get(dst, off2, len * 4);
        }
    }

    @Override
    public void byte2int(byte[] src, int index_src, int[] dst, int index_dst, int len) {
        if (len > BUFFER_SIZE / 4) {
            IntBuffer buffer = ByteBuffer.wrap(src, index_src, len * 4).order(this.order).asIntBuffer();
            buffer.get(dst, index_dst, len);
        } else {
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, len * 4);
            this.intBuffer.position(0).limit(len);
            this.intBuffer.get(dst, index_dst, len);
        }
    }

    @Override
    public void long2byte(long[] src, int off, int len, byte[] dst, int off2) {
        if (len > BUFFER_SIZE / 8) {
            LongBuffer buffer = ByteBuffer.wrap(dst, off2, len * 8).order(this.order).asLongBuffer();
            buffer.put(src, off, len);
        } else {
            this.longBuffer.clear();
            this.longBuffer.put(src, off, len);
            this.byteBuffer.position(0).limit(len * 8);
            this.byteBuffer.get(dst, off2, len * 8);
        }
    }

    @Override
    public void byte2long(byte[] src, int index_src, long[] dst, int index_dst, int len) {
        if (len > BUFFER_SIZE / 8) {
            LongBuffer buffer = ByteBuffer.wrap(src, index_src, len * 8).order(this.order).asLongBuffer();
            buffer.get(dst, index_dst, len);
        } else {
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, len * 8);
            this.longBuffer.position(0).limit(len);
            this.longBuffer.get(dst, index_dst, len);
        }
    }

    @Override
    public void float2byte(float[] src, int off, int len, byte[] dst, int off2) {
        if (len > BUFFER_SIZE / 4) {
            FloatBuffer buffer = ByteBuffer.wrap(dst, off2, len * 4).order(this.order).asFloatBuffer();
            buffer.put(src, off, len);
        } else {
            this.floatBuffer.clear();
            this.floatBuffer.put(src, off, len);
            this.byteBuffer.position(0).limit(len * 4);
            this.byteBuffer.get(dst, off2, len * 4);
        }
    }

    @Override
    public void byte2float(byte[] src, int index_src, float[] dst, int index_dst, int len) {
        if (len > BUFFER_SIZE / 4) {
            FloatBuffer buffer = ByteBuffer.wrap(src, index_src, len * 4).order(this.order).asFloatBuffer();
            buffer.get(dst, index_dst, len);
        } else {
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, len * 4);
            this.floatBuffer.position(0).limit(len);
            this.floatBuffer.get(dst, index_dst, len);
        }
    }

    @Override
    public void double2byte(double[] src, int off, int len, byte[] dst, int off2) {
        if (len > BUFFER_SIZE / 8) {
            DoubleBuffer buffer = ByteBuffer.wrap(dst, off2, len * 8).order(this.order).asDoubleBuffer();
            buffer.put(src, off, len);
        } else {
            this.doubleBuffer.clear();
            this.doubleBuffer.put(src, off, len);
            this.byteBuffer.position(0).limit(len * 8);
            this.byteBuffer.get(dst, off2, len * 8);
        }
    }

    @Override
    public void byte2double(byte[] src, int index_src, double[] dst, int index_dst, int len) {
        if (len > BUFFER_SIZE / 8) {
            DoubleBuffer buffer = ByteBuffer.wrap(src, index_src, len * 8).order(this.order).asDoubleBuffer();
            buffer.get(dst, index_dst, len);
        } else {
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, len * 8);
            this.doubleBuffer.position(0).limit(len);
            this.doubleBuffer.get(dst, index_dst, len);
        }
    }
}

