/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.DataInputStream;
import ibis.io.DataOutputStream;
import ibis.io.IbisIOException;
import ibis.io.SerializationInput;
import ibis.io.SerializationOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class SerializationFactory {
    private static String implName(String name) {
        if (name == null || name.equals("ibis") || name.equals("object")) {
            return "ibis.io.IbisSerialization";
        }
        if (name.equals("sun")) {
            return "ibis.io.SunSerialization";
        }
        if (name.equals("data")) {
            return "ibis.io.DataSerialization";
        }
        if (name.equals("byte")) {
            return "ibis.io.ByteSerialization";
        }
        return name;
    }

    public static SerializationInput createSerializationInput(String name, DataInputStream in) throws IOException {
        String impl = SerializationFactory.implName(name) + "InputStream";
        try {
            Class<?> cl = Class.forName(impl);
            Constructor<?> cons = cl.getConstructor(DataInputStream.class);
            return (SerializationInput)cons.newInstance(in);
        }
        catch (ClassNotFoundException e) {
            throw new IbisIOException("No such class: " + impl, e);
        }
        catch (NoSuchMethodException e) {
            throw new IbisIOException("No suitable constructor in class: " + impl, e);
        }
        catch (IllegalArgumentException e) {
            throw new IbisIOException("No suitable constructor in class: " + impl, e);
        }
        catch (InstantiationException e) {
            throw new IbisIOException("class " + impl + " is abstract", e);
        }
        catch (InvocationTargetException e) {
            throw new IbisIOException("constructor of " + impl + " threw an exception", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IbisIOException("access to constructor of " + impl + " is denied", e);
        }
        catch (Throwable e) {
            throw new IbisIOException("got unexpected error", e);
        }
    }

    public static SerializationOutput createSerializationOutput(String name, DataOutputStream out) throws IOException {
        String impl = SerializationFactory.implName(name) + "OutputStream";
        try {
            Class<?> cl = Class.forName(impl);
            Constructor<?> cons = cl.getConstructor(DataOutputStream.class);
            return (SerializationOutput)cons.newInstance(out);
        }
        catch (ClassNotFoundException e) {
            throw new IbisIOException("No such class: " + impl, e);
        }
        catch (NoSuchMethodException e) {
            throw new IbisIOException("No suitable constructor in class: " + impl, e);
        }
        catch (IllegalArgumentException e) {
            throw new IbisIOException("No suitable constructor in class: " + impl, e);
        }
        catch (InstantiationException e) {
            throw new IbisIOException("class " + impl + " is abstract", e);
        }
        catch (InvocationTargetException e) {
            throw new IbisIOException("constructor of " + impl + " threw an exception", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IbisIOException("access to constructor of " + impl + " is denied", e);
        }
        catch (Throwable e) {
            throw new IbisIOException("got unexpected error", e);
        }
    }
}

