/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.IOProperties;
import ibis.util.Timer;

final class IbisHash {
    private static final boolean ASSERTS = IOProperties.properties.getBooleanProperty("ibis.io.hash.assert");
    private static final boolean STATS = IOProperties.properties.getBooleanProperty("ibis.io.hash.stats");
    private static final boolean TIMINGS = IOProperties.properties.getBooleanProperty("ibis.io.hash.timings");
    private static final int MIN_BUCKETS = 32;
    private static final int USE_NEW_BOUND = Integer.MAX_VALUE;
    private static final int RESIZE_FACTOR = 2;
    private static final int PRE_ALLOC_FACTOR = 1;
    private static final int SHIFT1 = 5;
    private static final int SHIFT2 = 16;
    private Object[] dataBucket;
    private int[] handleBucket;
    private long contains;
    private long finds;
    private long rebuilds;
    private long collisions;
    private long rebuild_collisions;
    private long new_buckets;
    private Timer t_insert;
    private Timer t_find;
    private Timer t_rebuild;
    private Timer t_clear;
    private int offset = 0;
    private int size;
    private int initsize;
    private int alloc_size;
    private int present = 0;

    IbisHash() {
        this(32);
    }

    IbisHash(int sz) {
        int x;
        for (x = 1; x < sz; x <<= 1) {
        }
        if (x != sz) {
            System.err.println("Warning: Hash table size (" + sz + ") must be a power of two. Increment to " + x);
            sz = x;
        }
        this.size = sz;
        this.initsize = sz;
        this.newBucketSet(this.initsize);
        if (TIMINGS) {
            this.t_insert = Timer.createTimer();
            this.t_find = Timer.createTimer();
            this.t_rebuild = Timer.createTimer();
            this.t_clear = Timer.createTimer();
        }
        if (STATS || TIMINGS) {
            Runtime.getRuntime().addShutdownHook(new Thread("IbisHash ShutdownHook"){

                @Override
                public void run() {
                    IbisHash.this.statistics();
                }
            });
        }
    }

    private void newBucketSet(int sz) {
        this.dataBucket = new Object[sz];
        this.handleBucket = new int[sz];
        this.alloc_size = sz;
    }

    private static final int hash_first(int b, int size) {
        return (b >>> 5 ^ b & 0xFFFF) & size - 1;
    }

    private static final int hash_second(int b) {
        return (b & 0xFFFFFFFE) + 12345;
    }

    private static final int mod(int x, int size) {
        return x & size - 1;
    }

    final int getHashCode(Object ref) {
        return System.identityHashCode(ref);
    }

    final int find(Object ref, int hashCode) {
        int result;
        int h0;
        int ix;
        Object b;
        if (TIMINGS) {
            this.t_find.start();
        }
        if (STATS) {
            ++this.finds;
        }
        if ((b = this.dataBucket[ix = (h0 = IbisHash.hash_first(hashCode, this.size)) + this.offset]) == null) {
            result = 0;
        } else if (b == ref) {
            result = this.handleBucket[ix];
        } else {
            int h1 = IbisHash.hash_second(hashCode);
            while ((b = this.dataBucket[ix = (h0 = IbisHash.mod(h0 + h1, this.size)) + this.offset]) != null && b != ref) {
            }
            int n = result = b == null ? 0 : this.handleBucket[ix];
        }
        if (TIMINGS) {
            this.t_find.stop();
        }
        if (ASSERTS && result == 0) {
            for (int i = this.offset; i < this.offset + this.size; ++i) {
                if (this.dataBucket[i] != ref) continue;
                System.err.println("CORRUPTED HASH: find returns 'no' but it's there in bucket[" + i + "]");
            }
        }
        return result;
    }

    final int find(Object ref) {
        return this.find(ref, this.getHashCode(ref));
    }

    private final void rebuild() {
        if (2 * this.present <= this.size) {
            return;
        }
        if (TIMINGS) {
            this.t_rebuild.start();
        }
        int n = this.size * 2;
        int new_offset = 0;
        Object[] old_data = this.dataBucket;
        int[] old_handle = this.handleBucket;
        if (n + this.size > this.alloc_size) {
            this.newBucketSet(1 * n);
        } else if (this.offset == 0) {
            new_offset = this.alloc_size - n;
        }
        for (int i = 0; i < this.size; ++i) {
            int ix = i + this.offset;
            Object b = old_data[ix];
            if (b == null) continue;
            int h = System.identityHashCode(b);
            int h0 = IbisHash.hash_first(h, n);
            while (this.dataBucket[h0 + new_offset] != null) {
                int h1 = IbisHash.hash_second(h);
                do {
                    h0 = IbisHash.mod(h0 + h1, n);
                    if (!STATS) continue;
                    ++this.rebuild_collisions;
                } while (this.dataBucket[h0 + new_offset] != null);
            }
            this.dataBucket[h0 + new_offset] = b;
            this.handleBucket[h0 + new_offset] = old_handle[ix];
            if (ASSERTS) continue;
            old_data[ix] = null;
        }
        int old_offset = this.offset;
        int old_size = this.size;
        this.size = n;
        this.offset = new_offset;
        if (ASSERTS) {
            for (int i = old_offset; i < old_offset + old_size; ++i) {
                if (old_data[i] != null && this.find(old_data[i]) == 0) {
                    System.err.println("CORRUPTED HASH after rebuild: cannot find item[" + i + "] = " + Integer.toHexString(this.getHashCode(old_data[i])));
                }
                old_data[i] = null;
            }
            int cont = 0;
            for (int i = this.offset; i < this.offset + this.size; ++i) {
                if (this.dataBucket[i] == null) continue;
                ++cont;
            }
            if (cont != this.present) {
                System.err.println("CORRUPTED HASH after rebuild: present " + this.present + " but contains " + cont);
            }
        }
        if (TIMINGS) {
            this.t_rebuild.stop();
        }
        if (STATS) {
            ++this.rebuilds;
        }
    }

    private int put(Object ref, int handle, int hashCode, boolean lazy) {
        int h0;
        Object b;
        if (TIMINGS) {
            this.t_insert.start();
        }
        if ((b = this.dataBucket[(h0 = IbisHash.hash_first(hashCode, this.size)) + this.offset]) != null && b != ref) {
            int h1 = IbisHash.hash_second(hashCode);
            do {
                h0 = IbisHash.mod(h0 + h1, this.size);
                if (!STATS) continue;
                ++this.collisions;
            } while ((b = this.dataBucket[h0 + this.offset]) != null && b != ref);
        }
        if (lazy && b != null) {
            if (TIMINGS) {
                this.t_insert.stop();
            }
            return this.handleBucket[h0 + this.offset];
        }
        if (ASSERTS && lazy) {
            for (int i = this.offset; i < this.offset + this.size; ++i) {
                if (this.dataBucket[i] != ref) continue;
                System.err.println("CORRUPTED HASH: lazyPut finds 'no' but it's there in bucket[" + i + "]");
            }
        }
        this.dataBucket[h0 + this.offset] = ref;
        this.handleBucket[h0 + this.offset] = handle;
        ++this.present;
        this.rebuild();
        if (TIMINGS) {
            this.t_insert.stop();
        }
        if (STATS) {
            ++this.contains;
        }
        return handle;
    }

    final void put(Object ref, int handle, int hashCode) {
        this.put(ref, handle, hashCode, false);
    }

    final void put(Object ref, int handle) {
        this.put(ref, handle, this.getHashCode(ref));
    }

    final int lazyPut(Object ref, int handle, int hashCode) {
        return this.put(ref, handle, hashCode, true);
    }

    final int lazyPut(Object ref, int handle) {
        return this.lazyPut(ref, handle, this.getHashCode(ref));
    }

    final void clear() {
        if (TIMINGS) {
            this.t_clear.start();
        }
        if (this.size < Integer.MAX_VALUE) {
            for (int i = 0; i < this.size; ++i) {
                this.dataBucket[i + this.offset] = null;
            }
        } else {
            this.newBucketSet(this.initsize);
        }
        this.size = this.initsize;
        this.offset = 0;
        this.present = 0;
        if (TIMINGS) {
            this.t_clear.stop();
        }
        if (STATS) {
            // empty if block
        }
    }

    final void statistics() {
        if (STATS) {
            System.err.println(this + ":" + " alloc_size " + this.alloc_size + " contains " + this.contains + " finds " + this.finds + " rebuilds " + this.rebuilds + " new buckets " + this.new_buckets + " collisions " + this.collisions + " (rebuild " + this.rebuild_collisions + ")");
        }
        if (TIMINGS) {
            System.err.println(this + " insert(" + this.t_insert.nrTimes() + ") " + Timer.format((double)this.t_insert.totalTimeVal()) + " find(" + this.t_find.nrTimes() + ") " + Timer.format((double)this.t_find.totalTimeVal()) + " rebuild(" + this.t_rebuild.nrTimes() + ") " + Timer.format((double)this.t_rebuild.totalTimeVal()) + " clear(" + this.t_clear.nrTimes() + ") " + Timer.format((double)this.t_clear.totalTimeVal()));
        }
    }
}

