/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.util.TypedProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class IOProperties {
    static final TypedProperties properties;
    static final String PREFIX = "ibis.io.";
    private static final String PROPERTIES_FILENAME = "ibis.properties";
    public static final String PROPERTIES_FILE = "ibis.io.properties.file";
    static final String s_stats_nonrewritten = "ibis.io.stats.nonrewritten";
    static final String s_stats_written = "ibis.io.stats.written";
    static final String s_classloader = "ibis.io.serialization.classloader";
    static final String s_timer_data = "ibis.io.serialization.timer.data";
    static final String s_timer_ibis = "ibis.io.serialization.timer.ibis";
    static final String s_no_array_buffers = "ibis.io.noarraybuffers";
    static final String s_conversion = "ibis.io.conversion";
    static final String s_conversion_buf_size = "ibis.io.conversion.buffer.size";
    static final String s_typed_buffer_size = "ibis.io.buffer.size.typed";
    static final String s_buffer_size = "ibis.io.buffer.size";
    static final String s_array_buffer = "ibis.io.array.buffer";
    static final String s_debug = "ibis.io.debug";
    static final String s_asserts = "ibis.io.assert";
    static final String s_small_array_bound = "ibis.io.smallarraybound";
    static final String s_hash_asserts = "ibis.io.hash.assert";
    static final String s_hash_stats = "ibis.io.hash.stats";
    static final String s_hash_timings = "ibis.io.hash.timings";
    static final String s_hash_resize = "ibis.io.hash.resize";
    static final String s_deepcopy_ser = "ibis.io.deepcopy.serialization";
    private static final String[][] propertiesList;
    static final boolean DEBUG;
    public static final boolean ASSERTS;
    public static final int SMALL_ARRAY_BOUND;
    public static final int BUFFER_SIZE;
    public static final int TYPED_BUFFER_SIZE;
    public static final int ARRAY_BUFFER_SIZE;
    public static final int CONVERSION_BUFFER_SIZE;

    public static Properties getHardcodedProperties() {
        Properties properties = new Properties();
        for (String[] element : propertiesList) {
            if (element[1] == null) continue;
            properties.setProperty(element[0], element[1]);
        }
        return properties;
    }

    public static Map<String, String> getDescriptions() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String[] element : propertiesList) {
            result.put(element[0], element[2]);
        }
        return result;
    }

    public static List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String[] element : propertiesList) {
            result.add(element[0]);
        }
        return result;
    }

    private static Properties getPropertyFile(String file) {
        ClassLoader loader;
        InputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (in == null && (in = (loader = ClassLoader.getSystemClassLoader()).getResourceAsStream(file)) == null) {
            return null;
        }
        try {
            Properties p = new Properties();
            p.load(in);
            return p;
        }
        catch (IOException e) {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static void addProperties(Properties props, Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            props.setProperty(key, value);
        }
    }

    private static Properties getDefaultProperties() {
        Properties props = new Properties();
        Properties system = System.getProperties();
        String file = system.getProperty(PROPERTIES_FILE, PROPERTIES_FILENAME);
        if (file != null) {
            Properties fromFile = IOProperties.getPropertyFile(file);
            if (fromFile != null) {
                IOProperties.addProperties(props, fromFile);
            } else if (!file.equals(PROPERTIES_FILENAME)) {
                System.err.println("User specified preferences \"" + file + "\" not found!");
            }
        }
        IOProperties.addProperties(props, system);
        return props;
    }

    static {
        propertiesList = new String[][]{{PROPERTIES_FILE, PROPERTIES_FILENAME, "String: determines the file name of the Ibis IO properties file"}, {s_stats_nonrewritten, "false", "Boolean: if true, print non-rewritten object statistics"}, {s_stats_written, "false", "Boolean: if true, print statistics about objects written"}, {s_classloader, null, "String: the name of a classloader to be used when a class cannot be found"}, {s_timer_data, "false", "Boolean: if true, enables data serialization timers"}, {s_timer_ibis, "false", "Boolean: if true, enables ibis serialization timers"}, {s_no_array_buffers, "false", "Boolean: if true, leaves all buffering of Ibis serialization to the layers below it"}, {s_conversion, "hybrid", "String: determines the conversion used"}, {s_buffer_size, "8192", "Integer: determines the size of the buffers used in Ibis serialization"}, {s_typed_buffer_size, "8192", "Integer: determines the size of the typed buffers used in Ibis data serialization streams"}, {s_conversion_buf_size, "8192", "Integer: determines the size of the conversion buffers used in Ibis serialization"}, {s_array_buffer, "32", "Integer: determines the size of the buffer for arrays"}, {s_debug, "false", "Boolean: if true, enables log4j calls"}, {s_asserts, "false", "Boolean: if true, enables some assertions"}, {s_small_array_bound, "256", "Integer: determines the bound beyond which arrays of a basic type are written as an array instead of as individual elements"}, {s_hash_asserts, "false", "Boolean: if true, enables some assertions in the ibis hash"}, {s_hash_stats, "false", "Boolean: if true, enables statistics in the ibis hash"}, {s_hash_timings, "false", "Boolean: if true, enables various timers in the ibis hash"}, {s_hash_resize, "100", "Integer: determines the fill-percentage before the ibis hash  is resized; choose between 50 and 200; larger values  mean more chaining but a smaller hash size"}, {s_deepcopy_ser, "ibis", "String: determines the serialization used for DeepCopy"}};
        properties = new TypedProperties(IOProperties.getDefaultProperties());
        properties.checkProperties(PREFIX, IOProperties.getPropertyNames().toArray(new String[0]), null, true);
        DEBUG = properties.getBooleanProperty(s_debug, false);
        ASSERTS = properties.getBooleanProperty(s_asserts, false);
        SMALL_ARRAY_BOUND = properties.getIntProperty(s_small_array_bound, 256);
        BUFFER_SIZE = properties.getIntProperty(s_buffer_size, 8192);
        TYPED_BUFFER_SIZE = properties.getIntProperty(s_typed_buffer_size, 8192);
        ARRAY_BUFFER_SIZE = properties.getIntProperty(s_array_buffer, 32);
        CONVERSION_BUFFER_SIZE = properties.getIntProperty(s_conversion_buf_size, 32768);
    }
}

