/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.impl.nio.NioDissipator;
import ibis.ipl.impl.nio.SendReceiveThread;
import ibis.ipl.impl.nio.ThreadNioReceivePort;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

final class ThreadNioDissipator
extends NioDissipator {
    final SendReceiveThread sendReceiveThread;
    SelectionKey key;
    boolean reading = false;
    int minimum = 0;
    IOException error = null;

    ThreadNioDissipator(SendReceiveThread sendReceiveThread, ReadableByteChannel channel) throws IOException {
        super(channel);
        this.sendReceiveThread = sendReceiveThread;
        if (!(channel instanceof SelectableChannel)) {
            throw new IOException("wrong type of channel given on creation of ThreadNioDissipator");
        }
        this.key = sendReceiveThread.register((SelectableChannel)((Object)channel), this);
        sendReceiveThread.enableReading(this.key);
        this.reading = true;
    }

    @Override
    synchronized void receive() throws IOException {
        super.receive();
        if (!this.reading) {
            this.sendReceiveThread.enableReading(this.key);
            this.reading = true;
        }
    }

    @Override
    synchronized boolean messageWaiting() throws IOException {
        if (this.key == null) {
            return false;
        }
        return super.messageWaiting();
    }

    synchronized void doRead() {
        boolean bufferWasEmpty;
        try {
            if (!this.reading) {
                return;
            }
            bufferWasEmpty = this.unUsedLength() == 0;
            this.readFromChannel();
            if (!this.buffer.hasRemaining()) {
                this.key.interestOps(0);
                this.reading = false;
            }
            if (this.minimum != 0 && this.unUsedLength() >= this.minimum) {
                this.notifyAll();
            }
        }
        catch (IOException e) {
            this.error = e;
            this.key.interestOps(0);
            this.reading = false;
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        if (bufferWasEmpty) {
            ((ThreadNioReceivePort)this.info.port).addToReadyList(this);
        }
    }

    @Override
    protected synchronized void fillBuffer(int minimum) throws IOException {
        if (!this.reading) {
            this.sendReceiveThread.enableReading(this.key);
            this.reading = true;
        }
        while (this.unUsedLength() < minimum) {
            if (!this.reading) {
                this.sendReceiveThread.enableReading(this.key);
                this.reading = true;
            }
            if (this.error != null) {
                throw this.error;
            }
            try {
                this.minimum = minimum;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.minimum = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.reading = false;
        super.close();
    }
}

