/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.ConnectionClosedException;
import ibis.ipl.MessageUpcall;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceiveTimedOutException;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.SendPortIdentifier;
import ibis.ipl.impl.nio.NioDissipator;
import ibis.ipl.impl.nio.NioReceivePort;
import ibis.ipl.impl.nio.NonBlockingChannelNioDissipator;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NonBlockingChannelNioReceivePort
extends NioReceivePort {
    static final int INITIAL_ARRAY_SIZE = 8;
    private static Logger logger = LoggerFactory.getLogger(NonBlockingChannelNioReceivePort.class);
    private NonBlockingChannelNioDissipator[] connections = new NonBlockingChannelNioDissipator[8];
    private int nrOfConnections = 0;
    private NonBlockingChannelNioDissipator[] pendingConnections = new NonBlockingChannelNioDissipator[8];
    private int nrOfPendingConnections = 0;
    private boolean closing = false;
    Selector selector = Selector.open();

    NonBlockingChannelNioReceivePort(Ibis ibis, PortType type, String name, MessageUpcall upcall, ReceivePortConnectUpcall connUpcall, Properties props) throws IOException {
        super(ibis, type, name, upcall, connUpcall, props);
    }

    @Override
    synchronized void newConnection(SendPortIdentifier spi, Channel channel) throws IOException {
        int i;
        if (logger.isDebugEnabled()) {
            logger.debug("registering new connection");
        }
        if (!(channel instanceof ReadableByteChannel)) {
            logger.error("wrong channel type");
            throw new IOException("wrong channel type on creating connection");
        }
        NonBlockingChannelNioDissipator dissipator = new NonBlockingChannelNioDissipator((ReadableByteChannel)channel);
        this.addConnection(spi, dissipator);
        if (this.nrOfConnections == this.connections.length) {
            NonBlockingChannelNioDissipator[] newConnections = new NonBlockingChannelNioDissipator[this.connections.length * 2];
            for (i = 0; i < this.connections.length; ++i) {
                newConnections[i] = this.connections[i];
            }
            this.connections = newConnections;
        }
        this.connections[this.nrOfConnections] = dissipator;
        ++this.nrOfConnections;
        if (this.nrOfPendingConnections == this.pendingConnections.length) {
            NonBlockingChannelNioDissipator[] newPendingConnections = new NonBlockingChannelNioDissipator[this.pendingConnections.length * 2];
            for (i = 0; i < this.pendingConnections.length; ++i) {
                newPendingConnections[i] = this.pendingConnections[i];
            }
            this.pendingConnections = newPendingConnections;
        }
        this.pendingConnections[this.nrOfPendingConnections] = dissipator;
        ++this.nrOfPendingConnections;
        if (logger.isDebugEnabled()) {
            logger.debug("waking up selector");
        }
        this.selector.wakeup();
        if (logger.isDebugEnabled()) {
            logger.debug("registerred new connection");
        }
    }

    @Override
    synchronized void errorOnRead(NioDissipator dissipator, Exception cause) {
        int i;
        logger.debug("lost connection", (Throwable)cause);
        for (i = 0; i < this.nrOfPendingConnections; ++i) {
            if (dissipator != this.pendingConnections[i]) continue;
            --this.nrOfPendingConnections;
            this.pendingConnections[i] = this.pendingConnections[this.nrOfPendingConnections];
            this.pendingConnections[this.nrOfPendingConnections] = null;
            logger.debug("lost connection removed from pending list");
            break;
        }
        dissipator.info.close(cause);
        for (i = 0; i < this.nrOfConnections; ++i) {
            if (dissipator != this.connections[i]) continue;
            --this.nrOfConnections;
            this.connections[i] = this.connections[this.nrOfConnections];
            this.connections[this.nrOfConnections] = null;
            logger.debug("removed connection");
            break;
        }
        if (this.nrOfConnections == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("no more connections, waking up selector");
            }
            this.selector.wakeup();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("removed connection");
        }
    }

    synchronized void registerPendingConnections() throws IOException {
        if (logger.isDebugEnabled() && this.nrOfPendingConnections > 0) {
            logger.debug("registerring " + this.nrOfPendingConnections + " connections");
        }
        for (int i = 0; i < this.nrOfPendingConnections; ++i) {
            SelectableChannel sh = (SelectableChannel)((Object)this.pendingConnections[i].channel);
            sh.register(this.selector, 1, this.pendingConnections[i]);
            this.pendingConnections[i] = null;
        }
        this.nrOfPendingConnections = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    NioDissipator getReadyDissipator(long deadline) throws IOException {
        boolean deadlinePassed = false;
        boolean firstTry = true;
        NonBlockingChannelNioDissipator dissipator = null;
        if (logger.isDebugEnabled()) {
            logger.debug("trying to find a dissipator with a message waiting");
        }
        while (!deadlinePassed) {
            long time;
            this.registerPendingConnections();
            NonBlockingChannelNioReceivePort nonBlockingChannelNioReceivePort = this;
            synchronized (nonBlockingChannelNioReceivePort) {
                if (this.nrOfConnections == 0) {
                    if (this.closing) {
                        if (logger.isInfoEnabled()) {
                            logger.info("exiting because we have no connections (as requested)");
                        }
                        throw new ConnectionClosedException();
                    }
                    if (deadline == -1L) {
                        deadlinePassed = true;
                        continue;
                    }
                    if (deadline == 0L) {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug("wait()ing for a connection");
                            }
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                    time = System.currentTimeMillis();
                    if (time >= deadline) {
                        deadlinePassed = true;
                    } else {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug("wait()ing for a connection");
                            }
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (firstTry && this.nrOfConnections == 1) {
                    try {
                        this.connections[0].readFromChannel();
                    }
                    catch (IOException e) {
                        this.errorOnRead(this.connections[0], e);
                    }
                    firstTry = false;
                }
                for (int i = 0; i < this.nrOfConnections; ++i) {
                    try {
                        if (!this.connections[i].messageWaiting()) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("returning connection " + i);
                        }
                        return this.connections[i];
                    }
                    catch (IOException e) {
                        this.errorOnRead(this.connections[i], e);
                        --i;
                    }
                }
            }
            if (deadline == -1L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("doing a selectNow");
                }
                try {
                    this.selector.selectNow();
                }
                catch (IOException e) {
                    // empty catch block
                }
                deadlinePassed = true;
            } else if (deadline == 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("doing a select() on " + this.selector.keys().size() + " connections");
                }
                try {
                    this.selector.select();
                }
                catch (IOException e) {
                    logger.error("error on select: " + e);
                }
            } else {
                time = System.currentTimeMillis();
                if (time >= deadline) {
                    deadlinePassed = true;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doing a select(timeout)");
                    }
                    try {
                        this.selector.select(deadline - time);
                    }
                    catch (IOException e) {
                        logger.error("error on select: " + e);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("selected " + this.selector.selectedKeys().size() + " connections");
            }
            for (SelectionKey key : this.selector.selectedKeys()) {
                dissipator = (NonBlockingChannelNioDissipator)key.attachment();
                try {
                    dissipator.readFromChannel();
                }
                catch (IOException e) {
                    this.errorOnRead(dissipator, e);
                }
            }
            this.selector.selectedKeys().clear();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("deadline passed");
        }
        throw new ReceiveTimedOutException("timeout while waiting for dissipator");
    }

    @Override
    synchronized void closing() {
        this.closing = true;
    }
}

