/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.io.Conversion;
import ibis.ipl.PortType;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.SendPort;
import ibis.ipl.impl.SendPortConnectionInfo;
import ibis.ipl.impl.WriteMessage;
import ibis.ipl.impl.nio.BlockingChannelNioAccumulator;
import ibis.ipl.impl.nio.NioAccumulator;
import ibis.ipl.impl.nio.NioAccumulatorConnection;
import ibis.ipl.impl.nio.NioIbis;
import ibis.ipl.impl.nio.NonBlockingChannelNioAccumulator;
import ibis.ipl.impl.nio.Protocol;
import ibis.ipl.impl.nio.ThreadNioAccumulator;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.GatheringByteChannel;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NioSendPort
extends SendPort
implements Protocol {
    private static Logger logger = LoggerFactory.getLogger(NioSendPort.class);
    private final NioAccumulator accumulator;

    NioSendPort(Ibis ibis, PortType type, String name, SendPortDisconnectUpcall cU, Properties props) throws IOException {
        super(ibis, type, name, cU, props);
        this.accumulator = type.hasCapability("sendport.blocking") ? new BlockingChannelNioAccumulator(this) : (type.hasCapability("sendport.nonblocking") ? new NonBlockingChannelNioAccumulator(this) : (type.hasCapability("sendport.thread") ? new ThreadNioAccumulator(this, ((NioIbis)ibis).sendReceiveThread()) : (type.hasCapability("connection.onetoone") || type.hasCapability("connection.onetomany") ? new BlockingChannelNioAccumulator(this) : new NonBlockingChannelNioAccumulator(this))));
        this.initStream(this.accumulator);
    }

    protected void handleSendException(WriteMessage w, IOException e) {
        logger.debug("handleSendException", (Throwable)e);
    }

    protected SendPortConnectionInfo doConnect(ReceivePortIdentifier receiver, long timeoutMillis, boolean fillTimeout) throws IOException {
        Channel channel = ((NioIbis)this.ibis).factory.connect(this, receiver, timeoutMillis);
        if (!(channel instanceof GatheringByteChannel)) {
            logger.error("factory returned wrong type of channel");
            throw new IOException("factory returned wrong type of channel");
        }
        if (this.out != null) {
            logger.info("letting all the other receivers know there's a new connection");
            this.out.writeByte((byte)1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("done connecting " + this.ident + " to " + receiver);
        }
        NioAccumulatorConnection c = this.accumulator.add((GatheringByteChannel)channel, receiver);
        this.initStream(this.accumulator);
        return c;
    }

    protected void sendDisconnectMessage(ReceivePortIdentifier receiver, SendPortConnectionInfo c) throws IOException {
        this.out.writeByte((byte)4);
        this.accumulator.removeConnection(receiver);
        byte[] receiverBytes = receiver.toBytes();
        byte[] receiverLength = new byte[4];
        Conversion.defaultConversion.int2byte(receiverBytes.length, receiverLength, 0);
        this.out.writeArray(receiverLength);
        this.out.writeArray(receiverBytes);
        this.out.flush();
    }

    protected void announceNewMessage() throws IOException {
        this.out.writeByte((byte)2);
        if (this.type.hasCapability("communication.numbered")) {
            this.out.writeLong(this.ibis.registry().getSequenceNumber(this.name));
        }
    }

    protected void closePort() {
        try {
            this.out.writeByte((byte)3);
            this.out.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.out = null;
    }
}

