/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.Credentials;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisCreationFailedException;
import ibis.ipl.IbisStarter;
import ibis.ipl.MessageUpcall;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePort;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.SendPort;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.impl.nio.BlockingChannelNioReceivePort;
import ibis.ipl.impl.nio.ChannelFactory;
import ibis.ipl.impl.nio.NioSendPort;
import ibis.ipl.impl.nio.NonBlockingChannelNioReceivePort;
import ibis.ipl.impl.nio.SendReceiveThread;
import ibis.ipl.impl.nio.TcpChannelFactory;
import ibis.ipl.impl.nio.ThreadNioReceivePort;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NioIbis
extends Ibis {
    static final String prefix = "ibis.ipl.impl.nio.";
    static final String s_spi = "ibis.ipl.impl.nio.spi";
    static final String s_rpi = "ibis.ipl.impl.nio.rpi";
    static final String[] props = new String[]{"ibis.ipl.impl.nio.spi", "ibis.ipl.impl.nio.rpi"};
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.ipl.impl.nio.NioIbis");
    ChannelFactory factory;
    private HashMap<ibis.ipl.IbisIdentifier, InetSocketAddress> addresses = new HashMap();
    private SendReceiveThread sendReceiveThread = null;

    public NioIbis(RegistryEventHandler r, IbisCapabilities p, Credentials credentials, byte[] applicationTag, PortType[] types, Properties tp, IbisStarter starter) throws IbisCreationFailedException {
        super(r, p, credentials, applicationTag, types, tp, starter);
        this.properties.checkProperties(prefix, props, null, true);
    }

    protected byte[] getData() throws IOException {
        this.factory = new TcpChannelFactory(this);
        InetSocketAddress myAddress = this.factory.getAddress();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(myAddress);
        out.close();
        return bos.toByteArray();
    }

    protected void quit() {
        try {
            if (this.factory != null) {
                this.factory.quit();
            }
            if (this.sendReceiveThread != null) {
                this.factory.quit();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logger.info("NioIbis" + this.ident + " DE-initialized");
    }

    synchronized SendReceiveThread sendReceiveThread() throws IOException {
        if (this.sendReceiveThread == null) {
            this.sendReceiveThread = new SendReceiveThread();
        }
        return this.sendReceiveThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetSocketAddress getAddress(IbisIdentifier id) throws IOException {
        InetSocketAddress idAddr;
        HashMap<ibis.ipl.IbisIdentifier, InetSocketAddress> hashMap = this.addresses;
        synchronized (hashMap) {
            idAddr = this.addresses.get(id);
            if (idAddr == null) {
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(id.getImplementationData()));
                try {
                    idAddr = (InetSocketAddress)in.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("Could not get address from " + id);
                }
                in.close();
                this.addresses.put((ibis.ipl.IbisIdentifier)id, idAddr);
            }
        }
        return idAddr;
    }

    protected SendPort doCreateSendPort(PortType tp, String name, SendPortDisconnectUpcall cU, Properties props) throws IOException {
        return new NioSendPort(this, tp, name, cU, props);
    }

    protected ReceivePort doCreateReceivePort(PortType tp, String name, MessageUpcall u, ReceivePortConnectUpcall cU, Properties props) throws IOException {
        if (tp.hasCapability("receiveport.blocking")) {
            return new BlockingChannelNioReceivePort(this, tp, name, u, cU, props);
        }
        if (tp.hasCapability("receiveport.nonblocking")) {
            return new NonBlockingChannelNioReceivePort(this, tp, name, u, cU, props);
        }
        if (tp.hasCapability("receiveport.thread")) {
            return new ThreadNioReceivePort(this, tp, name, u, cU, props);
        }
        if (tp.hasCapability("connection.onetoone") || tp.hasCapability("connection.manytoone")) {
            return new BlockingChannelNioReceivePort(this, tp, name, u, cU, props);
        }
        return new NonBlockingChannelNioReceivePort(this, tp, name, u, cU, props);
    }
}

