/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.util.rpc;

import ibis.ipl.Ibis;
import ibis.ipl.MessageUpcall;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.SendPort;
import ibis.ipl.WriteMessage;
import ibis.ipl.util.rpc.RPC;
import ibis.ipl.util.rpc.RemoteException;
import java.io.IOException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteObject<InterfaceType>
implements MessageUpcall {
    private static final Logger logger = LoggerFactory.getLogger(RemoteObject.class);
    private final Class<InterfaceType> interfaceClass;
    private final InterfaceType theObject;
    private final String name;
    private final Ibis ibis;
    private final ReceivePort receivePort;

    public Class<InterfaceType> getInterfaceClass() {
        return this.interfaceClass;
    }

    public InterfaceType getObject() {
        return this.theObject;
    }

    public String getName() {
        return this.name;
    }

    public ReceivePort getReceivePort() {
        return this.receivePort;
    }

    RemoteObject(Class<InterfaceType> interfaceClass, InterfaceType theObject, String name, Ibis ibis) throws RemoteException {
        this.interfaceClass = interfaceClass;
        this.theObject = theObject;
        this.ibis = ibis;
        for (Method method : interfaceClass.getDeclaredMethods()) {
            boolean found = false;
            for (Class<?> clazz : method.getExceptionTypes()) {
                if (!clazz.equals(RemoteException.class)) continue;
                found = true;
            }
            if (found) continue;
            throw new RemoteException("required RemoteException not thrown by remote method \"" + method.getName() + "\" in remote object interface \"" + interfaceClass.getName() + "\"");
        }
        try {
            this.receivePort = ibis.createReceivePort(RPC.rpcRequestPortType, name, (MessageUpcall)this);
            this.receivePort.enableConnections();
            this.receivePort.enableMessageUpcalls();
            this.name = this.receivePort.name();
            if (logger.isDebugEnabled()) {
                logger.debug("remote object " + this + " created");
            }
        }
        catch (IOException e) {
            throw new RemoteException("cannot create receive port for remote object", e);
        }
    }

    public void unexport() throws IOException {
        this.receivePort.close();
    }

    public void upcall(ReadMessage message) throws IOException, ClassNotFoundException {
        boolean success;
        ReceivePortIdentifier requestor = (ReceivePortIdentifier)message.readObject();
        String methodName = message.readString();
        Class[] parameterTypes = (Class[])message.readObject();
        Object[] args = (Object[])message.readObject();
        message.finish();
        if (logger.isDebugEnabled()) {
            logger.debug("received invocation for remote object. name = " + this.name + ", method name =  " + methodName);
        }
        SendPort replyPort = this.ibis.createSendPort(RPC.rpcReplyPortType);
        replyPort.connect(requestor);
        Object result = null;
        try {
            Method method = this.interfaceClass.getDeclaredMethod(methodName, parameterTypes);
            result = method.invoke(this.theObject, args);
            success = true;
        }
        catch (Throwable exception) {
            result = exception;
            success = false;
        }
        WriteMessage reply = replyPort.newMessage();
        reply.writeBoolean(success);
        reply.writeObject(result);
        System.err.println("bytes send in reply = " + reply.finish());
        replyPort.close();
    }

    public String toString() {
        return this.name;
    }
}

