/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.util.rpc;

import ibis.ipl.Ibis;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.SendPort;
import ibis.ipl.WriteMessage;
import ibis.ipl.util.rpc.RPC;
import ibis.ipl.util.rpc.RemoteException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RPCInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(RPCInvocationHandler.class);
    private final Ibis ibis;
    private final IbisIdentifier ibisIdentifier;
    private final String name;

    RPCInvocationHandler(IbisIdentifier ibisIdentifier, String name, Ibis ibis) {
        this.ibisIdentifier = ibisIdentifier;
        this.name = name;
        this.ibis = ibis;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("calling remote object " + this.name + ", method = " + method.getName());
            }
            SendPort sendPort = this.ibis.createSendPort(RPC.rpcRequestPortType);
            sendPort.connect(this.ibisIdentifier, this.name);
            ReceivePort receivePort = this.ibis.createReceivePort(RPC.rpcReplyPortType, null);
            receivePort.enableConnections();
            WriteMessage request = sendPort.newMessage();
            request.writeObject((Object)receivePort.identifier());
            request.writeString(method.getName());
            request.writeObject(method.getParameterTypes());
            request.writeObject((Object)args);
            request.finish();
            ReadMessage reply = receivePort.receive();
            boolean success = reply.readBoolean();
            Object result = reply.readObject();
            reply.finish();
            if (logger.isDebugEnabled()) {
                logger.debug("remote object \"" + this.name + "\", method \"" + method.getName() + "\" result = " + result);
            }
            sendPort.close();
            receivePort.close();
            if (success) {
                return result;
            }
            if (result instanceof InvocationTargetException) {
                InvocationTargetException exception = (InvocationTargetException)result;
                throw exception.getTargetException();
            }
            throw new RemoteException("exception while performing remote call", (Throwable)result);
        }
        catch (IOException e) {
            throw new RemoteException("invocation failed", e);
        }
    }
}

