/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.util.rpc;

import ibis.ipl.Ibis;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisFactory;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.PortType;
import ibis.ipl.util.rpc.RPC;
import ibis.ipl.util.rpc.RemoteException;
import ibis.ipl.util.rpc.RemoteObject;
import java.util.Date;

public class Example {
    IbisCapabilities ibisCapabilities = new IbisCapabilities(new String[]{"elections.strict"});
    private final Ibis myIbis = IbisFactory.createIbis((IbisCapabilities)this.ibisCapabilities, null, (PortType[])RPC.rpcPortTypes);

    private Example() throws Exception {
        IbisIdentifier server = this.myIbis.registry().elect("Server");
        if (server.equals(this.myIbis.identifier())) {
            this.server();
        } else {
            this.client(server);
        }
        this.myIbis.end();
    }

    private void server() throws Exception {
        ExampleClass object = new ExampleClass();
        RemoteObject<ExampleClass> remoteObject = RPC.exportObject(ExampleInterface.class, object, "my great object", this.myIbis);
        Thread.sleep(100000L);
        remoteObject.unexport();
    }

    private void client(IbisIdentifier server) throws Exception {
        ExampleInterface interfaceObject = RPC.createProxy(ExampleInterface.class, server, "my great object", this.myIbis);
        System.err.println(interfaceObject.millisToString(System.currentTimeMillis()));
    }

    public static void main(String[] args) {
        try {
            new Example();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public class ExampleClass
    implements ExampleInterface {
        @Override
        public String millisToString(long millis) throws RemoteException, Exception {
            return "rpc example result = " + new Date(millis).toString();
        }
    }

    public static interface ExampleInterface {
        public String millisToString(long var1) throws RemoteException, Exception;
    }
}

