/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.support;

import ibis.ipl.IbisConfigurationException;
import ibis.ipl.server.ServerProperties;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.virtual.InitializationException;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.TypedProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private static Map<String, Client> clients = new HashMap<String, Client>();
    private final DirectSocketAddress serverMachine;
    private final VirtualSocketFactory factory;

    private static DirectSocketAddress createServerAddress(String serverString, int defaultPort) throws IbisConfigurationException {
        if (serverString == null) {
            throw new IbisConfigurationException("serverString undefined");
        }
        try {
            return DirectSocketAddress.getByAddress((String)serverString);
        }
        catch (Throwable e) {
            Throwable throwable = null;
            try {
                return DirectSocketAddress.getByAddress((String)serverString, (int)defaultPort);
            }
            catch (Throwable e2) {
                throwable = e2;
                throw new IbisConfigurationException("could not create server address from given string: " + serverString, throwable);
            }
        }
    }

    public static synchronized Client getOrCreateClient(String name, Properties properties, int port) throws IbisConfigurationException, IOException {
        Client result = clients.get(name);
        if (result == null) {
            result = new Client(properties, port);
            clients.put(name, result);
        }
        return result;
    }

    private Client(Properties properties, int port) throws IbisConfigurationException, IOException {
        TypedProperties typedProperties = ServerProperties.getHardcodedProperties();
        typedProperties.addProperties(properties);
        String serverAddressString = typedProperties.getProperty("ibis.server.address");
        this.serverMachine = serverAddressString == null || serverAddressString.equals("") ? null : Client.createServerAddress(serverAddressString, typedProperties.getIntProperty("ibis.server.port", 8888));
        String hubs = typedProperties.getProperty("ibis.hub.addresses");
        boolean serverIsHub = typedProperties.getBooleanProperty("ibis.server.is.hub");
        if (this.serverMachine != null && serverIsHub) {
            hubs = hubs == null || hubs.equals("") ? this.serverMachine.toString() : hubs + "," + this.serverMachine.toString();
        }
        Properties smartProperties = new Properties();
        if (port > 0) {
            smartProperties.put("smartsockets.port.range", Integer.toString(port));
        }
        if (hubs != null) {
            smartProperties.put("smartsockets.hub.addresses", hubs);
        }
        try {
            this.factory = VirtualSocketFactory.createSocketFactory((Properties)smartProperties, (boolean)true);
        }
        catch (InitializationException e) {
            throw new IOException(e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("client factory running on " + this.factory.getLocalHost());
        }
    }

    public VirtualSocketFactory getFactory() {
        return this.factory;
    }

    public VirtualSocketAddress getServiceAddress(int port) throws IbisConfigurationException {
        if (this.serverMachine == null) {
            throw new IbisConfigurationException("cannot get address of server, server address property \"ibis.server.address\" undefined");
        }
        return new VirtualSocketAddress(this.serverMachine, port, this.serverMachine, null);
    }
}

