/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.server;

import ibis.ipl.IbisIdentifier;
import ibis.ipl.server.Server;
import ibis.ipl.support.Connection;
import ibis.ipl.support.management.AttributeDescription;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerConnectionHandler
implements Runnable {
    private static final int CONNECTION_BACKLOG = 50;
    static final int MAX_THREADS = 10;
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectionHandler.class);
    private final Server server;
    private final VirtualServerSocket serverSocket;
    private int currentNrOfThreads = 0;
    private boolean ended = false;

    public ServerConnectionHandler(Server server, VirtualSocketFactory socketFactory) throws IOException {
        this.server = server;
        this.serverSocket = socketFactory.createServerSocket(300, 50, null);
        this.createThread();
    }

    private synchronized void createThread() {
        while (this.currentNrOfThreads >= 10 && !this.ended) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.ended) {
            return;
        }
        ThreadPool.createNew((Runnable)this, (String)"server connection handler");
        ++this.currentNrOfThreads;
        if (logger.isDebugEnabled()) {
            logger.debug("Now " + this.currentNrOfThreads + " connections");
        }
    }

    private synchronized void threadEnded() {
        --this.currentNrOfThreads;
        this.notifyAll();
    }

    private synchronized boolean hasEnded() {
        return this.ended;
    }

    private void handleGetAddress(Connection connection) throws IOException {
        connection.sendOKReply();
        connection.out().writeUTF(this.server.getAddress());
    }

    private void handleGetServiceNames(Connection connection) throws IOException {
        String[] result = this.server.getServiceNames();
        connection.sendOKReply();
        connection.out().writeInt(result.length);
        for (String name : result) {
            connection.out().writeUTF(name);
        }
    }

    private void handleGetHubs(Connection connection) throws IOException {
        String[] result = this.server.getHubs();
        connection.sendOKReply();
        connection.out().writeInt(result.length);
        for (String hub : result) {
            connection.out().writeUTF(hub);
        }
    }

    private void handleAddHubs(Connection connection) throws IOException {
        int nrOfNewHubs = connection.in().readInt();
        if (nrOfNewHubs < 0) {
            throw new IOException("negative hub list size");
        }
        String[] hubs = new String[nrOfNewHubs];
        for (int i = 0; i < hubs.length; ++i) {
            hubs[i] = connection.in().readUTF();
        }
        this.server.addHubs(hubs);
        connection.sendOKReply();
    }

    private void handleEnd(Connection connection) throws IOException {
        long timeout = connection.in().readLong();
        connection.sendOKReply();
        connection.close();
        this.server.end(timeout);
    }

    private void handleRegistryGetPools(Connection connection) throws IOException {
        String[] result = this.server.getRegistryService().getPools();
        connection.sendOKReply();
        connection.out().writeInt(result.length);
        for (String element : result) {
            connection.out().writeUTF(element);
        }
    }

    private void handleRegistryGetPoolSizes(Connection connection) throws IOException {
        Map<String, Integer> result = this.server.getRegistryService().getPoolSizes();
        connection.sendOKReply();
        connection.out().writeInt(result.size());
        for (Map.Entry<String, Integer> entry : result.entrySet()) {
            connection.out().writeUTF(entry.getKey());
            connection.out().writeInt(entry.getValue());
        }
    }

    private void handleRegistryGetLocations(Connection connection) throws IOException {
        String poolName = connection.in().readUTF();
        String[] result = this.server.getRegistryService().getLocations(poolName);
        connection.sendOKReply();
        connection.out().writeInt(result.length);
        for (String element : result) {
            connection.out().writeUTF(element);
        }
    }

    private void handleRegistryGetMembers(Connection connection) throws IOException {
        String pool = connection.in().readUTF();
        ibis.ipl.impl.IbisIdentifier[] result = this.server.getRegistryService().getMembers(pool);
        connection.sendOKReply();
        connection.out().writeInt(result.length);
        for (ibis.ipl.impl.IbisIdentifier element : result) {
            byte[] bytes = element.toBytes();
            connection.out().write(bytes);
        }
    }

    private void handleManagementGetAttributes(Connection connection) throws IOException, ClassNotFoundException {
        ibis.ipl.impl.IbisIdentifier ibis = (ibis.ipl.impl.IbisIdentifier)connection.readObject();
        AttributeDescription[] attributes = (AttributeDescription[])connection.readObject();
        Object[] result = this.server.getManagementService().getAttributes((IbisIdentifier)ibis, attributes);
        connection.sendOKReply();
        connection.writeObject(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        connection = null;
        try {
            if (ServerConnectionHandler.logger.isDebugEnabled()) {
                ServerConnectionHandler.logger.debug("accepting connection");
            }
            connection = new Connection(this.serverSocket);
            if (ServerConnectionHandler.logger.isDebugEnabled()) {
                ServerConnectionHandler.logger.debug("connection accepted");
            }
        }
        catch (IOException e) {
            if (this.hasEnded()) {
                this.threadEnded();
                return;
            }
            ServerConnectionHandler.logger.error("Accept failed, waiting a second, will retry", (Throwable)e);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        this.createThread();
        if (connection == null) {
            this.threadEnded();
            return;
        }
        opcode = 0;
        try {
            magic = connection.in().readByte();
            if (magic != 74) {
                throw new IOException("Invalid header byte in accepting connection");
            }
            opcode = connection.in().readByte();
            if (ServerConnectionHandler.logger.isDebugEnabled()) {
                ServerConnectionHandler.logger.debug("got request, opcode = " + opcode);
            }
            switch (opcode) {
                case 0: {
                    this.handleGetAddress(connection);
                    ** break;
lbl35:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.handleGetServiceNames(connection);
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.handleGetHubs(connection);
                    ** break;
lbl43:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.handleAddHubs(connection);
                    ** break;
lbl47:
                    // 1 sources

                    break;
                }
                case 4: {
                    this.handleEnd(connection);
                    ** break;
lbl51:
                    // 1 sources

                    break;
                }
                case 5: {
                    this.handleRegistryGetPools(connection);
                    ** break;
lbl55:
                    // 1 sources

                    break;
                }
                case 7: {
                    this.handleRegistryGetPoolSizes(connection);
                    ** break;
lbl59:
                    // 1 sources

                    break;
                }
                case 6: {
                    this.handleRegistryGetLocations(connection);
                    ** break;
lbl63:
                    // 1 sources

                    break;
                }
                case 8: {
                    this.handleRegistryGetMembers(connection);
                    ** break;
lbl67:
                    // 1 sources

                    break;
                }
                case 9: {
                    this.handleManagementGetAttributes(connection);
                    ** break;
lbl71:
                    // 1 sources

                    break;
                }
                default: {
                    ServerConnectionHandler.logger.error("unknown opcode: " + opcode);
                    break;
                }
            }
        }
        catch (Exception e) {
            connection.closeWithError("Server: " + e.getMessage());
            ServerConnectionHandler.logger.error("error on handling connection", (Throwable)e);
        }
        finally {
            connection.close();
        }
        this.threadEnded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        ServerConnectionHandler serverConnectionHandler = this;
        synchronized (serverConnectionHandler) {
            this.ended = true;
            this.notifyAll();
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

