/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.server;

import ibis.ipl.IbisIdentifier;
import ibis.ipl.server.RegistryServiceInterface;
import ibis.ipl.support.Connection;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class RegistryServiceConnection
implements RegistryServiceInterface {
    public static final int TIMEOUT = 10000;
    private final VirtualSocketAddress address;
    private final VirtualSocketFactory socketFactory;

    RegistryServiceConnection(VirtualSocketAddress address, VirtualSocketFactory socketFactory) {
        this.address = address;
        this.socketFactory = socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPools() throws IOException {
        Connection connection = new Connection(this.address, 10000, true, this.socketFactory);
        try {
            connection.out().writeByte(74);
            connection.out().writeByte(5);
            connection.getAndCheckReply();
            int nrOfHubs = connection.in().readInt();
            if (nrOfHubs < 0) {
                throw new IOException("Negative number of hubs");
            }
            String[] result = new String[nrOfHubs];
            for (int i = 0; i < nrOfHubs; ++i) {
                result[i] = connection.in().readUTF();
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IbisIdentifier[] getMembers(String poolName) throws IOException {
        Connection connection = new Connection(this.address, 10000, true, this.socketFactory);
        try {
            connection.out().writeByte(74);
            connection.out().writeByte(8);
            connection.out().writeUTF(poolName);
            connection.getAndCheckReply();
            int nrOfMembers = connection.in().readInt();
            if (nrOfMembers < 0) {
                throw new IOException("negative number of members received");
            }
            IbisIdentifier[] result = new IbisIdentifier[nrOfMembers];
            for (int i = 0; i < nrOfMembers; ++i) {
                result[i] = new ibis.ipl.impl.IbisIdentifier((DataInput)connection.in());
            }
            IbisIdentifier[] ibisIdentifierArray = result;
            return ibisIdentifierArray;
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLocations(String poolName) throws IOException {
        Connection connection = new Connection(this.address, 10000, true, this.socketFactory);
        try {
            connection.out().writeByte(74);
            connection.out().writeByte(6);
            connection.out().writeUTF(poolName);
            connection.getAndCheckReply();
            int nrOfLocations = connection.in().readInt();
            if (nrOfLocations < 0) {
                throw new IOException("Negative number of locations");
            }
            String[] result = new String[nrOfLocations];
            for (int i = 0; i < nrOfLocations; ++i) {
                result[i] = connection.in().readUTF();
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getPoolSizes() throws IOException {
        Connection connection = new Connection(this.address, 10000, true, this.socketFactory);
        try {
            connection.out().writeByte(74);
            connection.out().writeByte(7);
            connection.getAndCheckReply();
            int nrOfPoolSizes = connection.in().readInt();
            if (nrOfPoolSizes < 0) {
                throw new IOException("Negative number of pool sizes");
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            for (int i = 0; i < nrOfPoolSizes; ++i) {
                result.put(connection.in().readUTF(), connection.in().readInt());
            }
            HashMap<String, Integer> hashMap = result;
            return hashMap;
        }
        finally {
            connection.close();
        }
    }
}

