/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.gossip.Member;
import ibis.ipl.registry.gossip.Registry;
import ibis.ipl.registry.statistics.Statistics;
import ibis.util.TypedProperties;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemberSet
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(MemberSet.class);
    private final TypedProperties properties;
    private final Registry registry;
    private final Statistics statistics;
    private final HashSet<UUID> deceased;
    private final HashSet<UUID> left;
    private final HashMap<UUID, Member> members;
    private Member self;
    private final Random random;
    private int liveMembers;

    MemberSet(TypedProperties properties, Registry registry, Statistics statistics) {
        this.properties = properties;
        this.registry = registry;
        this.statistics = statistics;
        this.deceased = new HashSet();
        this.left = new HashSet();
        this.members = new HashMap();
        this.random = new Random();
    }

    @Override
    public synchronized void start() {
        this.setDaemon(true);
        super.start();
    }

    private synchronized Member getMember(IbisIdentifier ibis, boolean create) {
        UUID id = UUID.fromString(ibis.getID());
        if (this.deceased.contains(id) || this.left.contains(id)) {
            return null;
        }
        Member result = this.members.get(id);
        if (result == null && create) {
            result = new Member(ibis, this.properties);
            this.members.put(id, result);
            this.registry.ibisJoined(ibis);
            if (this.statistics != null) {
                this.statistics.newPoolSize(this.members.size());
            }
        }
        return result;
    }

    public synchronized void maybeDead(IbisIdentifier ibis) {
        Member member = this.getMember(ibis, false);
        if (member == null) {
            return;
        }
        member.suspectDead(this.registry.getIbisIdentifier());
        this.cleanup(member);
    }

    public synchronized void assumeDead(IbisIdentifier ibis) {
        Member member = this.getMember(ibis, false);
        if (member == null) {
            return;
        }
        member.declareDead();
        this.cleanup(member);
    }

    public synchronized void leave(IbisIdentifier ibis) {
        Member member = this.getMember(ibis, true);
        if (member == null) {
            return;
        }
        member.setLeft();
        this.cleanup(member);
    }

    public synchronized void leave() {
        if (this.self != null) {
            this.self.setLeft();
        }
    }

    public synchronized IbisIdentifier getFirstLiving(IbisIdentifier[] candidates) {
        if (candidates == null || candidates.length == 0) {
            return null;
        }
        for (IbisIdentifier candidate : candidates) {
            Member member = this.getMember(candidate, false);
            if (member == null || member.hasLeft() || member.isDead()) continue;
            return candidate;
        }
        return candidates[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGossipData(DataOutputStream out, int gossipSize) throws IOException {
        Member[] randomMembers;
        UUID[] left;
        UUID[] deceased;
        MemberSet memberSet = this;
        synchronized (memberSet) {
            deceased = this.deceased.toArray(new UUID[0]);
            left = this.left.toArray(new UUID[0]);
            randomMembers = this.getRandomMembers(gossipSize);
            if (this.self != null) {
                this.self.seen();
            }
        }
        out.writeInt(deceased.length);
        for (UUID id : deceased) {
            out.writeLong(id.getMostSignificantBits());
            out.writeLong(id.getLeastSignificantBits());
        }
        out.writeInt(left.length);
        for (UUID id : left) {
            out.writeLong(id.getMostSignificantBits());
            out.writeLong(id.getLeastSignificantBits());
        }
        out.writeInt(randomMembers.length);
        for (Member member : randomMembers) {
            member.writeTo(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readGossipData(DataInputStream in) throws IOException {
        int nrOfDeceased = in.readInt();
        if (nrOfDeceased < 0) {
            throw new IOException("negative deceased list value");
        }
        ArrayList<UUID> newDeceased = new ArrayList<UUID>();
        for (int i = 0; i < nrOfDeceased; ++i) {
            UUID id = new UUID(in.readLong(), in.readLong());
            newDeceased.add(id);
        }
        int nrOfLeft = in.readInt();
        if (nrOfLeft < 0) {
            throw new IOException("negative left list value");
        }
        ArrayList<UUID> newLeft = new ArrayList<UUID>();
        for (int i = 0; i < nrOfLeft; ++i) {
            UUID id = new UUID(in.readLong(), in.readLong());
            newLeft.add(id);
        }
        int nrOfMembers = in.readInt();
        if (nrOfMembers < 0) {
            throw new IOException("negative member list value");
        }
        ArrayList<Member> newMembers = new ArrayList<Member>();
        for (int i = 0; i < nrOfMembers; ++i) {
            Member member = new Member(in, this.properties);
            newMembers.add(member);
        }
        MemberSet memberSet = this;
        synchronized (memberSet) {
            for (Member member : newMembers) {
                UUID id = member.getUUID();
                if (this.members.containsKey(id)) {
                    this.members.get(id).merge(member);
                    continue;
                }
                if (this.deceased.contains(id) || this.left.contains(id)) continue;
                this.members.put(id, member);
                this.registry.ibisJoined(member.getIdentifier());
                if (this.statistics == null) continue;
                this.statistics.newPoolSize(this.members.size());
            }
            for (UUID id : newDeceased) {
                if (this.members.containsKey(id)) {
                    this.members.get(id).declareDead();
                    continue;
                }
                if (this.left.contains(id)) continue;
                this.deceased.add(id);
            }
            for (UUID id : newLeft) {
                if (this.members.containsKey(id)) {
                    this.members.get(id).setLeft();
                    continue;
                }
                this.left.add(id);
            }
        }
    }

    private synchronized void cleanup(Member member) {
        if (this.deceased.contains(member.getUUID())) {
            member.declareDead();
        }
        if (this.left.contains(member.getUUID())) {
            member.setLeft();
        }
        if (member.isSuspect() && member.nrOfWitnesses() >= this.liveMembers) {
            if (logger.isWarnEnabled()) {
                logger.warn("declared " + member + " with " + member.nrOfWitnesses() + " witnesses dead due to a low number of live members (" + this.liveMembers + ").");
            }
            member.declareDead();
        }
        if (member.hasLeft()) {
            this.left.add(member.getUUID());
            this.members.remove(member.getUUID());
            if (this.statistics != null) {
                this.statistics.newPoolSize(this.members.size());
            }
            this.registry.ibisLeft(member.getIdentifier());
            if (logger.isDebugEnabled()) {
                logger.debug("purged " + member + " from list");
            }
        } else if (member.isDead()) {
            this.deceased.add(member.getUUID());
            this.members.remove(member.getUUID());
            if (this.statistics != null) {
                this.statistics.newPoolSize(this.members.size());
            }
            this.registry.ibisDied(member.getIdentifier());
            if (logger.isDebugEnabled()) {
                logger.debug("purged " + member + " from list");
            }
        }
    }

    private synchronized void updateLiveMembers() {
        int result = 0;
        for (Member member : this.members.values()) {
            if (member.isDead() || member.hasLeft() || member.timedout()) continue;
            ++result;
        }
        this.liveMembers = result;
    }

    private synchronized void cleanup() {
        if (this.self != null) {
            this.self.seen();
        }
        this.updateLiveMembers();
        for (Member member : this.members.values().toArray(new Member[0])) {
            this.cleanup(member);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.self.getIdentifier() + ": members = " + this.members.size() + ", left = " + this.left.size() + " deceased = " + this.deceased.size());
        }
    }

    private synchronized Member[] getRandomSuspects(int count) {
        ArrayList<Member> suspects = new ArrayList<Member>();
        for (Member member : this.members.values()) {
            if (!member.isSuspect()) continue;
            suspects.add(member);
        }
        while (suspects.size() > count) {
            suspects.remove(this.random.nextInt(suspects.size()));
        }
        return suspects.toArray(new Member[0]);
    }

    synchronized Member[] getRandomMembers(int count) {
        if (count < 0) {
            return new Member[0];
        }
        ArrayList<Member> result = new ArrayList<Member>(this.members.values());
        while (result.size() > count) {
            result.remove(this.random.nextInt(result.size()));
        }
        return result.toArray(new Member[0]);
    }

    synchronized void printMembers() {
        System.out.println("pool at " + this.registry.getIbisIdentifier());
        System.out.println("dead:");
        for (UUID uUID : this.deceased) {
            System.out.println(uUID);
        }
        System.out.println("left:");
        for (UUID uUID : this.left) {
            System.out.println(uUID);
        }
        System.out.println("current:");
        for (Member member : this.members.values()) {
            System.out.println(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Member self;
        MemberSet memberSet = this;
        synchronized (memberSet) {
            this.self = self = new Member(this.registry.getIbisIdentifier(), this.properties);
            this.members.put(self.getUUID(), self);
            if (this.statistics != null) {
                this.statistics.newPoolSize(this.members.size());
            }
            this.registry.ibisJoined(self.getIdentifier());
        }
        long interval = this.properties.getIntProperty("ibis.registry.gossip.ping.interval") * 1000;
        int count = this.properties.getIntProperty("ibis.registry.gossip.ping.count");
        while (!this.registry.isStopped()) {
            this.cleanup();
            Member[] suspects = this.getRandomSuspects(count);
            if (logger.isDebugEnabled()) {
                logger.debug(self.getIdentifier() + ": checking " + suspects.length + " suspects");
            }
            for (Member suspect : suspects) {
                if (suspect.equals(self)) {
                    logger.error("we are a suspect ourselves");
                    suspect.seen();
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("suspecting " + suspect + " is dead, checking");
                }
                try {
                    this.registry.getCommHandler().ping(suspect.getIdentifier());
                    suspect.seen();
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("could not reach " + suspect + ", adding ourselves as witness");
                    }
                    suspect.suspectDead(this.registry.getIbisIdentifier());
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("done checking " + suspect);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(self.getIdentifier() + ": done checking " + suspects.length + " suspects");
            }
            int timeout = (int)(Math.random() * (double)interval);
            MemberSet memberSet2 = this;
            synchronized (memberSet2) {
                if (timeout > 0) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(self.getIdentifier() + ": registry stopped, exiting");
        }
    }
}

