/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.registry.gossip.CommunicationHandler;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.util.ThreadPool;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Broadcaster
implements Runnable {
    private static final int THREADS = 10;
    private static final Logger logger = LoggerFactory.getLogger(Broadcaster.class);
    private final CommunicationHandler commHandler;
    private List<VirtualSocketAddress> q;
    private int count;

    Broadcaster(CommunicationHandler commHandler, VirtualSocketAddress[] addresses) {
        this.commHandler = commHandler;
        this.q = new LinkedList<VirtualSocketAddress>();
        this.q.addAll(Arrays.asList(addresses));
        this.count = this.q.size();
        int threads = Math.min(10, this.count);
        for (int i = 0; i < threads; ++i) {
            ThreadPool.createNew((Runnable)this, (String)"broadcaster");
        }
    }

    synchronized VirtualSocketAddress next() {
        if (this.q.isEmpty()) {
            return null;
        }
        return this.q.remove(0);
    }

    synchronized void doneJob() {
        --this.count;
        if (this.count <= 0) {
            this.notifyAll();
        }
    }

    synchronized void waitUntilDone() {
        if (logger.isDebugEnabled()) {
            logger.debug("waiting until done, " + this.count + " remaining");
        }
        while (this.count > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (logger.isDebugEnabled()) {
            logger.debug("done!");
        }
    }

    @Override
    public void run() {
        VirtualSocketAddress address;
        while ((address = this.next()) != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("sending leave to " + address);
            }
            this.commHandler.sendLeave(address);
            this.doneJob();
        }
        return;
    }
}

