/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.server;

import ibis.io.Conversion;
import ibis.ipl.Credentials;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.impl.Location;
import ibis.ipl.registry.ControlPolicy;
import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.Protocol;
import ibis.ipl.registry.central.server.CentralRegistryService;
import ibis.ipl.registry.central.server.Pool;
import ibis.ipl.server.ServerProperties;
import ibis.ipl.support.Connection;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ThreadPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.AccessControlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerConnectionHandler
implements Runnable {
    private static final int CONNECTION_BACKLOG = 50;
    static final int MAX_THREADS = 50;
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectionHandler.class);
    private final CentralRegistryService server;
    private final VirtualSocketFactory socketFactory;
    private final VirtualServerSocket serverSocket;
    private int currentNrOfThreads = 0;
    private int maxNrOfThreads = 0;
    private ControlPolicy policy;

    ServerConnectionHandler(CentralRegistryService server, VirtualSocketFactory connectionFactory, ControlPolicy policy) throws IOException {
        this.server = server;
        this.socketFactory = connectionFactory;
        this.serverSocket = this.socketFactory.createServerSocket(302, 50, null);
        this.policy = policy;
        this.createThread();
    }

    private Pool handleJoin(Connection connection) throws Exception {
        Member member;
        String version = ServerProperties.implementationVersion;
        String peerVersion = connection.in().readUTF();
        if (peerVersion == null || !peerVersion.equals(version)) {
            throw new IOException("Wrong ipl server version in join: " + peerVersion + ", should be " + version);
        }
        int length = connection.in().readInt();
        if (length < 0) {
            throw new IOException("unexpected end of data on join");
        }
        byte[] clientAddress = new byte[length];
        connection.in().readFully(clientAddress);
        String poolName = connection.in().readUTF();
        length = connection.in().readInt();
        if (length < 0) {
            throw new IOException("unexpected end of data on join");
        }
        byte[] implementationData = new byte[length];
        connection.in().readFully(implementationData);
        String implementationVersion = connection.in().readUTF();
        Location location = new Location((DataInput)connection.in());
        boolean peerBootstrap = connection.in().readBoolean();
        long heartbeatInterval = connection.in().readLong();
        long eventPushInterval = connection.in().readLong();
        boolean gossip = connection.in().readBoolean();
        long gossipInterval = connection.in().readLong();
        boolean adaptGossipInterval = connection.in().readBoolean();
        boolean tree = connection.in().readBoolean();
        boolean closedWorld = connection.in().readBoolean();
        int poolSize = connection.in().readInt();
        boolean keepStatistics = connection.in().readBoolean();
        long statisticsInterval = connection.in().readLong();
        boolean purgeHistory = connection.in().readBoolean();
        length = connection.in().readInt();
        if (length < 0) {
            throw new IOException("unexpected end of data on join");
        }
        byte[] credentialBytes = new byte[length];
        connection.in().readFully(credentialBytes);
        Credentials credentials = (Credentials)Conversion.byte2object((byte[])credentialBytes);
        length = connection.in().readInt();
        byte[] applicationTag = null;
        if (length >= 0) {
            applicationTag = new byte[length];
            connection.in().readFully(applicationTag);
        }
        if (this.policy != null) {
            try {
                this.policy.onJoin(credentials);
            }
            catch (AccessControlException e) {
                connection.closeWithError(e.getMessage());
                throw e;
            }
        }
        Pool pool = this.server.getOrCreatePool(poolName, peerBootstrap, heartbeatInterval, eventPushInterval, gossip, gossipInterval, adaptGossipInterval, tree, closedWorld, poolSize, keepStatistics, statisticsInterval, purgeHistory, implementationVersion);
        try {
            member = pool.join(implementationData, clientAddress, location, implementationVersion, applicationTag);
        }
        catch (IOException e) {
            connection.closeWithError(e.getMessage());
            throw e;
        }
        connection.sendOKReply();
        member.getIbis().writeTo((DataOutput)connection.out());
        connection.out().writeInt(member.getEvent().getTime());
        connection.out().writeInt(member.getCurrentTime());
        pool.writeBootstrapList(connection.out());
        connection.out().flush();
        pool.gotHeartbeat(member.getIbis());
        return pool;
    }

    private Pool handleLeave(Connection connection) throws Exception {
        IbisIdentifier identifier = new IbisIdentifier((DataInput)connection.in());
        Pool pool = this.server.getPool(identifier.poolName());
        if (pool == null) {
            connection.closeWithError("pool not found");
            return null;
        }
        try {
            pool.leave(identifier);
        }
        catch (Exception e) {
            connection.closeWithError(e.toString());
            throw e;
        }
        connection.sendOKReply();
        pool.gotHeartbeat(identifier);
        return pool;
    }

    private Pool handleElect(Connection connection) throws Exception {
        IbisIdentifier candidate = new IbisIdentifier((DataInput)connection.in());
        String election = connection.in().readUTF();
        Pool pool = this.server.getPool(candidate.poolName());
        if (pool == null) {
            connection.closeWithError("pool not found");
            throw new Exception("pool " + candidate.poolName() + " not found");
        }
        IbisIdentifier winner = pool.elect(election, candidate);
        connection.sendOKReply();
        winner.writeTo((DataOutput)connection.out());
        pool.gotHeartbeat(candidate);
        return pool;
    }

    private Pool handleGetSequenceNumber(Connection connection) throws Exception {
        IbisIdentifier identifier = new IbisIdentifier((DataInput)connection.in());
        String name = connection.in().readUTF();
        Pool pool = this.server.getPool(identifier.poolName());
        if (pool == null) {
            connection.closeWithError("pool not found");
            throw new Exception("pool " + identifier.poolName() + " not found");
        }
        long number = pool.getSequenceNumber(name);
        connection.sendOKReply();
        connection.out().writeLong(number);
        pool.gotHeartbeat(identifier);
        return pool;
    }

    private Pool handleDead(Connection connection) throws Exception {
        IbisIdentifier identifier = new IbisIdentifier((DataInput)connection.in());
        IbisIdentifier corpse = new IbisIdentifier((DataInput)connection.in());
        Pool pool = this.server.getPool(identifier.poolName());
        if (pool == null) {
            connection.closeWithError("pool not found");
            throw new Exception("pool " + identifier.poolName() + " not found");
        }
        try {
            pool.dead(corpse, new Exception("ibis declared dead by " + identifier));
        }
        catch (Exception e) {
            connection.closeWithError(e.getMessage());
            throw e;
        }
        connection.sendOKReply();
        pool.gotHeartbeat(identifier);
        return pool;
    }

    private Pool handleMaybeDead(Connection connection) throws Exception {
        IbisIdentifier identifier = new IbisIdentifier((DataInput)connection.in());
        IbisIdentifier suspect = new IbisIdentifier((DataInput)connection.in());
        Pool pool = this.server.getPool(identifier.poolName());
        if (pool == null) {
            connection.closeWithError("pool not found");
            throw new Exception("pool " + identifier.poolName() + " not found");
        }
        pool.maybeDead(suspect);
        connection.sendOKReply();
        pool.gotHeartbeat(identifier);
        return pool;
    }

    private Pool handleSignal(Connection connection) throws Exception {
        IbisIdentifier identifier = new IbisIdentifier((DataInput)connection.in());
        String signal = connection.in().readUTF();
        IbisIdentifier[] receivers = new IbisIdentifier[connection.in().readInt()];
        for (int i = 0; i < receivers.length; ++i) {
            receivers[i] = new IbisIdentifier((DataInput)connection.in());
        }
        Pool pool = this.server.getPool(identifier.poolName());
        if (pool == null) {
            connection.closeWithError("pool not found");
            throw new Exception("pool " + identifier.poolName() + " not found");
        }
        pool.signal(signal, identifier, receivers);
        connection.sendOKReply();
        pool.gotHeartbeat(identifier);
        return pool;
    }

    private Pool handleGetState(Connection connection) throws Exception {
        IbisIdentifier identifier = new IbisIdentifier((DataInput)connection.in());
        int joinTime = connection.in().readInt();
        Pool pool = this.server.getPool(identifier.poolName());
        if (pool == null) {
            connection.closeWithError("pool not found");
            throw new Exception("pool " + identifier.poolName() + " not found");
        }
        connection.sendOKReply();
        pool.writeState(connection.out(), joinTime);
        connection.out().flush();
        pool.gotHeartbeat(identifier);
        return pool;
    }

    private Pool handleHeartbeat(Connection connection) throws Exception {
        IbisIdentifier identifier = new IbisIdentifier((DataInput)connection.in());
        Pool pool = this.server.getPool(identifier.poolName());
        if (pool == null) {
            connection.closeWithError("pool not found");
            throw new Exception("pool " + identifier.poolName() + " not found");
        }
        connection.sendOKReply();
        pool.gotHeartbeat(identifier);
        return pool;
    }

    private Pool handleTerminate(Connection connection) throws Exception {
        IbisIdentifier source = new IbisIdentifier((DataInput)connection.in());
        Pool pool = this.server.getPool(source.poolName());
        if (pool == null) {
            connection.closeWithError("pool not found");
            throw new Exception("pool " + source.poolName() + " not found");
        }
        pool.terminate(source);
        connection.sendOKReply();
        pool.gotHeartbeat(source);
        return pool;
    }

    private synchronized void createThread() {
        while (this.currentNrOfThreads >= 50) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ThreadPool.createNew((Runnable)this, (String)"server connection handler");
        ++this.currentNrOfThreads;
        if (this.currentNrOfThreads > this.maxNrOfThreads) {
            this.maxNrOfThreads = this.currentNrOfThreads;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Now " + this.currentNrOfThreads + " connections");
        }
    }

    private synchronized void threadEnded() {
        --this.currentNrOfThreads;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        connection = null;
        try {
            if (ServerConnectionHandler.logger.isDebugEnabled()) {
                ServerConnectionHandler.logger.debug("accepting connection");
            }
            connection = new Connection(this.serverSocket);
            if (ServerConnectionHandler.logger.isDebugEnabled()) {
                ServerConnectionHandler.logger.debug("connection accepted");
            }
        }
        catch (IOException e) {
            if (this.server.isStopped()) {
                this.threadEnded();
                return;
            }
            ServerConnectionHandler.logger.error("Accept failed, waiting a second, will retry", (Throwable)e);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException var3_4) {
                // empty catch block
            }
        }
        this.createThread();
        if (connection == null) {
            this.threadEnded();
            return;
        }
        start = System.currentTimeMillis();
        opcode = 0;
        pool = null;
        try {
            magic = connection.in().readByte();
            if (magic != 54) {
                throw new IOException("Invalid header byte in accepting connection");
            }
            opcode = connection.in().readByte();
            if (ServerConnectionHandler.logger.isDebugEnabled() && opcode < 15) {
                ServerConnectionHandler.logger.debug("got request, opcode = " + Protocol.OPCODE_NAMES[opcode]);
            }
            switch (opcode) {
                case 0: {
                    pool = this.handleJoin(connection);
                    ** break;
lbl37:
                    // 1 sources

                    break;
                }
                case 1: {
                    pool = this.handleLeave(connection);
                    ** break;
lbl41:
                    // 1 sources

                    break;
                }
                case 3: {
                    pool = this.handleElect(connection);
                    ** break;
lbl45:
                    // 1 sources

                    break;
                }
                case 4: {
                    pool = this.handleGetSequenceNumber(connection);
                    ** break;
lbl49:
                    // 1 sources

                    break;
                }
                case 5: {
                    pool = this.handleDead(connection);
                    ** break;
lbl53:
                    // 1 sources

                    break;
                }
                case 6: {
                    pool = this.handleMaybeDead(connection);
                    ** break;
lbl57:
                    // 1 sources

                    break;
                }
                case 7: {
                    pool = this.handleSignal(connection);
                    ** break;
lbl61:
                    // 1 sources

                    break;
                }
                case 12: {
                    pool = this.handleGetState(connection);
                    ** break;
lbl65:
                    // 1 sources

                    break;
                }
                case 13: {
                    pool = this.handleHeartbeat(connection);
                    ** break;
lbl69:
                    // 1 sources

                    break;
                }
                case 14: {
                    pool = this.handleTerminate(connection);
                    ** break;
lbl73:
                    // 1 sources

                    break;
                }
                default: {
                    ServerConnectionHandler.logger.error("unknown opcode: " + opcode);
                    break;
                }
            }
        }
        catch (Exception e) {
            connection.closeWithError("Server: " + e.getMessage());
            ServerConnectionHandler.logger.error("error on handling connection", (Throwable)e);
        }
        finally {
            connection.close();
        }
        if (pool != null) {
            if (pool.getStatistics() != null) {
                pool.getStatistics().add(opcode, System.currentTimeMillis() - start, connection.read(), connection.written(), true);
                if (ServerConnectionHandler.logger.isDebugEnabled()) {
                    ServerConnectionHandler.logger.debug("done handling request");
                }
            }
            if (pool.hasEnded()) {
                pool.saveStatistics();
            }
        }
        this.threadEnded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isInfoEnabled()) {
            ServerConnectionHandler serverConnectionHandler = this;
            synchronized (serverConnectionHandler) {
                logger.debug("max simultanious connections was: " + this.maxNrOfThreads);
            }
        }
    }
}

