/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.server;

import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.server.Pool;
import ibis.util.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RandomEventPusher
implements Runnable {
    private static final int THREADS = 25;
    private static final Logger logger = LoggerFactory.getLogger(RandomEventPusher.class);
    private final Pool pool;
    private final long interval;
    private final boolean adaptInterval;
    private int currentThreads;

    RandomEventPusher(Pool pool, long interval, boolean adaptInterval) {
        this.pool = pool;
        this.interval = interval;
        this.adaptInterval = adaptInterval;
        this.currentThreads = 0;
        new Scheduler();
    }

    private synchronized void createNewThread() {
        if (this.currentThreads >= 25) {
            if (logger.isDebugEnabled()) {
                logger.debug("not creating thread, maximum reached");
            }
            return;
        }
        ThreadPool.createNew((Runnable)this, (String)"node contactor");
        ++this.currentThreads;
    }

    private synchronized void threadDone() {
        --this.currentThreads;
    }

    @Override
    public void run() {
        Member member = this.pool.getRandomMember();
        if (member == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("no member to contact");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("gossiping/pushing to " + member);
            }
            this.pool.push(member, false, false);
        }
        this.threadDone();
    }

    private class Scheduler
    implements Runnable {
        Scheduler() {
            ThreadPool.createNew((Runnable)this, (String)"scheduler thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!RandomEventPusher.this.pool.hasEnded()) {
                int poolSize;
                long timeout = RandomEventPusher.this.interval;
                RandomEventPusher.this.createNewThread();
                if (RandomEventPusher.this.adaptInterval && (poolSize = RandomEventPusher.this.pool.getSize()) > 1) {
                    timeout = (long)((double)timeout / (Math.log(poolSize) / Math.log(2.0)));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("waiting " + timeout);
                }
                Scheduler scheduler = this;
                synchronized (scheduler) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

