/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.server;

import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.server.Pool;
import ibis.util.ThreadPool;
import java.util.LinkedHashSet;
import java.util.Set;

public class OndemandEventPusher
implements Runnable {
    private final Pool pool;
    private final Set<Member> q;

    public OndemandEventPusher(Pool pool) {
        this.pool = pool;
        this.q = new LinkedHashSet<Member>();
        ThreadPool.createNew((Runnable)this, (String)"Pusher");
    }

    public synchronized void enqueue(Member member) {
        this.q.add(member);
    }

    public synchronized Member dequeue() {
        while (this.q.isEmpty()) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {}
        }
        Member result = this.q.iterator().next();
        this.q.remove(result);
        return result;
    }

    @Override
    public void run() {
        Member next;
        while ((next = this.dequeue()) != null) {
            this.pool.push(next, true, false);
        }
        return;
    }
}

