/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.client;

import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.client.CommunicationHandler;
import ibis.ipl.registry.central.client.Pool;
import ibis.util.ThreadPool;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IterativeEventPusher
extends Thread {
    private static final int THREADS = 10;
    private static final Logger logger = LoggerFactory.getLogger(IterativeEventPusher.class);
    private final Pool pool;
    private final CommunicationHandler commHandler;

    IterativeEventPusher(Pool pool, CommunicationHandler commHandler) {
        this.pool = pool;
        this.commHandler = commHandler;
    }

    @Override
    public void run() {
        while (!this.pool.isStopped()) {
            int eventTime = this.pool.getTime();
            Member[] children = this.pool.getChildren();
            logger.debug("updating " + children.length + " children in pool to event-time " + eventTime);
            WorkQ workQ = new WorkQ(children);
            int threads = Math.min(10, children.length);
            for (int i = 0; i < threads; ++i) {
                new EventPusherThread(workQ);
            }
            workQ.waitUntilDone();
            logger.debug("DONE updating nodes in pool to event-time " + eventTime);
            this.pool.waitForEventTime(eventTime + 1, 1000L);
        }
    }

    private class EventPusherThread
    implements Runnable {
        WorkQ workQ;

        EventPusherThread(WorkQ workQ) {
            this.workQ = workQ;
            ThreadPool.createNew((Runnable)this, (String)"event pusher thread");
        }

        @Override
        public void run() {
            Member work;
            while ((work = this.workQ.next()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("pushing to " + work);
                }
                IterativeEventPusher.this.commHandler.forward(work.getIbis());
                this.workQ.doneJob();
            }
            return;
        }
    }

    private class WorkQ {
        private List<Member> q = new LinkedList<Member>();
        private int count;

        WorkQ(Member[] work) {
            this.q.addAll(Arrays.asList(work));
            this.count = this.q.size();
        }

        synchronized Member next() {
            if (this.q.isEmpty()) {
                return null;
            }
            return this.q.remove(0);
        }

        synchronized void doneJob() {
            --this.count;
            if (this.count <= 0) {
                this.notifyAll();
            }
        }

        synchronized void waitUntilDone() {
            while (this.count > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

