/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.client;

import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.client.CommunicationHandler;
import ibis.ipl.registry.central.client.Pool;
import ibis.util.ThreadPool;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gossiper
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Gossiper.class);
    private final CommunicationHandler commHandler;
    private final Pool pool;
    private final long gossipInterval;

    Gossiper(CommunicationHandler commHandler, Pool pool, long gossipInterval) {
        this.commHandler = commHandler;
        this.pool = pool;
        this.gossipInterval = gossipInterval;
        ThreadPool.createNew((Runnable)this, (String)"gossiper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.pool.isStopped()) {
            Member member = this.pool.getRandomMember();
            if (member != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("gossiping with " + member);
                }
                try {
                    this.commHandler.gossip(member.getIbis());
                }
                catch (IOException e) {
                    logger.warn("could not gossip with " + member);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Event time at " + this.commHandler.getIdentifier().getID() + " now " + this.pool.getTime());
                }
            }
            Gossiper gossiper = this;
            synchronized (gossiper) {
                try {
                    this.wait((int)(Math.random() * (double)this.gossipInterval * 2.0));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

