/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central;

import ibis.io.IbisSerializationInputStream;
import ibis.io.IbisSerializationOutputStream;
import ibis.ipl.impl.IbisIdentifier;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class Event
implements Serializable,
Comparable<Event> {
    public static final int DIED = 2;
    public static final int ELECT = 4;
    public static final int JOIN = 0;
    public static final int LEAVE = 1;
    public static final int NR_OF_TYPES = 8;
    public static final int POOL_CLOSED = 6;
    public static final int POOL_TERMINATED = 7;
    public static final int SIGNAL = 3;
    public static final int UN_ELECT = 5;
    private final String description;
    private final IbisIdentifier[] destinations;
    private final IbisIdentifier ibis;
    private static final long serialVersionUID = 1L;
    private final int time;
    private final int type;

    public Event(int time, int type, String description, IbisIdentifier ibis, IbisIdentifier ... destinations) {
        this.time = time;
        this.type = type;
        this.ibis = ibis;
        this.destinations = (IbisIdentifier[])destinations.clone();
        this.description = description == null ? "" : description;
        if (type != 3 && destinations.length != 0) {
            throw new Error("only the signal type event can have a destination");
        }
    }

    public Event(DataInput in) throws IOException {
        this.time = in.readInt();
        this.type = in.readInt();
        this.description = in.readUTF();
        this.ibis = in.readBoolean() ? new IbisIdentifier(in) : null;
        this.destinations = new IbisIdentifier[in.readInt()];
        for (int i = 0; i < this.destinations.length; ++i) {
            this.destinations[i] = new IbisIdentifier(in);
        }
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.time);
        out.writeInt(this.type);
        out.writeUTF(this.description);
        if (this.ibis != null) {
            out.writeBoolean(true);
            this.ibis.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.destinations.length);
        for (int i = 0; i < this.destinations.length; ++i) {
            this.destinations[i].writeTo(out);
        }
    }

    public int getTime() {
        return this.time;
    }

    public String getDescription() {
        return this.description;
    }

    public IbisIdentifier getIbis() {
        return this.ibis;
    }

    public IbisIdentifier[] getDestinations() {
        return (IbisIdentifier[])this.destinations.clone();
    }

    public int getType() {
        return this.type;
    }

    private String typeString() {
        switch (this.type) {
            case 0: {
                return "JOIN";
            }
            case 1: {
                return "LEAVE";
            }
            case 2: {
                return "DIED";
            }
            case 3: {
                return "SIGNAL";
            }
            case 4: {
                return "ELECT";
            }
            case 5: {
                return "UN_ELECT";
            }
            case 6: {
                return "POOL_CLOSED";
            }
            case 7: {
                return "POOL_TERMINATED";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return this.typeString() + "@" + this.time;
    }

    @Override
    public int compareTo(Event other) {
        return this.time - other.time;
    }

    public final void generated_WriteObject(IbisSerializationOutputStream ibisSerializationOutputStream) throws IOException {
        ibisSerializationOutputStream.writeInt(this.time);
        ibisSerializationOutputStream.writeInt(this.type);
        ibisSerializationOutputStream.writeString(this.description);
        ibisSerializationOutputStream.writeObject((Object)this.destinations);
        ibisSerializationOutputStream.writeObject((Object)this.ibis);
    }

    public final void generated_DefaultWriteObject(IbisSerializationOutputStream ibisSerializationOutputStream, int n) throws IOException {
        block0: {
            if (n != 1) break block0;
            ibisSerializationOutputStream.writeInt(this.time);
            ibisSerializationOutputStream.writeInt(this.type);
            ibisSerializationOutputStream.writeString(this.description);
            ibisSerializationOutputStream.writeObject((Object)this.destinations);
            ibisSerializationOutputStream.writeObject((Object)this.ibis);
        }
    }

    public final void generated_DefaultReadObject(IbisSerializationInputStream ibisSerializationInputStream, int n) throws IOException, ClassNotFoundException {
        block0: {
            if (n != 1) break block0;
            ibisSerializationInputStream.readFieldInt((Object)this, "time", "ibis.ipl.registry.central.Event");
            ibisSerializationInputStream.readFieldInt((Object)this, "type", "ibis.ipl.registry.central.Event");
            ibisSerializationInputStream.readFieldString((Object)this, "description", "ibis.ipl.registry.central.Event");
            ibisSerializationInputStream.readFieldObject((Object)this, "destinations", "ibis.ipl.registry.central.Event", "[Libis/ipl/impl/IbisIdentifier;");
            ibisSerializationInputStream.readFieldObject((Object)this, "ibis", "ibis.ipl.registry.central.Event", "Libis/ipl/impl/IbisIdentifier;");
        }
    }

    public Event(IbisSerializationInputStream ibisSerializationInputStream) throws IOException, ClassNotFoundException {
        ibisSerializationInputStream.addObjectToCycleCheck((Object)this);
        this.time = ibisSerializationInputStream.readInt();
        this.type = ibisSerializationInputStream.readInt();
        this.description = ibisSerializationInputStream.readString();
        this.destinations = (IbisIdentifier[])ibisSerializationInputStream.readObject();
        this.ibis = (IbisIdentifier)ibisSerializationInputStream.readObject();
    }
}

