/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v2.parser;

public class Literal {
    public static final int NUMBER = 23;
    public static final int STRING = 24;
    public static final int SYMBOL = 22;
    public static final int BOOLEAN = -1;
    public static final int DEBUG_LEVEL = -2;
    private int m_type;
    private String m_value;

    public Literal(int type, String value) {
        this.m_type = type;
        switch (type) {
            case 22: {
                break;
            }
            case 23: {
                Double.parseDouble(value);
                break;
            }
            case 24: {
                try {
                    Double.parseDouble(value);
                    this.m_type = 23;
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case -1: 
            case 36: 
            case 37: {
                this.m_type = -1;
                if (!value.toLowerCase().equals("false") && !value.toLowerCase().equals("true")) {
                    throw new IllegalArgumentException("Invalid boolean value");
                }
                value = value.toLowerCase();
                break;
            }
            case -2: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                this.m_type = -2;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported type " + type);
            }
        }
        this.m_value = value;
    }

    public String toString() {
        String type = "[UNKNOWN TYPE]";
        switch (this.m_type) {
            case 23: {
                type = "NUMBER";
                break;
            }
            case 24: {
                type = "STRING";
                break;
            }
            case -1: {
                type = "BOOLEAN";
                break;
            }
            case 22: {
                type = "SYMBOL";
                break;
            }
            case -2: {
                type = "DEBUG_LEVEL";
            }
        }
        return type + " " + this.m_value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Literal) {
            Literal other = (Literal)obj;
            return other.m_type == this.m_type && other.m_value.equals(this.m_value);
        }
        return false;
    }

    public boolean isFalse() {
        return this.m_type == -1 && this.m_value.equals("false");
    }

    public boolean isTrue() {
        return this.m_type == -1 && this.m_value.equals("true");
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean isDebugLevel() {
        return this.m_type == -2;
    }

    public boolean isNumber() {
        return this.m_type == 23;
    }

    public boolean isString() {
        return this.m_type == 24;
    }

    public boolean isSymbol() {
        return this.m_type == 22;
    }

    public boolean isBoolean() {
        return this.m_type == -1;
    }
}

