/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.attribute;

import de.javawi.jstun.attribute.MessageAttribute;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.util.Address;
import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;

public class MappedResponseChangedSourceAddressReflectedFrom
extends MessageAttribute {
    int port;
    Address address;

    public MappedResponseChangedSourceAddressReflectedFrom() {
        try {
            this.port = 0;
            this.address = new Address("0.0.0.0");
        }
        catch (UtilityException ue) {
            ue.getMessage();
            ue.printStackTrace();
        }
    }

    public MappedResponseChangedSourceAddressReflectedFrom(MessageAttributeInterface.MessageAttributeType type) {
        super(type);
    }

    public int getPort() {
        return this.port;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setPort(int port) throws MessageAttributeException {
        if (port > 65536 || port < 0) {
            throw new MessageAttributeException("Port value " + port + " out of range.");
        }
        this.port = port;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public byte[] getBytes() throws UtilityException {
        byte[] result = new byte[12];
        System.arraycopy(Utility.IntegerToTwoBytes(MappedResponseChangedSourceAddressReflectedFrom.typeToInteger(this.type)), 0, result, 0, 2);
        System.arraycopy(Utility.IntegerToTwoBytes(8), 0, result, 2, 2);
        result[5] = Utility.IntegerToOneByte(1);
        System.arraycopy(Utility.IntegerToTwoBytes(this.port), 0, result, 6, 2);
        System.arraycopy(this.address.getBytes(), 0, result, 8, 4);
        return result;
    }

    protected static MappedResponseChangedSourceAddressReflectedFrom parse(MappedResponseChangedSourceAddressReflectedFrom ma, byte[] data) throws MessageAttributeParsingException {
        try {
            if (data.length < 8) {
                throw new MessageAttributeParsingException("Data array too short");
            }
            int family = Utility.OneByteToInteger(data[1]);
            if (family != 1) {
                throw new MessageAttributeParsingException("Family " + family + " is not supported");
            }
            byte[] portArray = new byte[2];
            System.arraycopy(data, 2, portArray, 0, 2);
            ma.setPort(Utility.TwoBytesToInteger(portArray));
            int firstOctet = Utility.OneByteToInteger(data[4]);
            int secondOctet = Utility.OneByteToInteger(data[5]);
            int thirdOctet = Utility.OneByteToInteger(data[6]);
            int fourthOctet = Utility.OneByteToInteger(data[7]);
            ma.setAddress(new Address(firstOctet, secondOctet, thirdOctet, fourthOctet));
            return ma;
        }
        catch (UtilityException ue) {
            throw new MessageAttributeParsingException("Parsing error");
        }
        catch (MessageAttributeException mae) {
            throw new MessageAttributeParsingException("Port parsing error");
        }
    }

    public String toString() {
        return "Address " + this.address.toString() + ", Port " + this.port;
    }
}

