/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl;

import ibis.ipl.CapabilitySet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class IbisCapabilities
extends CapabilitySet {
    public static final String CLOSED_WORLD = "closed.world";
    public static final String SIGNALS = "signals";
    public static final String TERMINATION = "termination";
    public static final String ELECTIONS_UNRELIABLE = "elections.unreliable";
    public static final String ELECTIONS_STRICT = "elections.strict";
    public static final String MEMBERSHIP_UNRELIABLE = "membership.unreliable";
    public static final String MEMBERSHIP_TOTALLY_ORDERED = "membership.totally.ordered";
    public static final String MALLEABLE = "malleable";

    public IbisCapabilities(String ... capabilities) {
        super(capabilities);
    }

    protected IbisCapabilities(Properties properties) {
        super(properties);
    }

    protected IbisCapabilities(CapabilitySet capabilitySet) {
        super(capabilitySet);
    }

    public static IbisCapabilities load(String capabilityFileName) throws IOException {
        InputStream input = ClassLoader.getSystemClassLoader().getResourceAsStream(capabilityFileName);
        if (input == null) {
            throw new IOException("Could not open " + capabilityFileName);
        }
        return IbisCapabilities.load(input);
    }

    public static IbisCapabilities load(InputStream input) throws IOException {
        Properties properties = new Properties();
        properties.load(input);
        input.close();
        return new IbisCapabilities(properties);
    }
}

