import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::SSM::Association`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 * @external
 */
export interface CfnAssociationProps {
    /**
     * `AWS::SSM::Association.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::SSM::Association.ApplyOnlyAtCronInterval`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-applyonlyatcroninterval
     * @external
     */
    readonly applyOnlyAtCronInterval?: boolean | cdk.IResolvable;
    /**
     * `AWS::SSM::Association.AssociationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-associationname
     * @external
     */
    readonly associationName?: string;
    /**
     * `AWS::SSM::Association.AutomationTargetParameterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-automationtargetparametername
     * @external
     */
    readonly automationTargetParameterName?: string;
    /**
     * `AWS::SSM::Association.ComplianceSeverity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-complianceseverity
     * @external
     */
    readonly complianceSeverity?: string;
    /**
     * `AWS::SSM::Association.DocumentVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-documentversion
     * @external
     */
    readonly documentVersion?: string;
    /**
     * `AWS::SSM::Association.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-instanceid
     * @external
     */
    readonly instanceId?: string;
    /**
     * `AWS::SSM::Association.MaxConcurrency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxconcurrency
     * @external
     */
    readonly maxConcurrency?: string;
    /**
     * `AWS::SSM::Association.MaxErrors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxerrors
     * @external
     */
    readonly maxErrors?: string;
    /**
     * `AWS::SSM::Association.OutputLocation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-outputlocation
     * @external
     */
    readonly outputLocation?: CfnAssociation.InstanceAssociationOutputLocationProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::Association.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-parameters
     * @external
     */
    readonly parameters?: {
        [key: string]: (string[]);
    } | cdk.IResolvable;
    /**
     * `AWS::SSM::Association.ScheduleExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleexpression
     * @external
     */
    readonly scheduleExpression?: string;
    /**
     * `AWS::SSM::Association.SyncCompliance`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-synccompliance
     * @external
     */
    readonly syncCompliance?: string;
    /**
     * `AWS::SSM::Association.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-targets
     * @external
     */
    readonly targets?: Array<CfnAssociation.TargetProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::Association.WaitForSuccessTimeoutSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-waitforsuccesstimeoutseconds
     * @external
     */
    readonly waitForSuccessTimeoutSeconds?: number;
}
/**
 * A CloudFormation `AWS::SSM::Association`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 * @external
 * @cloudformationResource AWS::SSM::Association
 */
export declare class CfnAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Association";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAssociation;
    /**
     * @external
     * @cloudformationAttribute AssociationId
     */
    readonly attrAssociationId: string;
    /**
     * `AWS::SSM::Association.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-name
     * @external
     */
    name: string;
    /**
     * `AWS::SSM::Association.ApplyOnlyAtCronInterval`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-applyonlyatcroninterval
     * @external
     */
    applyOnlyAtCronInterval: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::Association.AssociationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-associationname
     * @external
     */
    associationName: string | undefined;
    /**
     * `AWS::SSM::Association.AutomationTargetParameterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-automationtargetparametername
     * @external
     */
    automationTargetParameterName: string | undefined;
    /**
     * `AWS::SSM::Association.ComplianceSeverity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-complianceseverity
     * @external
     */
    complianceSeverity: string | undefined;
    /**
     * `AWS::SSM::Association.DocumentVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-documentversion
     * @external
     */
    documentVersion: string | undefined;
    /**
     * `AWS::SSM::Association.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-instanceid
     * @external
     */
    instanceId: string | undefined;
    /**
     * `AWS::SSM::Association.MaxConcurrency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxconcurrency
     * @external
     */
    maxConcurrency: string | undefined;
    /**
     * `AWS::SSM::Association.MaxErrors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxerrors
     * @external
     */
    maxErrors: string | undefined;
    /**
     * `AWS::SSM::Association.OutputLocation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-outputlocation
     * @external
     */
    outputLocation: CfnAssociation.InstanceAssociationOutputLocationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::Association.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-parameters
     * @external
     */
    parameters: {
        [key: string]: (string[]);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::Association.ScheduleExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleexpression
     * @external
     */
    scheduleExpression: string | undefined;
    /**
     * `AWS::SSM::Association.SyncCompliance`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-synccompliance
     * @external
     */
    syncCompliance: string | undefined;
    /**
     * `AWS::SSM::Association.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-targets
     * @external
     */
    targets: Array<CfnAssociation.TargetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::Association.WaitForSuccessTimeoutSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-waitforsuccesstimeoutseconds
     * @external
     */
    waitForSuccessTimeoutSeconds: number | undefined;
    /**
     * Create a new `AWS::SSM::Association`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::Association`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 * @external
 * @cloudformationResource AWS::SSM::Association
 */
export declare namespace CfnAssociation {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html
     * @external
     */
    interface InstanceAssociationOutputLocationProperty {
        /**
         * `CfnAssociation.InstanceAssociationOutputLocationProperty.S3Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html#cfn-ssm-association-instanceassociationoutputlocation-s3location
         * @external
         */
        readonly s3Location?: CfnAssociation.S3OutputLocationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SSM::Association`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 * @external
 * @cloudformationResource AWS::SSM::Association
 */
export declare namespace CfnAssociation {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-parametervalues.html
     * @external
     */
    interface ParameterValuesProperty {
        /**
         * `CfnAssociation.ParameterValuesProperty.ParameterValues`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-parametervalues.html#cfn-ssm-association-parametervalues-parametervalues
         * @external
         */
        readonly parameterValues?: string[];
    }
}
/**
 * A CloudFormation `AWS::SSM::Association`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 * @external
 * @cloudformationResource AWS::SSM::Association
 */
export declare namespace CfnAssociation {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html
     * @external
     */
    interface S3OutputLocationProperty {
        /**
         * `CfnAssociation.S3OutputLocationProperty.OutputS3BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3bucketname
         * @external
         */
        readonly outputS3BucketName?: string;
        /**
         * `CfnAssociation.S3OutputLocationProperty.OutputS3KeyPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3keyprefix
         * @external
         */
        readonly outputS3KeyPrefix?: string;
        /**
         * `CfnAssociation.S3OutputLocationProperty.OutputS3Region`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-s3outputlocation.html#cfn-ssm-association-s3outputlocation-outputs3region
         * @external
         */
        readonly outputS3Region?: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::Association`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 * @external
 * @cloudformationResource AWS::SSM::Association
 */
export declare namespace CfnAssociation {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html
     * @external
     */
    interface TargetProperty {
        /**
         * `CfnAssociation.TargetProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html#cfn-ssm-association-target-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnAssociation.TargetProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-target.html#cfn-ssm-association-target-values
         * @external
         */
        readonly values: string[];
    }
}
/**
 * Properties for defining a `AWS::SSM::Document`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html
 * @external
 */
export interface CfnDocumentProps {
    /**
     * `AWS::SSM::Document.Content`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-content
     * @external
     */
    readonly content: any | cdk.IResolvable;
    /**
     * `AWS::SSM::Document.DocumentType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-documenttype
     * @external
     */
    readonly documentType?: string;
    /**
     * `AWS::SSM::Document.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::SSM::Document.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SSM::Document`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html
 * @external
 * @cloudformationResource AWS::SSM::Document
 */
export declare class CfnDocument extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Document";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDocument;
    /**
     * `AWS::SSM::Document.Content`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-content
     * @external
     */
    content: any | cdk.IResolvable;
    /**
     * `AWS::SSM::Document.DocumentType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-documenttype
     * @external
     */
    documentType: string | undefined;
    /**
     * `AWS::SSM::Document.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::SSM::Document.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SSM::Document`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDocumentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SSM::MaintenanceWindow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html
 * @external
 */
export interface CfnMaintenanceWindowProps {
    /**
     * `AWS::SSM::MaintenanceWindow.AllowUnassociatedTargets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-allowunassociatedtargets
     * @external
     */
    readonly allowUnassociatedTargets: boolean | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindow.Cutoff`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-cutoff
     * @external
     */
    readonly cutoff: number;
    /**
     * `AWS::SSM::MaintenanceWindow.Duration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-duration
     * @external
     */
    readonly duration: number;
    /**
     * `AWS::SSM::MaintenanceWindow.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::SSM::MaintenanceWindow.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-schedule
     * @external
     */
    readonly schedule: string;
    /**
     * `AWS::SSM::MaintenanceWindow.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::SSM::MaintenanceWindow.EndDate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-enddate
     * @external
     */
    readonly endDate?: string;
    /**
     * `AWS::SSM::MaintenanceWindow.ScheduleOffset`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-scheduleoffset
     * @external
     */
    readonly scheduleOffset?: number;
    /**
     * `AWS::SSM::MaintenanceWindow.ScheduleTimezone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-scheduletimezone
     * @external
     */
    readonly scheduleTimezone?: string;
    /**
     * `AWS::SSM::MaintenanceWindow.StartDate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-startdate
     * @external
     */
    readonly startDate?: string;
    /**
     * `AWS::SSM::MaintenanceWindow.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindow
 */
export declare class CfnMaintenanceWindow extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindow";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMaintenanceWindow;
    /**
     * `AWS::SSM::MaintenanceWindow.AllowUnassociatedTargets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-allowunassociatedtargets
     * @external
     */
    allowUnassociatedTargets: boolean | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindow.Cutoff`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-cutoff
     * @external
     */
    cutoff: number;
    /**
     * `AWS::SSM::MaintenanceWindow.Duration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-duration
     * @external
     */
    duration: number;
    /**
     * `AWS::SSM::MaintenanceWindow.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-name
     * @external
     */
    name: string;
    /**
     * `AWS::SSM::MaintenanceWindow.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-schedule
     * @external
     */
    schedule: string;
    /**
     * `AWS::SSM::MaintenanceWindow.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindow.EndDate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-enddate
     * @external
     */
    endDate: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindow.ScheduleOffset`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-scheduleoffset
     * @external
     */
    scheduleOffset: number | undefined;
    /**
     * `AWS::SSM::MaintenanceWindow.ScheduleTimezone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-scheduletimezone
     * @external
     */
    scheduleTimezone: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindow.StartDate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-startdate
     * @external
     */
    startDate: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindow.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html#cfn-ssm-maintenancewindow-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SSM::MaintenanceWindow`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMaintenanceWindowProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SSM::MaintenanceWindowTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html
 * @external
 */
export interface CfnMaintenanceWindowTargetProps {
    /**
     * `AWS::SSM::MaintenanceWindowTarget.ResourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-resourcetype
     * @external
     */
    readonly resourceType: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-targets
     * @external
     */
    readonly targets: Array<CfnMaintenanceWindowTarget.TargetsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.WindowId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-windowid
     * @external
     */
    readonly windowId: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.OwnerInformation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-ownerinformation
     * @external
     */
    readonly ownerInformation?: string;
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTarget
 */
export declare class CfnMaintenanceWindowTarget extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindowTarget";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMaintenanceWindowTarget;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.ResourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-resourcetype
     * @external
     */
    resourceType: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-targets
     * @external
     */
    targets: Array<CfnMaintenanceWindowTarget.TargetsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.WindowId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-windowid
     * @external
     */
    windowId: string;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTarget.OwnerInformation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html#cfn-ssm-maintenancewindowtarget-ownerinformation
     * @external
     */
    ownerInformation: string | undefined;
    /**
     * Create a new `AWS::SSM::MaintenanceWindowTarget`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMaintenanceWindowTargetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTarget
 */
export declare namespace CfnMaintenanceWindowTarget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtarget-targets.html
     * @external
     */
    interface TargetsProperty {
        /**
         * `CfnMaintenanceWindowTarget.TargetsProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtarget-targets.html#cfn-ssm-maintenancewindowtarget-targets-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnMaintenanceWindowTarget.TargetsProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtarget-targets.html#cfn-ssm-maintenancewindowtarget-targets-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * Properties for defining a `AWS::SSM::MaintenanceWindowTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 * @external
 */
export interface CfnMaintenanceWindowTaskProps {
    /**
     * `AWS::SSM::MaintenanceWindowTask.MaxConcurrency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxconcurrency
     * @external
     */
    readonly maxConcurrency: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.MaxErrors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxerrors
     * @external
     */
    readonly maxErrors: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Priority`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-priority
     * @external
     */
    readonly priority: number;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-targets
     * @external
     */
    readonly targets: Array<CfnMaintenanceWindowTask.TargetProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskarn
     * @external
     */
    readonly taskArn: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-tasktype
     * @external
     */
    readonly taskType: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.WindowId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-windowid
     * @external
     */
    readonly windowId: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.LoggingInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-logginginfo
     * @external
     */
    readonly loggingInfo?: CfnMaintenanceWindowTask.LoggingInfoProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.ServiceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-servicerolearn
     * @external
     */
    readonly serviceRoleArn?: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskInvocationParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters
     * @external
     */
    readonly taskInvocationParameters?: CfnMaintenanceWindowTask.TaskInvocationParametersProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskparameters
     * @external
     */
    readonly taskParameters?: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 */
export declare class CfnMaintenanceWindowTask extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindowTask";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMaintenanceWindowTask;
    /**
     * `AWS::SSM::MaintenanceWindowTask.MaxConcurrency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxconcurrency
     * @external
     */
    maxConcurrency: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.MaxErrors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxerrors
     * @external
     */
    maxErrors: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Priority`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-priority
     * @external
     */
    priority: number;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-targets
     * @external
     */
    targets: Array<CfnMaintenanceWindowTask.TargetProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskarn
     * @external
     */
    taskArn: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-tasktype
     * @external
     */
    taskType: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.WindowId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-windowid
     * @external
     */
    windowId: string;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.LoggingInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-logginginfo
     * @external
     */
    loggingInfo: CfnMaintenanceWindowTask.LoggingInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.ServiceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-servicerolearn
     * @external
     */
    serviceRoleArn: string | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskInvocationParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters
     * @external
     */
    taskInvocationParameters: CfnMaintenanceWindowTask.TaskInvocationParametersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::MaintenanceWindowTask.TaskParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskparameters
     * @external
     */
    taskParameters: any | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SSM::MaintenanceWindowTask`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMaintenanceWindowTaskProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html
     * @external
     */
    interface LoggingInfoProperty {
        /**
         * `CfnMaintenanceWindowTask.LoggingInfoProperty.Region`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-region
         * @external
         */
        readonly region: string;
        /**
         * `CfnMaintenanceWindowTask.LoggingInfoProperty.S3Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-s3bucket
         * @external
         */
        readonly s3Bucket: string;
        /**
         * `CfnMaintenanceWindowTask.LoggingInfoProperty.S3Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-s3prefix
         * @external
         */
        readonly s3Prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html
     * @external
     */
    interface MaintenanceWindowAutomationParametersProperty {
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowAutomationParametersProperty.DocumentVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowautomationparameters-documentversion
         * @external
         */
        readonly documentVersion?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowAutomationParametersProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowautomationparameters-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html
     * @external
     */
    interface MaintenanceWindowLambdaParametersProperty {
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty.ClientContext`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-clientcontext
         * @external
         */
        readonly clientContext?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty.Payload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-payload
         * @external
         */
        readonly payload?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty.Qualifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-qualifier
         * @external
         */
        readonly qualifier?: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html
     * @external
     */
    interface MaintenanceWindowRunCommandParametersProperty {
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-comment
         * @external
         */
        readonly comment?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.DocumentHash`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-documenthash
         * @external
         */
        readonly documentHash?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.DocumentHashType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-documenthashtype
         * @external
         */
        readonly documentHashType?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.NotificationConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-notificationconfig
         * @external
         */
        readonly notificationConfig?: CfnMaintenanceWindowTask.NotificationConfigProperty | cdk.IResolvable;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.OutputS3BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-outputs3bucketname
         * @external
         */
        readonly outputS3BucketName?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.OutputS3KeyPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-outputs3keyprefix
         * @external
         */
        readonly outputS3KeyPrefix?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.ServiceRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-servicerolearn
         * @external
         */
        readonly serviceRoleArn?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty.TimeoutSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-timeoutseconds
         * @external
         */
        readonly timeoutSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html
     * @external
     */
    interface MaintenanceWindowStepFunctionsParametersProperty {
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowStepFunctionsParametersProperty.Input`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters-input
         * @external
         */
        readonly input?: string;
        /**
         * `CfnMaintenanceWindowTask.MaintenanceWindowStepFunctionsParametersProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html
     * @external
     */
    interface NotificationConfigProperty {
        /**
         * `CfnMaintenanceWindowTask.NotificationConfigProperty.NotificationArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationarn
         * @external
         */
        readonly notificationArn: string;
        /**
         * `CfnMaintenanceWindowTask.NotificationConfigProperty.NotificationEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationevents
         * @external
         */
        readonly notificationEvents?: string[];
        /**
         * `CfnMaintenanceWindowTask.NotificationConfigProperty.NotificationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationtype
         * @external
         */
        readonly notificationType?: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html
     * @external
     */
    interface TargetProperty {
        /**
         * `CfnMaintenanceWindowTask.TargetProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html#cfn-ssm-maintenancewindowtask-target-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnMaintenanceWindowTask.TargetProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html#cfn-ssm-maintenancewindowtask-target-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 * @external
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 */
export declare namespace CfnMaintenanceWindowTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html
     * @external
     */
    interface TaskInvocationParametersProperty {
        /**
         * `CfnMaintenanceWindowTask.TaskInvocationParametersProperty.MaintenanceWindowAutomationParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowautomationparameters
         * @external
         */
        readonly maintenanceWindowAutomationParameters?: CfnMaintenanceWindowTask.MaintenanceWindowAutomationParametersProperty | cdk.IResolvable;
        /**
         * `CfnMaintenanceWindowTask.TaskInvocationParametersProperty.MaintenanceWindowLambdaParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowlambdaparameters
         * @external
         */
        readonly maintenanceWindowLambdaParameters?: CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty | cdk.IResolvable;
        /**
         * `CfnMaintenanceWindowTask.TaskInvocationParametersProperty.MaintenanceWindowRunCommandParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowruncommandparameters
         * @external
         */
        readonly maintenanceWindowRunCommandParameters?: CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty | cdk.IResolvable;
        /**
         * `CfnMaintenanceWindowTask.TaskInvocationParametersProperty.MaintenanceWindowStepFunctionsParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowstepfunctionsparameters
         * @external
         */
        readonly maintenanceWindowStepFunctionsParameters?: CfnMaintenanceWindowTask.MaintenanceWindowStepFunctionsParametersProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::SSM::Parameter`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html
 * @external
 */
export interface CfnParameterProps {
    /**
     * `AWS::SSM::Parameter.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::SSM::Parameter.Value`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-value
     * @external
     */
    readonly value: string;
    /**
     * `AWS::SSM::Parameter.AllowedPattern`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-allowedpattern
     * @external
     */
    readonly allowedPattern?: string;
    /**
     * `AWS::SSM::Parameter.DataType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-datatype
     * @external
     */
    readonly dataType?: string;
    /**
     * `AWS::SSM::Parameter.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::SSM::Parameter.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::SSM::Parameter.Policies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-policies
     * @external
     */
    readonly policies?: string;
    /**
     * `AWS::SSM::Parameter.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::SSM::Parameter.Tier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-tier
     * @external
     */
    readonly tier?: string;
}
/**
 * A CloudFormation `AWS::SSM::Parameter`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html
 * @external
 * @cloudformationResource AWS::SSM::Parameter
 */
export declare class CfnParameter extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Parameter";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnParameter;
    /**
     * @external
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * @external
     * @cloudformationAttribute Value
     */
    readonly attrValue: string;
    /**
     * `AWS::SSM::Parameter.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-type
     * @external
     */
    type: string;
    /**
     * `AWS::SSM::Parameter.Value`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-value
     * @external
     */
    value: string;
    /**
     * `AWS::SSM::Parameter.AllowedPattern`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-allowedpattern
     * @external
     */
    allowedPattern: string | undefined;
    /**
     * `AWS::SSM::Parameter.DataType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-datatype
     * @external
     */
    dataType: string | undefined;
    /**
     * `AWS::SSM::Parameter.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::SSM::Parameter.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::SSM::Parameter.Policies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-policies
     * @external
     */
    policies: string | undefined;
    /**
     * `AWS::SSM::Parameter.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SSM::Parameter.Tier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html#cfn-ssm-parameter-tier
     * @external
     */
    tier: string | undefined;
    /**
     * Create a new `AWS::SSM::Parameter`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnParameterProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SSM::PatchBaseline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 * @external
 */
export interface CfnPatchBaselineProps {
    /**
     * `AWS::SSM::PatchBaseline.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::SSM::PatchBaseline.ApprovalRules`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvalrules
     * @external
     */
    readonly approvalRules?: CfnPatchBaseline.RuleGroupProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatches`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatches
     * @external
     */
    readonly approvedPatches?: string[];
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatchesComplianceLevel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchescompliancelevel
     * @external
     */
    readonly approvedPatchesComplianceLevel?: string;
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatchesEnableNonSecurity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchesenablenonsecurity
     * @external
     */
    readonly approvedPatchesEnableNonSecurity?: boolean | cdk.IResolvable;
    /**
     * `AWS::SSM::PatchBaseline.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::SSM::PatchBaseline.GlobalFilters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-globalfilters
     * @external
     */
    readonly globalFilters?: CfnPatchBaseline.PatchFilterGroupProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::PatchBaseline.OperatingSystem`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-operatingsystem
     * @external
     */
    readonly operatingSystem?: string;
    /**
     * `AWS::SSM::PatchBaseline.PatchGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-patchgroups
     * @external
     */
    readonly patchGroups?: string[];
    /**
     * `AWS::SSM::PatchBaseline.RejectedPatches`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatches
     * @external
     */
    readonly rejectedPatches?: string[];
    /**
     * `AWS::SSM::PatchBaseline.RejectedPatchesAction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatchesaction
     * @external
     */
    readonly rejectedPatchesAction?: string;
    /**
     * `AWS::SSM::PatchBaseline.Sources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-sources
     * @external
     */
    readonly sources?: Array<CfnPatchBaseline.PatchSourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SSM::PatchBaseline.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 */
export declare class CfnPatchBaseline extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::PatchBaseline";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPatchBaseline;
    /**
     * `AWS::SSM::PatchBaseline.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-name
     * @external
     */
    name: string;
    /**
     * `AWS::SSM::PatchBaseline.ApprovalRules`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvalrules
     * @external
     */
    approvalRules: CfnPatchBaseline.RuleGroupProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatches`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatches
     * @external
     */
    approvedPatches: string[] | undefined;
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatchesComplianceLevel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchescompliancelevel
     * @external
     */
    approvedPatchesComplianceLevel: string | undefined;
    /**
     * `AWS::SSM::PatchBaseline.ApprovedPatchesEnableNonSecurity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-approvedpatchesenablenonsecurity
     * @external
     */
    approvedPatchesEnableNonSecurity: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::PatchBaseline.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::SSM::PatchBaseline.GlobalFilters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-globalfilters
     * @external
     */
    globalFilters: CfnPatchBaseline.PatchFilterGroupProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::PatchBaseline.OperatingSystem`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-operatingsystem
     * @external
     */
    operatingSystem: string | undefined;
    /**
     * `AWS::SSM::PatchBaseline.PatchGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-patchgroups
     * @external
     */
    patchGroups: string[] | undefined;
    /**
     * `AWS::SSM::PatchBaseline.RejectedPatches`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatches
     * @external
     */
    rejectedPatches: string[] | undefined;
    /**
     * `AWS::SSM::PatchBaseline.RejectedPatchesAction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-rejectedpatchesaction
     * @external
     */
    rejectedPatchesAction: string | undefined;
    /**
     * `AWS::SSM::PatchBaseline.Sources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-sources
     * @external
     */
    sources: Array<CfnPatchBaseline.PatchSourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::PatchBaseline.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html#cfn-ssm-patchbaseline-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SSM::PatchBaseline`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPatchBaselineProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 */
export declare namespace CfnPatchBaseline {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html
     * @external
     */
    interface PatchFilterProperty {
        /**
         * `CfnPatchBaseline.PatchFilterProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html#cfn-ssm-patchbaseline-patchfilter-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnPatchBaseline.PatchFilterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfilter.html#cfn-ssm-patchbaseline-patchfilter-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 */
export declare namespace CfnPatchBaseline {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfiltergroup.html
     * @external
     */
    interface PatchFilterGroupProperty {
        /**
         * `CfnPatchBaseline.PatchFilterGroupProperty.PatchFilters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchfiltergroup.html#cfn-ssm-patchbaseline-patchfiltergroup-patchfilters
         * @external
         */
        readonly patchFilters?: Array<CfnPatchBaseline.PatchFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 */
export declare namespace CfnPatchBaseline {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html
     * @external
     */
    interface PatchSourceProperty {
        /**
         * `CfnPatchBaseline.PatchSourceProperty.Configuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-configuration
         * @external
         */
        readonly configuration?: string;
        /**
         * `CfnPatchBaseline.PatchSourceProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnPatchBaseline.PatchSourceProperty.Products`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-patchsource.html#cfn-ssm-patchbaseline-patchsource-products
         * @external
         */
        readonly products?: string[];
    }
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 */
export declare namespace CfnPatchBaseline {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html
     * @external
     */
    interface RuleProperty {
        /**
         * `CfnPatchBaseline.RuleProperty.ApproveAfterDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-approveafterdays
         * @external
         */
        readonly approveAfterDays?: number;
        /**
         * `CfnPatchBaseline.RuleProperty.ApproveUntilDate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-approveuntildate
         * @external
         */
        readonly approveUntilDate?: string;
        /**
         * `CfnPatchBaseline.RuleProperty.ComplianceLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-compliancelevel
         * @external
         */
        readonly complianceLevel?: string;
        /**
         * `CfnPatchBaseline.RuleProperty.EnableNonSecurity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-enablenonsecurity
         * @external
         */
        readonly enableNonSecurity?: boolean | cdk.IResolvable;
        /**
         * `CfnPatchBaseline.RuleProperty.PatchFilterGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rule.html#cfn-ssm-patchbaseline-rule-patchfiltergroup
         * @external
         */
        readonly patchFilterGroup?: CfnPatchBaseline.PatchFilterGroupProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 * @external
 * @cloudformationResource AWS::SSM::PatchBaseline
 */
export declare namespace CfnPatchBaseline {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rulegroup.html
     * @external
     */
    interface RuleGroupProperty {
        /**
         * `CfnPatchBaseline.RuleGroupProperty.PatchRules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-patchbaseline-rulegroup.html#cfn-ssm-patchbaseline-rulegroup-patchrules
         * @external
         */
        readonly patchRules?: Array<CfnPatchBaseline.RuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::SSM::ResourceDataSync`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 * @external
 */
export interface CfnResourceDataSyncProps {
    /**
     * `AWS::SSM::ResourceDataSync.SyncName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncname
     * @external
     */
    readonly syncName: string;
    /**
     * `AWS::SSM::ResourceDataSync.BucketName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketname
     * @external
     */
    readonly bucketName?: string;
    /**
     * `AWS::SSM::ResourceDataSync.BucketPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketprefix
     * @external
     */
    readonly bucketPrefix?: string;
    /**
     * `AWS::SSM::ResourceDataSync.BucketRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketregion
     * @external
     */
    readonly bucketRegion?: string;
    /**
     * `AWS::SSM::ResourceDataSync.KMSKeyArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-kmskeyarn
     * @external
     */
    readonly kmsKeyArn?: string;
    /**
     * `AWS::SSM::ResourceDataSync.S3Destination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-s3destination
     * @external
     */
    readonly s3Destination?: CfnResourceDataSync.S3DestinationProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::ResourceDataSync.SyncFormat`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncformat
     * @external
     */
    readonly syncFormat?: string;
    /**
     * `AWS::SSM::ResourceDataSync.SyncSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncsource
     * @external
     */
    readonly syncSource?: CfnResourceDataSync.SyncSourceProperty | cdk.IResolvable;
    /**
     * `AWS::SSM::ResourceDataSync.SyncType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-synctype
     * @external
     */
    readonly syncType?: string;
}
/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 * @external
 * @cloudformationResource AWS::SSM::ResourceDataSync
 */
export declare class CfnResourceDataSync extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SSM::ResourceDataSync";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnResourceDataSync;
    /**
     * `AWS::SSM::ResourceDataSync.SyncName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncname
     * @external
     */
    syncName: string;
    /**
     * `AWS::SSM::ResourceDataSync.BucketName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketname
     * @external
     */
    bucketName: string | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.BucketPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketprefix
     * @external
     */
    bucketPrefix: string | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.BucketRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketregion
     * @external
     */
    bucketRegion: string | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.KMSKeyArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-kmskeyarn
     * @external
     */
    kmsKeyArn: string | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.S3Destination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-s3destination
     * @external
     */
    s3Destination: CfnResourceDataSync.S3DestinationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.SyncFormat`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncformat
     * @external
     */
    syncFormat: string | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.SyncSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncsource
     * @external
     */
    syncSource: CfnResourceDataSync.SyncSourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SSM::ResourceDataSync.SyncType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-synctype
     * @external
     */
    syncType: string | undefined;
    /**
     * Create a new `AWS::SSM::ResourceDataSync`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceDataSyncProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 * @external
 * @cloudformationResource AWS::SSM::ResourceDataSync
 */
export declare namespace CfnResourceDataSync {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-awsorganizationssource.html
     * @external
     */
    interface AwsOrganizationsSourceProperty {
        /**
         * `CfnResourceDataSync.AwsOrganizationsSourceProperty.OrganizationSourceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-awsorganizationssource.html#cfn-ssm-resourcedatasync-awsorganizationssource-organizationsourcetype
         * @external
         */
        readonly organizationSourceType: string;
        /**
         * `CfnResourceDataSync.AwsOrganizationsSourceProperty.OrganizationalUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-awsorganizationssource.html#cfn-ssm-resourcedatasync-awsorganizationssource-organizationalunits
         * @external
         */
        readonly organizationalUnits?: string[];
    }
}
/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 * @external
 * @cloudformationResource AWS::SSM::ResourceDataSync
 */
export declare namespace CfnResourceDataSync {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html
     * @external
     */
    interface S3DestinationProperty {
        /**
         * `CfnResourceDataSync.S3DestinationProperty.BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html#cfn-ssm-resourcedatasync-s3destination-bucketname
         * @external
         */
        readonly bucketName: string;
        /**
         * `CfnResourceDataSync.S3DestinationProperty.BucketPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html#cfn-ssm-resourcedatasync-s3destination-bucketprefix
         * @external
         */
        readonly bucketPrefix?: string;
        /**
         * `CfnResourceDataSync.S3DestinationProperty.BucketRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html#cfn-ssm-resourcedatasync-s3destination-bucketregion
         * @external
         */
        readonly bucketRegion: string;
        /**
         * `CfnResourceDataSync.S3DestinationProperty.KMSKeyArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html#cfn-ssm-resourcedatasync-s3destination-kmskeyarn
         * @external
         */
        readonly kmsKeyArn?: string;
        /**
         * `CfnResourceDataSync.S3DestinationProperty.SyncFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-s3destination.html#cfn-ssm-resourcedatasync-s3destination-syncformat
         * @external
         */
        readonly syncFormat: string;
    }
}
/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 * @external
 * @cloudformationResource AWS::SSM::ResourceDataSync
 */
export declare namespace CfnResourceDataSync {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-syncsource.html
     * @external
     */
    interface SyncSourceProperty {
        /**
         * `CfnResourceDataSync.SyncSourceProperty.AwsOrganizationsSource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-syncsource.html#cfn-ssm-resourcedatasync-syncsource-awsorganizationssource
         * @external
         */
        readonly awsOrganizationsSource?: CfnResourceDataSync.AwsOrganizationsSourceProperty | cdk.IResolvable;
        /**
         * `CfnResourceDataSync.SyncSourceProperty.IncludeFutureRegions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-syncsource.html#cfn-ssm-resourcedatasync-syncsource-includefutureregions
         * @external
         */
        readonly includeFutureRegions?: boolean | cdk.IResolvable;
        /**
         * `CfnResourceDataSync.SyncSourceProperty.SourceRegions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-syncsource.html#cfn-ssm-resourcedatasync-syncsource-sourceregions
         * @external
         */
        readonly sourceRegions: string[];
        /**
         * `CfnResourceDataSync.SyncSourceProperty.SourceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-resourcedatasync-syncsource.html#cfn-ssm-resourcedatasync-syncsource-sourcetype
         * @external
         */
        readonly sourceType: string;
    }
}
