"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesManifest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
const PRUNE_LABEL_PREFIX = 'aws.cdk.eks/prune-';
/**
 * Represents a manifest within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addManifest(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the manifest using `kubectl`.
 *
 * @stability stable
 */
class KubernetesManifest extends core_2.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        const prune = (_b = props.prune) !== null && _b !== void 0 ? _b : props.cluster.prune;
        const pruneLabel = prune
            ? this.injectPruneLabel(props.manifest)
            : undefined;
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesManifest.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                PruneLabel: pruneLabel,
                Overwrite: props.overwrite,
                SkipValidation: props.skipValidation,
            },
        });
    }
    /**
     * Injects a generated prune label to all resources in this manifest. The
     * label name will be `awscdk.eks/manifest-ADDR` where `ADDR` is the address
     * of the construct in the construct tree.
     *
     * @returns the label name
     */
    injectPruneLabel(manifest) {
        // max label name is 64 chars and addrs is always 42.
        const pruneLabel = PRUNE_LABEL_PREFIX + constructs_1.Node.of(this).addr;
        for (const resource of manifest) {
            // skip resource if it's not an object or if it does not have a "kind"
            if (typeof (resource) !== 'object' || !resource.kind) {
                continue;
            }
            if (!resource.metadata) {
                resource.metadata = {};
            }
            if (!resource.metadata.labels) {
                resource.metadata.labels = {};
            }
            resource.metadata.labels = {
                [pruneLabel]: '',
                ...resource.metadata.labels,
            };
        }
        return pruneLabel;
    }
}
exports.KubernetesManifest = KubernetesManifest;
_a = JSII_RTTI_SYMBOL_1;
KubernetesManifest[_a] = { fqn: "@aws-cdk/aws-eks.KubernetesManifest", version: "1.108.1" };
/**
 * The CloudFormation reosurce type.
 *
 * @stability stable
 */
KubernetesManifest.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,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