# cythereal-magic
 The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False. 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1
- Package version: 1.27.2
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [http://cythereal.com](http://cythereal.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install 'git+https://bitbucket.org/cythereal/magic-clients.git@v1#egg=cythereal_magic&subdirectory=clients/python'
```
(you may need to run `pip` with root permission: `sudo pip install 'git+https://bitbucket.org/cythereal/magic-clients.git@v1#egg=cythereal_magic&subdirectory=clients/python'`)

Then import the package:
```python
import cythereal_magic 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cythereal_magic
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import cythereal_magic
from cythereal_magic.rest import ApiException
from pprint import pprint

# Configure API key authorization: api_key_query_param
configuration = cythereal_magic.Configuration()
configuration.api_key['key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['key'] = 'Bearer'

# create an instance of the API class
api_instance = cythereal_magic.AlphaApi(cythereal_magic.ApiClient(configuration))
binary_id = ['binary_id_example'] # list[str] | The SHA1 of the binary to add to your collection. Specify parameter multiple times to add multiple binaries.  Only public binaries will be added. The list of successfully added binaries will be in the 'data' key 

try:
    # Add public binaries to your account
    api_response = api_instance.add_binary(binary_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AlphaApi->add_binary: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.magic.cythereal.com/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlphaApi* | [**add_binary**](docs/AlphaApi.md#add_binary) | **GET** /files/add/ | Add public binaries to your account
*AlphaApi* | [**check_access**](docs/AlphaApi.md#check_access) | **GET** /files/{file_hash}/check_access | Returns a success if the user has access to this file
*AlphaApi* | [**get_campaign_info**](docs/AlphaApi.md#get_campaign_info) | **GET** /campaigns/{campaign_id}/ | List available information for the campaign id
*AlphaApi* | [**get_campaign_members**](docs/AlphaApi.md#get_campaign_members) | **GET** /campaigns/{campaign_id}/members | Members of the campaign
*AlphaApi* | [**get_email**](docs/AlphaApi.md#get_email) | **GET** /iocs/emails/{email_id}/ | Returns a specific email
*AlphaApi* | [**get_emails**](docs/AlphaApi.md#get_emails) | **GET** /iocs/emails/ | Returns all emails connected to the user
*AlphaApi* | [**get_file_iocs**](docs/AlphaApi.md#get_file_iocs) | **GET** /iocs/files/{file_hash}/ | Returns iocs extracted from an uploaded csv/txt/xml file
*AlphaApi* | [**get_file_status**](docs/AlphaApi.md#get_file_status) | **GET** /files/{file_hash}/status/ | Get processing status of the file.
*AlphaApi* | [**get_ioc_files**](docs/AlphaApi.md#get_ioc_files) | **GET** /iocs/files/ | Returns all uploaded csv/txt/xml ioc files
*AlphaApi* | [**get_iocs**](docs/AlphaApi.md#get_iocs) | **GET** /iocs/ | List iocs owned by the authenticated user.
*AlphaApi* | [**get_magic_yara**](docs/AlphaApi.md#get_magic_yara) | **GET** /signatures/magic_yara/ | \&quot;Generate a yara rule, and campaign information for  the provided binaries.\&quot; 
*AlphaApi* | [**get_procedure_signatures**](docs/AlphaApi.md#get_procedure_signatures) | **GET** /signatures/procedures/ | Generate procedure signatures for provided binaries.
*AlphaApi* | [**get_procedures_report**](docs/AlphaApi.md#get_procedures_report) | **GET** /procedures/{proc_hash}/report | Generate the report for the given procedures
*AlphaApi* | [**get_yara_rule**](docs/AlphaApi.md#get_yara_rule) | **GET** /signatures/yara/ | Generate a yara rule for the provided binaries.
*AlphaApi* | [**make_file_public**](docs/AlphaApi.md#make_file_public) | **GET** /files/{file_hash}/make_public | Allows a user to make their file public
*AlphaApi* | [**upload_iocs_file**](docs/AlphaApi.md#upload_iocs_file) | **POST** /iocs/files/ | Upload a text or csv file for IoC Extraction
*CytherealMagicApi* | [**create_file**](docs/CytherealMagicApi.md#create_file) | **POST** /files/ | Upload a file for processing
*CytherealMagicApi* | [**download_file**](docs/CytherealMagicApi.md#download_file) | **GET** /files/{file_hash} | Download a file
*CytherealMagicApi* | [**get_binary_genomics**](docs/CytherealMagicApi.md#get_binary_genomics) | **GET** /genomics/{file_hash}/ | Show the genomic features for a given binary.
*CytherealMagicApi* | [**get_campaign_id**](docs/CytherealMagicApi.md#get_campaign_id) | **GET** /reports/{file_hash}/campaign | Get the campaign id for a binary.
*CytherealMagicApi* | [**get_file_details**](docs/CytherealMagicApi.md#get_file_details) | **GET** /files/{file_hash}/details | Get additional details about certain filetypes
*CytherealMagicApi* | [**get_file_info**](docs/CytherealMagicApi.md#get_file_info) | **GET** /files/{file_hash}/info/ | Get file info and analysis status
*CytherealMagicApi* | [**get_owned_files**](docs/CytherealMagicApi.md#get_owned_files) | **GET** /files/ | List files owned by the authenticated user.
*CytherealMagicApi* | [**get_procedure_genomics**](docs/CytherealMagicApi.md#get_procedure_genomics) | **GET** /genomics/{file_hash}/{proc_rva}/ | Show the genomic features for a given procedure.
*CytherealMagicApi* | [**get_report**](docs/CytherealMagicApi.md#get_report) | **GET** /reports/{file_hash}/ | Get the Magic report for a binary.
*CytherealMagicApi* | [**get_report_categories**](docs/CytherealMagicApi.md#get_report_categories) | **GET** /reports/{file_hash}/categories/ | Retrieve the MAGIC categories for a binary.
*CytherealMagicApi* | [**get_report_labels**](docs/CytherealMagicApi.md#get_report_labels) | **GET** /reports/{file_hash}/labels/ | Retrieve the MAGIC labels report for a binary.
*CytherealMagicApi* | [**get_report_matches**](docs/CytherealMagicApi.md#get_report_matches) | **GET** /reports/{file_hash}/matches/ | Retrieve the MAGIC matches for a binary.
*CytherealMagicApi* | [**get_similar_binaries**](docs/CytherealMagicApi.md#get_similar_binaries) | **GET** /similarities/{file_hash}/ | Search for similar binaries.
*CytherealMagicApi* | [**get_similar_procedures**](docs/CytherealMagicApi.md#get_similar_procedures) | **GET** /similarities/{file_hash}/{proc_rva}/ | Search for procedures similar to a given procedure.
*CytherealMagicApi* | [**ping**](docs/CytherealMagicApi.md#ping) | **GET** /ping/ | Check if server is responding to queries.
*CytherealMagicApi* | [**reprocess_file**](docs/CytherealMagicApi.md#reprocess_file) | **GET** /files/{file_hash}/reprocess/ | Reprocess a previously uploaded file


## Documentation For Models

 - [AnalysisStatus](docs/AnalysisStatus.md)
 - [ApiResponse](docs/ApiResponse.md)
 - [BinaryGenomics](docs/BinaryGenomics.md)
 - [BinarySimilarity](docs/BinarySimilarity.md)
 - [BinarySimilarityBinaries](docs/BinarySimilarityBinaries.md)
 - [BlockGenomics](docs/BlockGenomics.md)
 - [CampaignId](docs/CampaignId.md)
 - [CampaignInfoResponseData](docs/CampaignInfoResponseData.md)
 - [CampaignInfoResponseLinks](docs/CampaignInfoResponseLinks.md)
 - [CampaignMembersResponseData](docs/CampaignMembersResponseData.md)
 - [CampaignMembersResponseDataMembers](docs/CampaignMembersResponseDataMembers.md)
 - [ChildInfo](docs/ChildInfo.md)
 - [ControlFlowGraph](docs/ControlFlowGraph.md)
 - [EmailObject](docs/EmailObject.md)
 - [EmailsList](docs/EmailsList.md)
 - [EmailsListInner](docs/EmailsListInner.md)
 - [EmailsListInnerAttachmentFiles](docs/EmailsListInnerAttachmentFiles.md)
 - [EmailsListInnerIocObjects](docs/EmailsListInnerIocObjects.md)
 - [FileAdded](docs/FileAdded.md)
 - [FileInfo](docs/FileInfo.md)
 - [FileStatus](docs/FileStatus.md)
 - [FileUploadResponseData](docs/FileUploadResponseData.md)
 - [FilesList](docs/FilesList.md)
 - [FilesListFiles](docs/FilesListFiles.md)
 - [IoCObject](docs/IoCObject.md)
 - [IoCsList](docs/IoCsList.md)
 - [IocFileResponseData](docs/IocFileResponseData.md)
 - [IocFilesResponseData](docs/IocFilesResponseData.md)
 - [MagicCategories](docs/MagicCategories.md)
 - [MagicCategory](docs/MagicCategory.md)
 - [MagicCategoryList](docs/MagicCategoryList.md)
 - [MagicLabel](docs/MagicLabel.md)
 - [MagicLabels](docs/MagicLabels.md)
 - [MagicMatches](docs/MagicMatches.md)
 - [MagicMatchesMatchSubtypes](docs/MagicMatchesMatchSubtypes.md)
 - [MagicMatchesMatches](docs/MagicMatchesMatches.md)
 - [MagicReport](docs/MagicReport.md)
 - [MagicReportDetectionStats](docs/MagicReportDetectionStats.md)
 - [MagicYaraResponseData](docs/MagicYaraResponseData.md)
 - [ProcedureGenomics](docs/ProcedureGenomics.md)
 - [ProcedureInfoList](docs/ProcedureInfoList.md)
 - [ProcedureInfoListInner](docs/ProcedureInfoListInner.md)
 - [ProcedureInfoListInnerBlocks](docs/ProcedureInfoListInnerBlocks.md)
 - [ProcedureReportResponseData](docs/ProcedureReportResponseData.md)
 - [ProcedureSignature](docs/ProcedureSignature.md)
 - [ProcedureSignatureList](docs/ProcedureSignatureList.md)
 - [ProcedureSignaturesResponseData](docs/ProcedureSignaturesResponseData.md)
 - [ProcedureSimilarity](docs/ProcedureSimilarity.md)
 - [ProcedureSimilarityProcedures](docs/ProcedureSimilarityProcedures.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [SuccessResponse](docs/SuccessResponse.md)
 - [BinaryGenomicsResponse](docs/BinaryGenomicsResponse.md)
 - [BinarySimilarityResponse](docs/BinarySimilarityResponse.md)
 - [CampaignIdResponse](docs/CampaignIdResponse.md)
 - [CampaignInfoResponse](docs/CampaignInfoResponse.md)
 - [CampaignMembersResponse](docs/CampaignMembersResponse.md)
 - [EmailResponse](docs/EmailResponse.md)
 - [EmailsResponse](docs/EmailsResponse.md)
 - [FileDetailsResponse](docs/FileDetailsResponse.md)
 - [FileInfoResponse](docs/FileInfoResponse.md)
 - [FileStatusResponse](docs/FileStatusResponse.md)
 - [FileUploadResponse](docs/FileUploadResponse.md)
 - [FilesAddedResponse](docs/FilesAddedResponse.md)
 - [IoCUploadResponse](docs/IoCUploadResponse.md)
 - [IoCsListResponse](docs/IoCsListResponse.md)
 - [IocFileResponse](docs/IocFileResponse.md)
 - [IocFilesResponse](docs/IocFilesResponse.md)
 - [MagicCategoriesResponse](docs/MagicCategoriesResponse.md)
 - [MagicLabelsResponse](docs/MagicLabelsResponse.md)
 - [MagicMatchesResponse](docs/MagicMatchesResponse.md)
 - [MagicReportResponse](docs/MagicReportResponse.md)
 - [MagicYaraResponse](docs/MagicYaraResponse.md)
 - [OwnedFilesListResponse](docs/OwnedFilesListResponse.md)
 - [ProcedureGenomicsResponse](docs/ProcedureGenomicsResponse.md)
 - [ProcedureReportResponse](docs/ProcedureReportResponse.md)
 - [ProcedureSignaturesResponse](docs/ProcedureSignaturesResponse.md)
 - [ProcedureSimilarityResponse](docs/ProcedureSimilarityResponse.md)


## Documentation For Authorization


## api_key_query_param

- **Type**: API key
- **API key parameter name**: key
- **Location**: URL query string


## Author

support@cythereal.com

