from setuptools import find_packages, setup

with open("README.md", "r", encoding = "utf-8") as fh:
    long_description = fh.read()

setup(
    name = "Predviz",
    version = "0.0.2",
    author = "Alfrethanov Christian Wijaya",
    author_email = "alfrethanovcwjy@gmail.com",
    description = "Visualize the comparison between the Predicted or Forecasted Values generated by any Time-Series Forecasting Models and the Actual Values",
    long_description = long_description,
    long_description_content_type = "text/markdown",
    url = "https://pypi.org/project/Predviz/",
    project_urls = {
        "Repository": "https://github.com/Arckitechttt/Predviz/tree/main"
    },
    classifiers = [
        "Development Status :: 4 - Beta",
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent"
    ],
    package_dir = {"": "src"},
    packages = find_packages(where="src"),
    python_requires = ">=3.8"
)