"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * Represents the filesystem for the Lambda function
 */
class FileSystem {
    /**
     * @param config the FileSystem configurations for the Lambda function
     */
    constructor(config) {
        this.config = config;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_FileSystemConfig(config);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * mount the filesystem from Amazon EFS
     * @param ap the Amazon EFS access point
     * @param mountPath the target path in the lambda runtime environment
     */
    static fromEfsAccessPoint(ap, mountPath) {
        return new FileSystem({
            localMountPath: mountPath,
            arn: ap.accessPointArn,
            dependency: [ap.fileSystem.mountTargetsAvailable],
            connections: ap.fileSystem.connections,
            policies: [
                new iam.PolicyStatement({
                    actions: ['elasticfilesystem:ClientMount'],
                    resources: ['*'],
                    conditions: {
                        StringEquals: {
                            'elasticfilesystem:AccessPointArn': ap.accessPointArn,
                        },
                    },
                }),
                new iam.PolicyStatement({
                    actions: ['elasticfilesystem:ClientWrite'],
                    resources: [core_1.Stack.of(ap).formatArn({
                            service: 'elasticfilesystem',
                            resource: 'file-system',
                            resourceName: ap.fileSystem.fileSystemId,
                        })],
                }),
            ],
        });
    }
}
exports.FileSystem = FileSystem;
_a = JSII_RTTI_SYMBOL_1;
FileSystem[_a] = { fqn: "@aws-cdk/aws-lambda.FileSystem", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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