/**
 * @stability stable
 */
export interface ServerProps {
    /**
     * The command to execute in order to synthesize the CDK app.
     *
     * @stability stable
     */
    readonly appCommand: string;
}
/**
 * @stability stable
 */
export declare class Server {
    private readonly server;
    private readonly appCommand;
    private readonly tmpdir;
    /**
     * @stability stable
     */
    constructor(props: ServerProps);
    /**
     * Starts HTTP server.
     *
     * @param port The port to listen to.
     * @stability stable
     */
    listen(port?: number): Promise<number>;
    /**
     * Stop server.
     *
     * @stability stable
     */
    close(): void;
    private handleRequest;
    private writeInputFile;
}
