"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const bundle_1 = require("@upsetjs/bundle");
function fixSets(sets, elems) {
    if (!sets) {
        return [];
    }
    return bundle_1.asSets(sets.map((set) => Object.assign({}, set, {
        elems: bundle_1.fromIndicesArray(set.elems, elems),
    })));
}
exports.fixSets = fixSets;
function fixCombinations(combinations, sets, elems) {
    if (!combinations) {
        return null;
    }
    if (!Array.isArray(combinations)) {
        return bundle_1.generateCombinations(sets, Object.assign({
            elems,
        }, combinations));
    }
    const lookup = new Map(sets.map((s) => [s.name, s]));
    return bundle_1.asCombinations(combinations.map((set) => Object.assign({}, set, {
        elems: bundle_1.fromIndicesArray(set.elems, elems),
    })), 'composite', (s) => s.set_names.map((si) => lookup.get(si)).filter(Boolean));
}
exports.fixCombinations = fixCombinations;
function resolveSet(set, sets, combinations, elems) {
    if (Array.isArray(set)) {
        return set.map((i) => elems[i]);
    }
    const ss = set;
    if (!ss.type || ss.type === 'set') {
        const s = sets.find((s) => s.name === ss.name);
        if (s) {
            return s;
        }
    }
    return combinations.find((c) => c.name === ss.name);
}
exports.resolveSet = resolveSet;
//# sourceMappingURL=utils.js.map