"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2AutoScalingInstanceRunningScheduler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const scheduler = require("aws-cdk-lib/aws-scheduler");
const constructs_1 = require("constructs");
class Ec2AutoScalingInstanceRunningScheduler extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const account = cdk.Stack.of(this).account;
        //const stackName: string = cdk.Stack.of(this).stackName;
        //const region = cdk.Stack.of(this).region;
        const randomNameKey = crypto.createHash('shake256', { outputLength: 4 })
            .update(`${cdk.Names.uniqueId(scope)}-${cdk.Names.uniqueId(this)}`)
            .digest('hex');
        // 👇EventBridge Scheduler IAM Role
        const schedulerExecutionRole = new iam.Role(this, 'SchedulerExecutionRole', {
            roleName: `ec2-auto-scaling-instance-running-schedule-${randomNameKey}-exec-role`,
            assumedBy: new iam.ServicePrincipal('scheduler.amazonaws.com'),
            inlinePolicies: {
                ['ec2-auto-scaling-desired-capacity-policy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'autoscaling:SetDesiredCapacity',
                            ],
                            resources: [
                                `arn:aws:autoscaling:*:${account}:autoScalingGroup:*:autoScalingGroupName/*`,
                            ],
                        }),
                    ],
                }),
            },
        });
        for (const target of props.targets) {
            // 👇Create random string
            const scheduleNameKey = crypto.createHash('shake256', { outputLength: 4 })
                .update(target.groupName)
                .digest('hex');
            // 👇EventBridge Scheduler for DB Instance Stop
            new scheduler.CfnSchedule(this, `StopSchedule${scheduleNameKey.toUpperCase()}`, {
                name: `auto-stop-ec2-auto-scaling-instance-${scheduleNameKey}-schedule`,
                description: `auto stop ec2 auto scaling group (${target.groupName}) schedule.`,
                state: 'ENABLED',
                //groupName: scheduleGroup.name, // default
                flexibleTimeWindow: {
                    mode: 'OFF',
                },
                scheduleExpressionTimezone: target.stopSchedule.timezone,
                scheduleExpression: (() => {
                    // default: weekday 21:10
                    const minute = target.stopSchedule.minute ?? '10';
                    const hour = target.stopSchedule.hour ?? '21';
                    const week = target.stopSchedule.week ?? 'MON-FRI';
                    return `cron(${minute} ${hour} ? * ${week} *)`;
                })(),
                target: {
                    arn: 'arn:aws:scheduler:::aws-sdk:autoscaling:setDesiredCapacity',
                    roleArn: schedulerExecutionRole.roleArn,
                    input: JSON.stringify({
                        AutoScalingGroupName: target.groupName,
                        DesiredCapacity: 0,
                    }),
                    retryPolicy: {
                        maximumEventAgeInSeconds: 60,
                        maximumRetryAttempts: 0,
                    },
                },
            });
            // 👇EventBridge Scheduler for DB Instance Start
            new scheduler.CfnSchedule(this, `StartSchedule${scheduleNameKey.toUpperCase()}`, {
                name: `auto-start-ec2-auto-scaling-instance-${scheduleNameKey}-schedule`,
                description: `auto start ec2 auto scaling group (${target.groupName}) schedule.`,
                state: 'ENABLED',
                //groupName: scheduleGroup.name, // default
                flexibleTimeWindow: {
                    mode: 'OFF',
                },
                scheduleExpressionTimezone: target.startSchedule.timezone,
                scheduleExpression: (() => {
                    // default: weekday 07:50
                    const minute = target.startSchedule.minute ?? '50';
                    const hour = target.startSchedule.hour ?? '7';
                    const week = target.startSchedule.week ?? 'MON-FRI';
                    return `cron(${minute} ${hour} ? * ${week} *)`;
                })(),
                target: {
                    arn: 'arn:aws:scheduler:::aws-sdk:autoscaling:setDesiredCapacity',
                    roleArn: schedulerExecutionRole.roleArn,
                    input: JSON.stringify({
                        AutoScalingGroupName: target.groupName,
                        DesiredCapacity: target.runningDesiredCapacity,
                    }),
                    retryPolicy: {
                        maximumEventAgeInSeconds: 60,
                        maximumRetryAttempts: 0,
                    },
                },
            });
        }
    }
}
exports.Ec2AutoScalingInstanceRunningScheduler = Ec2AutoScalingInstanceRunningScheduler;
_a = JSII_RTTI_SYMBOL_1;
Ec2AutoScalingInstanceRunningScheduler[_a] = { fqn: "@gammarer/aws-ec2-auto-scaling-instance-running-scheduler.Ec2AutoScalingInstanceRunningScheduler", version: "1.1.6" };
//# sourceMappingURL=data:application/json;base64,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