"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualRouterListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualRouter.
 *
 * @experimental
 */
class VirtualRouterListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static http(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.HTTP, port);
    }
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static http2(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.HTTP2, port);
    }
    /**
     * (experimental) Returns a GRPC Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static grpc(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.GRPC, port);
    }
    /**
     * (experimental) Returns a TCP Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static tcp(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.TCP, port);
    }
}
exports.VirtualRouterListener = VirtualRouterListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualRouterListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualRouterListener", version: "1.105.0" };
class VirtualRouterListenerImpl extends VirtualRouterListener {
    constructor(protocol, port) {
        super();
        this.protocol = protocol;
        this.port = port !== null && port !== void 0 ? port : 8080;
    }
    bind(_scope) {
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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